// Kalles Fraktaler 2
//
//  2014 Karl Runmo ,runmo@hotmail.com
//
// COVERED CODE IS PROVIDED UNDER THIS LICENSE ON AN "AS IS" BASIS, WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
// THAT THE COVERED CODE IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE
// OR NON-INFRINGING. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE COVERED
// CODE IS WITH YOU. SHOULD ANY COVERED CODE PROVE DEFECTIVE IN ANY RESPECT, YOU (NOT
// THE INITIAL DEVELOPER OR ANY OTHER CONTRIBUTOR) ASSUME THE COST OF ANY NECESSARY
// SERVICING, REPAIR OR CORRECTION. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL
// PART OF THIS LICENSE. NO USE OF ANY COVERED CODE IS AUTHORIZED HEREUNDER EXCEPT UNDER
// THIS DISCLAIMER.

#include "CFixedFloat.h"
#include <stdio.h>
#include "..\common\StringVector.h"

static BOOL g_nMaxSignificant=0;
static BOOL isdigit(char c)
{
       return (c>='0' && c<='9');
}
CFixedFloat::CFixedFloat()
{
	m_bSign=FALSE;
	m_nValues=0;
	m_szValue=NULL;
}
CFixedFloat::CFixedFloat(CFixedFloat &bi)
{
	m_bSign = bi.m_bSign;
	m_nValues = bi.m_nValues;
	memcpy(m_pValues,bi.m_pValues,sizeof(FIXEDFLOAT_TYPE)*bi.m_nValues);
	m_szValue=NULL;
}
CFixedFloat::CFixedFloat(char *sz)
{
	m_bSign=FALSE;
	m_nValues=0;
	m_szValue=NULL;
	Parse(sz);
}
CFixedFloat::CFixedFloat(int a)
{
	if(a>=0){
		m_bSign=FALSE;
		m_pValues[0]=a;
	}
	else{
		m_bSign=TRUE;
		m_pValues[0]=-a;
	}
	m_nValues=1;
	m_szValue=NULL;
}
CFixedFloat::CFixedFloat(double a)
{
	m_bSign=(a<0);
	if(a<0)
		a=-a;
	m_nValues=0;
	m_szValue=NULL;
	int nStart=0;
	while((!g_nMaxSignificant || m_nValues<g_nMaxSignificant) && m_nValues<FIXEDFLOAT_ENTRIES && a){
		m_pValues[m_nValues]=(FIXEDFLOAT_TYPE)a;
		a-=m_pValues[m_nValues];
		a*=FIXEDFLOAT_PARTMAX;
		if(!nStart && m_pValues[m_nValues])
			nStart=1;
		else if(nStart)
			nStart++;
		m_nValues++;
		if(nStart>3)
			break;
	}
}
CFixedFloat::~CFixedFloat()
{
	if(m_szValue)
		delete m_szValue;
}
void CFixedFloat::SetMaxSignificant(int nMax)
{
	if(!nMax)
		g_nMaxSignificant=0;
	else{
		g_nMaxSignificant = 3+nMax/FIXEDFLOAT_DIGITS;
		if(g_nMaxSignificant>FIXEDFLOAT_ENTRIES)
			g_nMaxSignificant=FIXEDFLOAT_ENTRIES;
	}
}

BOOL CFixedFloat::Parse(char *sz)
{
	while(*sz=='\t' || *sz==' ' || *sz=='\r' || *sz=='\n')
		sz++;
	m_pValues[0]=0;
	m_nValues=0;
	if(*sz=='-'){
		m_bSign=TRUE;
		sz++;
	}
	else
		m_bSign=FALSE;
	char *szNew = NULL;
	char *e = strstr(sz,"E");
	if(!e)
		e = strstr(sz,"e");
	if(e){
		e++;
		int nExp = atoi(e);
		if(nExp<0){
			nExp++;
			int nNew = strlen(sz)-nExp+10;
			szNew = new char[nNew+256];
			int n=2;
			strcpy(szNew,"0.");
			while(nExp<0 && n<nNew){
				szNew[n++]='0';
				nExp++;
			}
			while(*sz && n<nNew){
				if(*sz=='.'){
					sz++;
					continue;
				}
				else if(!isdigit(*sz))
					break;
				szNew[n++]=*sz;
				sz++;
			}
			szNew[n]=0;
			sz=szNew;
		}
	}
	while(isdigit(*sz)){
		m_nValues=1;
		m_pValues[0]=10*m_pValues[0]+*sz-'0';
		sz++;
	}
	if(*sz=='.'){
		sz++;
		int nMax = FIXEDFLOAT_ENTRIES;
		if(g_nMaxSignificant && nMax>g_nMaxSignificant)
			nMax=g_nMaxSignificant;
		if(m_nValues==0){
			m_pValues[0]=0;
			m_nValues++;
		}
		for(;m_nValues<nMax;m_nValues++){
			m_pValues[m_nValues]=0;
			int i=0;
			while(isdigit(*sz) && i<FIXEDFLOAT_DIGITS){
				m_pValues[m_nValues]=10*m_pValues[m_nValues]+*sz-'0';
				sz++;
				i++;
			}
			if(i<FIXEDFLOAT_DIGITS){
				while(i<FIXEDFLOAT_DIGITS){
					m_pValues[m_nValues]=10*m_pValues[m_nValues];
					i++;
				}
				m_nValues++;
				break;
			}
		}
	}
	if(szNew)
		delete szNew;
	return TRUE;
}
int g_nStrings=0;
char g_szStrings[4][FIXEDFLOAT_ENTRIES*FIXEDFLOAT_DIGITS+256];
char *CFixedFloat::ToText()
{
	int nLen = /*m_nValues*/FIXEDFLOAT_ENTRIES*FIXEDFLOAT_DIGITS+32;
	int nPrevLen=0;
	if(m_szValue){
		nPrevLen = strlen(m_szValue);
		delete m_szValue;
	}
	//m_szValue = new char[nLen+256];
	//char *szRet = m_szValue;
	unsigned int nString = (unsigned int)InterlockedIncrement((LPLONG)&g_nStrings);
	char *szRet = g_szStrings[nString%4];
	if(!m_nValues){
		szRet[0]='0';
		szRet[1]=0;
		return szRet;
	}
	int i, c=0;
	if(m_bSign)
		szRet[c++]='-';
	FIXEDFLOAT_TYPE p;
	for(i=0;i<m_nValues && c<nLen;i++){
		p=FIXEDFLOAT_PARTMAX;
		do{
			p/=10;
			FIXEDFLOAT_TYPE n = m_pValues[i]/p;
			if(!n && !i && p>1)
				continue;
			szRet[c++]=(char)(n%10)+'0';
		}while(p>1);
		if(!i && m_nValues>1)
			szRet[c++]='.';
	}
	if(m_nValues>1){
		while(c && szRet[c-1]=='0')
			c--;
		if(c && szRet[c-1]=='.')
			c--;
	}
	szRet[c]=0;
	return szRet;
}
int CFixedFloat::ToInt()
{
	if(!m_nValues)
		return 0;
	return (int)m_pValues[0];
}
void CFixedFloat::Copy(CFixedFloat &bi)
{
	m_bSign = bi.m_bSign;
	m_nValues = bi.m_nValues;
	memcpy(m_pValues,bi.m_pValues,sizeof(FIXEDFLOAT_TYPE)*bi.m_nValues);
}
double CFixedFloat::ToDouble(int nScaling)
{
	double a=0;
	int n;
	int nStart = 0;
	for(nStart=0;nStart<m_nValues;nStart++)
		if(m_pValues[nStart])
			break;
	nStart+=24/FIXEDFLOAT_DIGITS;
	if(nStart>m_nValues)
		nStart=m_nValues;
	int nMul=0;
	if(nScaling){
		nMul = nScaling%FIXEDFLOAT_DIGITS;
		nScaling/=FIXEDFLOAT_DIGITS;
	}
	for(n=nStart-1;n>=nScaling;n--)
		a = a/FIXEDFLOAT_PARTMAX + m_pValues[n];
	while(nMul){
		a*=10;
		nMul--;
	}
	if(m_bSign)
		a=-a;
	return a;
}
CFixedFloat CFixedFloat::Add(CFixedFloat &A)
{
	CFixedFloat Ret;
	if(A.m_bSign){
		A.m_bSign=0;
		Ret.Copy(Subtract(A));
		A.m_bSign=1;
		return Ret;
	}
	else if(m_bSign){
		m_bSign=0;
		Ret = A.Subtract(*this);
		m_bSign=1;
		return Ret;
	}
	int nLen = m_nValues;
	if(nLen>A.m_nValues)
		nLen=A.m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	int i;
	for(i=0;i<nLen;i++)
		Ret.m_pValues[i] = m_pValues[i]+A.m_pValues[i];
	if(nLen<m_nValues)
		nLen=m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	for(;i<nLen;i++)
		Ret.m_pValues[i] = m_pValues[i];
	if(nLen<A.m_nValues)
		nLen=A.m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	for(;i<nLen;i++)
		Ret.m_pValues[i] = A.m_pValues[i];
	Ret.m_nValues=i;
	for(i=Ret.m_nValues-1;i>0;i--){
		if(Ret.m_pValues[i]>=FIXEDFLOAT_PARTMAX){
			Ret.m_pValues[i-1]+=Ret.m_pValues[i]/FIXEDFLOAT_PARTMAX;
			Ret.m_pValues[i]=Ret.m_pValues[i]%FIXEDFLOAT_PARTMAX;
		}
	}
	return Ret;
}
CFixedFloat CFixedFloat::Subtract(CFixedFloat &A)
{
	CFixedFloat Ret;
	if(m_bSign){
		m_bSign=0;
		Ret = Add(A);
		m_bSign=1;
		Ret.m_bSign=1-Ret.m_bSign;
		return Ret;
	}
	else if(A.m_bSign){
		A.m_bSign=0;
		Ret = Add(A);
		A.m_bSign=1;
		return Ret;
	}
	if(A>*this){
		Ret = A.Subtract(*this);
		Ret.m_bSign=1;
		return Ret;
	}
	int nLen = m_nValues;
	if(nLen>A.m_nValues)
		nLen=A.m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	int i;
	for(i=0;i<nLen;i++)
		Ret.m_pValues[i] = m_pValues[i]-A.m_pValues[i];
	if(nLen<m_nValues)
		nLen=m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	for(;i<nLen;i++)
		Ret.m_pValues[i] = m_pValues[i];
	if(nLen<A.m_nValues)
		nLen=A.m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	for(;i<nLen;i++)
		Ret.m_pValues[i] = -A.m_pValues[i];
	Ret.m_nValues=i;
	for(i=Ret.m_nValues-1;i>0;i--){
		if(Ret.m_pValues[i]<0){
			Ret.m_pValues[i-1]--;
			Ret.m_pValues[i]+=FIXEDFLOAT_PARTMAX;
		}
	}
	return Ret;
}
extern "C" void multiplyAdd(FIXEDFLOAT_TYPE *dst, FIXEDFLOAT_TYPE src1, FIXEDFLOAT_TYPE src2);
extern "C" void multiplyAddTwice(FIXEDFLOAT_TYPE *dst, FIXEDFLOAT_TYPE src1, FIXEDFLOAT_TYPE src2);
extern "C" void divAdd(FIXEDFLOAT_TYPE *dst, FIXEDFLOAT_TYPE *src, FIXEDFLOAT_TYPE divisor);

CFixedFloat CFixedFloat::Multiply(CFixedFloat &A)
{
	CFixedFloat Ret;
	if(g_nMaxSignificant){
		for(;m_nValues<g_nMaxSignificant;m_nValues++)
			m_pValues[m_nValues]=0;
		for(;A.m_nValues<g_nMaxSignificant;A.m_nValues++)
			A.m_pValues[A.m_nValues]=0;
	}
	Ret.m_nValues = m_nValues+A.m_nValues;
	if(g_nMaxSignificant && Ret.m_nValues>g_nMaxSignificant)
		Ret.m_nValues=g_nMaxSignificant;
	else if(Ret.m_nValues>FIXEDFLOAT_ENTRIES)
		Ret.m_nValues=FIXEDFLOAT_ENTRIES;
	memset(Ret.m_pValues,0,sizeof(FIXEDFLOAT_TYPE)*Ret.m_nValues);
	int a, b;
#ifdef _EXPANDED
	switch(g_nMaxSignificant){
	case 1:
		MLoop1(Ret.m_pValues,A);
		break;
	case 2:
		MLoop2(Ret.m_pValues,A);
		break;
	case 3:
		MLoop3(Ret.m_pValues,A);
		break;
	case 4:
		MLoop4(Ret.m_pValues,A);
		break;
	case 5:
		MLoop5(Ret.m_pValues,A);
		break;
	case 6:
		MLoop6(Ret.m_pValues,A);
		break;
	case 7:
		MLoop7(Ret.m_pValues,A);
		break;
	case 8:
		MLoop8(Ret.m_pValues,A);
		break;
	case 9:
		MLoop9(Ret.m_pValues,A);
		break;
	case 10:
		MLoop10(Ret.m_pValues,A);
		break;
	case 11:
		MLoop11(Ret.m_pValues,A);
		break;
	case 12:
		MLoop12(Ret.m_pValues,A);
		break;
	case 13:
		MLoop13(Ret.m_pValues,A);
		break;
	case 14:
		MLoop14(Ret.m_pValues,A);
		break;
	case 15:
		MLoop15(Ret.m_pValues,A);
		break;
	case 16:
		MLoop16(Ret.m_pValues,A);
		break;
	case 17:
		MLoop17(Ret.m_pValues,A);
		break;
	case 18:
		MLoop18(Ret.m_pValues,A);
		break;
	case 19:
		MLoop19(Ret.m_pValues,A);
		break;
	case 20:
		MLoop20(Ret.m_pValues,A);
		break;
	case 21:
		MLoop21(Ret.m_pValues,A);
		break;
	case 22:
		MLoop22(Ret.m_pValues,A);
		break;
	case 23:
		MLoop23(Ret.m_pValues,A);
		break;
	case 24:
		MLoop24(Ret.m_pValues,A);
		break;
	case 25:
		MLoop25(Ret.m_pValues,A);
		break;
	case 26:
		MLoop26(Ret.m_pValues,A);
		break;
	case 27:
		MLoop27(Ret.m_pValues,A);
		break;
	case 28:
		MLoop28(Ret.m_pValues,A);
		break;
	case 29:
		MLoop29(Ret.m_pValues,A);
		break;
	case 30:
		MLoop30(Ret.m_pValues,A);
		break;
	case 31:
		MLoop31(Ret.m_pValues,A);
		break;
	case 32:
		MLoop32(Ret.m_pValues,A);
		break;
	case 33:
		MLoop33(Ret.m_pValues,A);
		break;
	case 34:
		MLoop34(Ret.m_pValues,A);
		break;
	case 35:
		MLoop35(Ret.m_pValues,A);
		break;
	case 36:
		MLoop36(Ret.m_pValues,A);
		break;
	case 37:
		MLoop37(Ret.m_pValues,A);
		break;
	case 38:
		MLoop38(Ret.m_pValues,A);
		break;
	case 39:
		MLoop39(Ret.m_pValues,A);
		break;
	case 40:
		MLoop40(Ret.m_pValues,A);
		break;
	case 41:
		MLoop41(Ret.m_pValues,A);
		break;
	case 42:
		MLoop42(Ret.m_pValues,A);
		break;
	case 43:
		MLoop43(Ret.m_pValues,A);
		break;
	case 44:
		MLoop44(Ret.m_pValues,A);
		break;
	case 45:
		MLoop45(Ret.m_pValues,A);
		break;
	case 46:
		MLoop46(Ret.m_pValues,A);
		break;
	case 47:
		MLoop47(Ret.m_pValues,A);
		break;
	case 48:
		MLoop48(Ret.m_pValues,A);
		break;
	case 49:
		MLoop49(Ret.m_pValues,A);
		break;
	case 50:
		MLoop50(Ret.m_pValues,A);
		break;
	case 51:
		MLoop51(Ret.m_pValues,A);
		break;
	case 52:
		MLoop52(Ret.m_pValues,A);
		break;
	case 53:
		MLoop53(Ret.m_pValues,A);
		break;
	case 54:
		MLoop54(Ret.m_pValues,A);
		break;
	case 55:
		MLoop55(Ret.m_pValues,A);
		break;
	case 56:
		MLoop56(Ret.m_pValues,A);
		break;
	case 57:
		MLoop57(Ret.m_pValues,A);
		break;
	case 58:
		MLoop58(Ret.m_pValues,A);
		break;
	case 59:
		MLoop59(Ret.m_pValues,A);
		break;
	case 60:
		MLoop60(Ret.m_pValues,A);
		break;
	case 61:
		MLoop61(Ret.m_pValues,A);
		break;
	case 62:
		MLoop62(Ret.m_pValues,A);
		break;
	case 63:
		MLoop63(Ret.m_pValues,A);
		break;
	case 64:
		MLoop64(Ret.m_pValues,A);
		break;
	case 65:
		MLoop65(Ret.m_pValues,A);
		break;
	case 66:
		MLoop66(Ret.m_pValues,A);
		break;
	case 67:
		MLoop67(Ret.m_pValues,A);
		break;
	case 68:
		MLoop68(Ret.m_pValues,A);
		break;
	case 69:
		MLoop69(Ret.m_pValues,A);
		break;
	case 70:
		MLoop70(Ret.m_pValues,A);
		break;
	case 71:
		MLoop71(Ret.m_pValues,A);
		break;
	case 72:
		MLoop72(Ret.m_pValues,A);
		break;
	case 73:
		MLoop73(Ret.m_pValues,A);
		break;
	case 74:
		MLoop74(Ret.m_pValues,A);
		break;
	case 75:
		MLoop75(Ret.m_pValues,A);
		break;
	case 76:
		MLoop76(Ret.m_pValues,A);
		break;
	case 77:
		MLoop77(Ret.m_pValues,A);
		break;
	case 78:
		MLoop78(Ret.m_pValues,A);
		break;
	case 79:
		MLoop79(Ret.m_pValues,A);
		break;
	case 80:
		MLoop80(Ret.m_pValues,A);
		break;
	case 81:
		MLoop81(Ret.m_pValues,A);
		break;
	case 82:
		MLoop82(Ret.m_pValues,A);
		break;
	case 83:
		MLoop83(Ret.m_pValues,A);
		break;
	case 84:
		MLoop84(Ret.m_pValues,A);
		break;
	case 85:
		MLoop85(Ret.m_pValues,A);
		break;
	case 86:
		MLoop86(Ret.m_pValues,A);
		break;
	case 87:
		MLoop87(Ret.m_pValues,A);
		break;
	case 88:
		MLoop88(Ret.m_pValues,A);
		break;
	case 89:
		MLoop89(Ret.m_pValues,A);
		break;
	case 90:
		MLoop90(Ret.m_pValues,A);
		break;
	case 91:
		MLoop91(Ret.m_pValues,A);
		break;
	case 92:
		MLoop92(Ret.m_pValues,A);
		break;
	case 93:
		MLoop93(Ret.m_pValues,A);
		break;
	case 94:
		MLoop94(Ret.m_pValues,A);
		break;
	case 95:
		MLoop95(Ret.m_pValues,A);
		break;
	case 96:
		MLoop96(Ret.m_pValues,A);
		break;
	case 97:
		MLoop97(Ret.m_pValues,A);
		break;
	case 98:
		MLoop98(Ret.m_pValues,A);
		break;
	case 99:
		MLoop99(Ret.m_pValues,A);
		break;
	case 100:
		MLoop100(Ret.m_pValues,A);
		break;
	case 101:
		MLoop101(Ret.m_pValues,A);
		break;
	case 102:
		MLoop102(Ret.m_pValues,A);
		break;
	case 103:
		MLoop103(Ret.m_pValues,A);
		break;
	case 104:
		MLoop104(Ret.m_pValues,A);
		break;
	case 105:
		MLoop105(Ret.m_pValues,A);
		break;
	case 106:
		MLoop106(Ret.m_pValues,A);
		break;
	case 107:
		MLoop107(Ret.m_pValues,A);
		break;
	case 108:
		MLoop108(Ret.m_pValues,A);
		break;
	case 109:
		MLoop109(Ret.m_pValues,A);
		break;
	case 110:
		MLoop110(Ret.m_pValues,A);
		break;
	case 111:
		MLoop111(Ret.m_pValues,A);
		break;
	case 112:
		MLoop112(Ret.m_pValues,A);
		break;
	case 113:
		MLoop113(Ret.m_pValues,A);
		break;
	case 114:
		MLoop114(Ret.m_pValues,A);
		break;
	case 115:
		MLoop115(Ret.m_pValues,A);
		break;
	case 116:
		MLoop116(Ret.m_pValues,A);
		break;
	case 117:
		MLoop117(Ret.m_pValues,A);
		break;
	case 118:
		MLoop118(Ret.m_pValues,A);
		break;
	case 119:
		MLoop119(Ret.m_pValues,A);
		break;
	case 120:
		MLoop120(Ret.m_pValues,A);
		break;
	case 121:
		MLoop121(Ret.m_pValues,A);
		break;
	case 122:
		MLoop122(Ret.m_pValues,A);
		break;
	case 123:
		MLoop123(Ret.m_pValues,A);
		break;
	case 124:
		MLoop124(Ret.m_pValues,A);
		break;
	case 125:
		MLoop125(Ret.m_pValues,A);
		break;
	case 126:
		MLoop126(Ret.m_pValues,A);
		break;
	case 127:
		MLoop127(Ret.m_pValues,A);
		break;
	case 128:
		MLoop128(Ret.m_pValues,A);
		break;
	case 129:
		MLoop129(Ret.m_pValues,A);
		break;
	case 130:
		MLoop130(Ret.m_pValues,A);
		break;
	case 131:
		MLoop131(Ret.m_pValues,A);
		break;
	case 132:
		MLoop132(Ret.m_pValues,A);
		break;
	case 133:
		MLoop133(Ret.m_pValues,A);
		break;
	case 134:
		MLoop134(Ret.m_pValues,A);
		break;
	case 135:
		MLoop135(Ret.m_pValues,A);
		break;
	case 136:
		MLoop136(Ret.m_pValues,A);
		break;
	case 137:
		MLoop137(Ret.m_pValues,A);
		break;
	case 138:
		MLoop138(Ret.m_pValues,A);
		break;
	case 139:
		MLoop139(Ret.m_pValues,A);
		break;
	case 140:
		MLoop140(Ret.m_pValues,A);
		break;
	case 141:
		MLoop141(Ret.m_pValues,A);
		break;
	case 142:
		MLoop142(Ret.m_pValues,A);
		break;
	case 143:
		MLoop143(Ret.m_pValues,A);
		break;
	case 144:
		MLoop144(Ret.m_pValues,A);
		break;
	case 145:
		MLoop145(Ret.m_pValues,A);
		break;
	case 146:
		MLoop146(Ret.m_pValues,A);
		break;
	case 147:
		MLoop147(Ret.m_pValues,A);
		break;
	case 148:
		MLoop148(Ret.m_pValues,A);
		break;
	case 149:
		MLoop149(Ret.m_pValues,A);
		break;
	case 150:
		MLoop150(Ret.m_pValues,A);
		break;
	case 151:
		MLoop151(Ret.m_pValues,A);
		break;
	default:
#endif
		for(a=0;a<m_nValues;a++){
			int nEnd = A.m_nValues;
			int nRetEnd = Ret.m_nValues-a;
			if(nEnd>nRetEnd)
				nEnd=nRetEnd;
			int nEndLoop = nEnd-nEnd%16;
			for(b=0;b<nEndLoop;){
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
				b++;
			}
			for(;b<nEnd;b++)
				Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
		}
#ifdef _EXPANDED
	}
#endif
	Ret.m_bSign = !(m_bSign==A.m_bSign);
	int i;
	for(i=Ret.m_nValues-1;i>0;i--){
		if(Ret.m_pValues[i]>=FIXEDFLOAT_PARTMAX){
			Ret.m_pValues[i-1]+=Ret.m_pValues[i]/FIXEDFLOAT_PARTMAX;
			Ret.m_pValues[i]=Ret.m_pValues[i]%FIXEDFLOAT_PARTMAX;
		}
	}
	return Ret;
}
CFixedFloat CFixedFloat::Multiply2(CFixedFloat &A)
{
	CFixedFloat Ret;
	if(g_nMaxSignificant){
		for(;m_nValues<g_nMaxSignificant;m_nValues++)
			m_pValues[m_nValues]=0;
		for(;A.m_nValues<g_nMaxSignificant;A.m_nValues++)
			A.m_pValues[A.m_nValues]=0;
	}
	Ret.m_nValues = m_nValues+A.m_nValues;
	if(g_nMaxSignificant && Ret.m_nValues>g_nMaxSignificant)
		Ret.m_nValues=g_nMaxSignificant;
	else if(Ret.m_nValues>FIXEDFLOAT_ENTRIES)
		Ret.m_nValues=FIXEDFLOAT_ENTRIES;
	memset(Ret.m_pValues,0,sizeof(FIXEDFLOAT_TYPE)*Ret.m_nValues);
	int a, b;
	int nStart, nAStart;
	for(nStart=0;nStart<m_nValues && !m_pValues[nStart];nStart++);
	for(nAStart=0;nAStart<A.m_nValues && !A.m_pValues[nAStart];nAStart++);

	for(a=nStart;a<m_nValues;a++){
		int nEnd = A.m_nValues;
		int nRetEnd = Ret.m_nValues-a;
		if(nEnd>nRetEnd)
			nEnd=nRetEnd;
		for(b=nAStart;b<nEnd;b++)
			Ret.m_pValues[a+b] += m_pValues[a]*A.m_pValues[b];
	}
	Ret.m_bSign = !(m_bSign==A.m_bSign);
	int i;
	for(i=Ret.m_nValues-1;i>0;i--){
		if(Ret.m_pValues[i]>=FIXEDFLOAT_PARTMAX){
			Ret.m_pValues[i-1]+=Ret.m_pValues[i]/FIXEDFLOAT_PARTMAX;
			Ret.m_pValues[i]=Ret.m_pValues[i]%FIXEDFLOAT_PARTMAX;
		}
	}
	return Ret;
}
CFixedFloat CFixedFloat::Divide(CFixedFloat &A)
{
	CDecNumber T = ToText();
	CDecNumber N = A.ToText();
	CDecNumber K = T/N;
	char *sz = K.ToText();
	int i;
	for(i=0;sz[i];i++)
		if(sz[i]!='e' && sz[i]!='E' && isalpha(sz[i])){
			Beep(1000,10);
		}
	CFixedFloat Ret(sz);
	return Ret;
}
CFixedFloat CFixedFloat::Square()
{
	CFixedFloat Ret;
	if(g_nMaxSignificant){
		for(;m_nValues<g_nMaxSignificant;m_nValues++)
			m_pValues[m_nValues]=0;
	}
	Ret.m_nValues = m_nValues+m_nValues;
	if(g_nMaxSignificant && Ret.m_nValues>g_nMaxSignificant)
		Ret.m_nValues=g_nMaxSignificant;
	else if(Ret.m_nValues>FIXEDFLOAT_ENTRIES)
		Ret.m_nValues=FIXEDFLOAT_ENTRIES;
	memset(Ret.m_pValues,0,sizeof(FIXEDFLOAT_TYPE)*Ret.m_nValues);
	int a, b;
#ifdef _EXPANDED
	switch(g_nMaxSignificant){
	case 1:
		SLoop1(Ret.m_pValues);
		break;
	case 2:
		SLoop2(Ret.m_pValues);
		break;
	case 3:
		SLoop3(Ret.m_pValues);
		break;
	case 4:
		SLoop4(Ret.m_pValues);
		break;
	case 5:
		SLoop5(Ret.m_pValues);
		break;
	case 6:
		SLoop6(Ret.m_pValues);
		break;
	case 7:
		SLoop7(Ret.m_pValues);
		break;
	case 8:
		SLoop8(Ret.m_pValues);
		break;
	case 9:
		SLoop9(Ret.m_pValues);
		break;
	case 10:
		SLoop10(Ret.m_pValues);
		break;
	case 11:
		SLoop11(Ret.m_pValues);
		break;
	case 12:
		SLoop12(Ret.m_pValues);
		break;
	case 13:
		SLoop13(Ret.m_pValues);
		break;
	case 14:
		SLoop14(Ret.m_pValues);
		break;
	case 15:
		SLoop15(Ret.m_pValues);
		break;
	case 16:
		SLoop16(Ret.m_pValues);
		break;
	case 17:
		SLoop17(Ret.m_pValues);
		break;
	case 18:
		SLoop18(Ret.m_pValues);
		break;
	case 19:
		SLoop19(Ret.m_pValues);
		break;
	case 20:
		SLoop20(Ret.m_pValues);
		break;
	case 21:
		SLoop21(Ret.m_pValues);
		break;
	case 22:
		SLoop22(Ret.m_pValues);
		break;
	case 23:
		SLoop23(Ret.m_pValues);
		break;
	case 24:
		SLoop24(Ret.m_pValues);
		break;
	case 25:
		SLoop25(Ret.m_pValues);
		break;
	case 26:
		SLoop26(Ret.m_pValues);
		break;
	case 27:
		SLoop27(Ret.m_pValues);
		break;
	case 28:
		SLoop28(Ret.m_pValues);
		break;
	case 29:
		SLoop29(Ret.m_pValues);
		break;
	case 30:
		SLoop30(Ret.m_pValues);
		break;
	case 31:
		SLoop31(Ret.m_pValues);
		break;
	case 32:
		SLoop32(Ret.m_pValues);
		break;
	case 33:
		SLoop33(Ret.m_pValues);
		break;
	case 34:
		SLoop34(Ret.m_pValues);
		break;
	case 35:
		SLoop35(Ret.m_pValues);
		break;
	case 36:
		SLoop36(Ret.m_pValues);
		break;
	case 37:
		SLoop37(Ret.m_pValues);
		break;
	case 38:
		SLoop38(Ret.m_pValues);
		break;
	case 39:
		SLoop39(Ret.m_pValues);
		break;
	case 40:
		SLoop40(Ret.m_pValues);
		break;
	case 41:
		SLoop41(Ret.m_pValues);
		break;
	case 42:
		SLoop42(Ret.m_pValues);
		break;
	case 43:
		SLoop43(Ret.m_pValues);
		break;
	case 44:
		SLoop44(Ret.m_pValues);
		break;
	case 45:
		SLoop45(Ret.m_pValues);
		break;
	case 46:
		SLoop46(Ret.m_pValues);
		break;
	case 47:
		SLoop47(Ret.m_pValues);
		break;
	case 48:
		SLoop48(Ret.m_pValues);
		break;
	case 49:
		SLoop49(Ret.m_pValues);
		break;
	case 50:
		SLoop50(Ret.m_pValues);
		break;
	case 51:
		SLoop51(Ret.m_pValues);
		break;
	case 52:
		SLoop52(Ret.m_pValues);
		break;
	case 53:
		SLoop53(Ret.m_pValues);
		break;
	case 54:
		SLoop54(Ret.m_pValues);
		break;
	case 55:
		SLoop55(Ret.m_pValues);
		break;
	case 56:
		SLoop56(Ret.m_pValues);
		break;
	case 57:
		SLoop57(Ret.m_pValues);
		break;
	case 58:
		SLoop58(Ret.m_pValues);
		break;
	case 59:
		SLoop59(Ret.m_pValues);
		break;
	case 60:
		SLoop60(Ret.m_pValues);
		break;
	case 61:
		SLoop61(Ret.m_pValues);
		break;
	case 62:
		SLoop62(Ret.m_pValues);
		break;
	case 63:
		SLoop63(Ret.m_pValues);
		break;
	case 64:
		SLoop64(Ret.m_pValues);
		break;
	case 65:
		SLoop65(Ret.m_pValues);
		break;
	case 66:
		SLoop66(Ret.m_pValues);
		break;
	case 67:
		SLoop67(Ret.m_pValues);
		break;
	case 68:
		SLoop68(Ret.m_pValues);
		break;
	case 69:
		SLoop69(Ret.m_pValues);
		break;
	case 70:
		SLoop70(Ret.m_pValues);
		break;
	case 71:
		SLoop71(Ret.m_pValues);
		break;
	case 72:
		SLoop72(Ret.m_pValues);
		break;
	case 73:
		SLoop73(Ret.m_pValues);
		break;
	case 74:
		SLoop74(Ret.m_pValues);
		break;
	case 75:
		SLoop75(Ret.m_pValues);
		break;
	case 76:
		SLoop76(Ret.m_pValues);
		break;
	case 77:
		SLoop77(Ret.m_pValues);
		break;
	case 78:
		SLoop78(Ret.m_pValues);
		break;
	case 79:
		SLoop79(Ret.m_pValues);
		break;
	case 80:
		SLoop80(Ret.m_pValues);
		break;
	case 81:
		SLoop81(Ret.m_pValues);
		break;
	case 82:
		SLoop82(Ret.m_pValues);
		break;
	case 83:
		SLoop83(Ret.m_pValues);
		break;
	case 84:
		SLoop84(Ret.m_pValues);
		break;
	case 85:
		SLoop85(Ret.m_pValues);
		break;
	case 86:
		SLoop86(Ret.m_pValues);
		break;
	case 87:
		SLoop87(Ret.m_pValues);
		break;
	case 88:
		SLoop88(Ret.m_pValues);
		break;
	case 89:
		SLoop89(Ret.m_pValues);
		break;
	case 90:
		SLoop90(Ret.m_pValues);
		break;
	case 91:
		SLoop91(Ret.m_pValues);
		break;
	case 92:
		SLoop92(Ret.m_pValues);
		break;
	case 93:
		SLoop93(Ret.m_pValues);
		break;
	case 94:
		SLoop94(Ret.m_pValues);
		break;
	case 95:
		SLoop95(Ret.m_pValues);
		break;
	case 96:
		SLoop96(Ret.m_pValues);
		break;
	case 97:
		SLoop97(Ret.m_pValues);
		break;
	case 98:
		SLoop98(Ret.m_pValues);
		break;
	case 99:
		SLoop99(Ret.m_pValues);
		break;
	case 100:
		SLoop100(Ret.m_pValues);
		break;
	case 101:
		SLoop101(Ret.m_pValues);
		break;
	case 102:
		SLoop102(Ret.m_pValues);
		break;
	case 103:
		SLoop103(Ret.m_pValues);
		break;
	case 104:
		SLoop104(Ret.m_pValues);
		break;
	case 105:
		SLoop105(Ret.m_pValues);
		break;
	case 106:
		SLoop106(Ret.m_pValues);
		break;
	case 107:
		SLoop107(Ret.m_pValues);
		break;
	case 108:
		SLoop108(Ret.m_pValues);
		break;
	case 109:
		SLoop109(Ret.m_pValues);
		break;
	case 110:
		SLoop110(Ret.m_pValues);
		break;
	case 111:
		SLoop111(Ret.m_pValues);
		break;
	case 112:
		SLoop112(Ret.m_pValues);
		break;
	case 113:
		SLoop113(Ret.m_pValues);
		break;
	case 114:
		SLoop114(Ret.m_pValues);
		break;
	case 115:
		SLoop115(Ret.m_pValues);
		break;
	case 116:
		SLoop116(Ret.m_pValues);
		break;
	case 117:
		SLoop117(Ret.m_pValues);
		break;
	case 118:
		SLoop118(Ret.m_pValues);
		break;
	case 119:
		SLoop119(Ret.m_pValues);
		break;
	case 120:
		SLoop120(Ret.m_pValues);
		break;
	case 121:
		SLoop121(Ret.m_pValues);
		break;
	case 122:
		SLoop122(Ret.m_pValues);
		break;
	case 123:
		SLoop123(Ret.m_pValues);
		break;
	case 124:
		SLoop124(Ret.m_pValues);
		break;
	case 125:
		SLoop125(Ret.m_pValues);
		break;
	case 126:
		SLoop126(Ret.m_pValues);
		break;
	case 127:
		SLoop127(Ret.m_pValues);
		break;
	case 128:
		SLoop128(Ret.m_pValues);
		break;
	case 129:
		SLoop129(Ret.m_pValues);
		break;
	case 130:
		SLoop130(Ret.m_pValues);
		break;
	case 131:
		SLoop131(Ret.m_pValues);
		break;
	case 132:
		SLoop132(Ret.m_pValues);
		break;
	case 133:
		SLoop133(Ret.m_pValues);
		break;
	case 134:
		SLoop134(Ret.m_pValues);
		break;
	case 135:
		SLoop135(Ret.m_pValues);
		break;
	case 136:
		SLoop136(Ret.m_pValues);
		break;
	case 137:
		SLoop137(Ret.m_pValues);
		break;
	case 138:
		SLoop138(Ret.m_pValues);
		break;
	case 139:
		SLoop139(Ret.m_pValues);
		break;
	case 140:
		SLoop140(Ret.m_pValues);
		break;
	case 141:
		SLoop141(Ret.m_pValues);
		break;
	case 142:
		SLoop142(Ret.m_pValues);
		break;
	case 143:
		SLoop143(Ret.m_pValues);
		break;
	case 144:
		SLoop144(Ret.m_pValues);
		break;
	case 145:
		SLoop145(Ret.m_pValues);
		break;
	case 146:
		SLoop146(Ret.m_pValues);
		break;
	case 147:
		SLoop147(Ret.m_pValues);
		break;
	case 148:
		SLoop148(Ret.m_pValues);
		break;
	case 149:
		SLoop149(Ret.m_pValues);
		break;
	case 150:
		SLoop150(Ret.m_pValues);
		break;
	case 151:
		SLoop151(Ret.m_pValues);
		break;
	default:
#endif
		for(a=0;a<m_nValues;a++){
			int aa = a+a;
			if(aa<Ret.m_nValues)
				Ret.m_pValues[aa] += m_pValues[a]*m_pValues[a];
			int nEnd = m_nValues;
			if(a+nEnd>Ret.m_nValues)
				nEnd = Ret.m_nValues-a;
			int nEndLoop = nEnd;
			nEndLoop-=(nEndLoop-a-1)%16;
			for(b=a+1;b<nEndLoop;){
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
				b++;
			}
			for(;b<nEnd;b++)
				Ret.m_pValues[a+b] += (m_pValues[a]*m_pValues[b])<<1;
		}
#ifdef _EXPANDED
	}
#endif
	Ret.m_bSign = 0;
	int i;
	for(i=Ret.m_nValues-1;i>0;i--){
		if(Ret.m_pValues[i]>=FIXEDFLOAT_PARTMAX){
			Ret.m_pValues[i-1]+=Ret.m_pValues[i]/FIXEDFLOAT_PARTMAX;
			Ret.m_pValues[i]=Ret.m_pValues[i]%FIXEDFLOAT_PARTMAX;
		}
	}
	return Ret;
}

CFixedFloat CFixedFloat::Double()
{
	int i;
	for(i=0;i<m_nValues;i++)
		m_pValues[i] = m_pValues[i]<<1;
	for(i=m_nValues-1;i>0;i--){
		if(m_pValues[i]>=FIXEDFLOAT_PARTMAX){
			m_pValues[i-1]+=m_pValues[i]/FIXEDFLOAT_PARTMAX;
			m_pValues[i]=m_pValues[i]%FIXEDFLOAT_PARTMAX;
		}
	}
	return *this;
}
CFixedFloat &CFixedFloat::AbsAdd(CFixedFloat &a, CFixedFloat &b)
{
	int as = a.m_bSign;
	a.m_bSign=0;
	int bs = b.m_bSign;
	b.m_bSign=0;
	*this = a+b;
	a.m_bSign=as;
	b.m_bSign=bs;
	return *this;
}

BOOL CFixedFloat::operator >(CFixedFloat &A)
{
	if(!m_bSign && A.m_bSign)
		return TRUE;
	else if(m_bSign && !A.m_bSign)
		return FALSE;
	int i;
	int nLen = m_nValues;
	if(nLen>A.m_nValues)
		nLen=A.m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	for(i=0;i<nLen;i++){
		if(m_pValues[i]>A.m_pValues[i])
			return !m_bSign;
		else if(m_pValues[i]<A.m_pValues[i])
			return m_bSign;
	}
	if(g_nMaxSignificant && nLen==g_nMaxSignificant)
		return FALSE;
	if(m_nValues>A.m_nValues)
		return !m_bSign;
	else if(m_nValues<A.m_nValues)
		return m_bSign;
	return FALSE;
}
BOOL CFixedFloat::operator <(CFixedFloat &A)
{
	if(!m_bSign && A.m_bSign)
		return FALSE;
	else if(m_bSign && !A.m_bSign)
		return TRUE;
	int i;
	int nLen = m_nValues;
	if(nLen>A.m_nValues)
		nLen=A.m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	for(i=0;i<nLen;i++){
		if(m_pValues[i]<A.m_pValues[i])
			return !m_bSign;
		else if(m_pValues[i]>A.m_pValues[i])
			return m_bSign;
	}
	if(g_nMaxSignificant && nLen==g_nMaxSignificant)
		return FALSE;
	if(m_nValues<A.m_nValues)
		return !m_bSign;
	else if(m_nValues>A.m_nValues)
		return m_bSign;
	return FALSE;
}
BOOL CFixedFloat::operator ==(CFixedFloat &A)
{
	if(!m_bSign && A.m_bSign)
		return FALSE;
	else if(m_bSign && !A.m_bSign)
		return TRUE;
	int i;
	int nLen = m_nValues;
	if(nLen>A.m_nValues)
		nLen=A.m_nValues;
	if(g_nMaxSignificant && nLen>g_nMaxSignificant)
		nLen=g_nMaxSignificant;
	for(i=0;i<nLen;i++){
		if(m_pValues[i]!=A.m_pValues[i])
			return FALSE;
	}
	if(g_nMaxSignificant && nLen==g_nMaxSignificant)
		return TRUE;
	if(m_nValues<A.m_nValues)
		return FALSE;
	else if(m_nValues>A.m_nValues)
		return FALSE;
	return TRUE;
}

CFixedFloat &CFixedFloat::operator =(CFixedFloat &bi)
{
	m_bSign = bi.m_bSign;
	m_nValues = bi.m_nValues;
	memcpy(m_pValues,bi.m_pValues,sizeof(FIXEDFLOAT_TYPE)*bi.m_nValues);
	return *this;
}
CFixedFloat &CFixedFloat::operator =(char *sz)
{
	Parse(sz);
	return *this;
}
CFixedFloat &CFixedFloat::operator =(int a)
{
	if(a>=0){
		m_bSign=FALSE;
		m_pValues[0]=a;
	}
	else{
		m_bSign=TRUE;
		m_pValues[0]=-a;
	}
	m_nValues=1;
	return *this;
}
CFixedFloat &CFixedFloat::operator =(double a)
{
	m_bSign=(a<0);
	if(a<0)
		a=-a;
	m_nValues=0;
	int nStart=0;
	while((!g_nMaxSignificant || m_nValues<g_nMaxSignificant) && m_nValues<FIXEDFLOAT_ENTRIES && a){
		m_pValues[m_nValues]=(FIXEDFLOAT_TYPE)a;
		a-=m_pValues[m_nValues];
		a*=FIXEDFLOAT_PARTMAX;
		if(!nStart && m_pValues[m_nValues])
			nStart=1;
		else if(nStart)
			nStart++;
		m_nValues++;
		if(nStart>3)
			break;
	}
	return *this;
}

CFixedFloat CFixedFloat::operator *(CFixedFloat &A)
{
	if(this==&A)
		return Square();
	return Multiply(A);
}
CFixedFloat CFixedFloat::operator /(CFixedFloat &A)
{
	return Divide(A);
}
CFixedFloat CFixedFloat::operator +(CFixedFloat &A)
{
	return Add(A);
}
CFixedFloat CFixedFloat::operator -(CFixedFloat &A)
{
	return Subtract(A);
}
CFixedFloat CFixedFloat::operator -()
{
	CFixedFloat Ret = *this;
	Ret.m_bSign=1-Ret.m_bSign;
	return Ret;
}

CFixedFloat &CFixedFloat::operator*=(CFixedFloat &B)
{
	if(this==&B)
		*this = Square();
	else
		*this = Multiply(B);
	return *this;
}
CFixedFloat &CFixedFloat::operator/=(CFixedFloat &B)
{
	*this = Divide(B);
	return *this;
}
CFixedFloat &CFixedFloat::operator+=(CFixedFloat &B)
{
	*this = Add(B);
	return *this;
}
CFixedFloat &CFixedFloat::operator-=(CFixedFloat &B)
{
	*this = Subtract(B);
	return *this;
}
CFixedFloat &CFixedFloat::operator*=(int nA)
{
	CFixedFloat A(nA);
	*this = Multiply(A);
	return *this;
}
CFixedFloat &CFixedFloat::operator/=(int nA)
{
	CFixedFloat A(nA);
	*this = Divide(A);
	return *this;
}
CFixedFloat &CFixedFloat::operator+=(int nA)
{
	CFixedFloat A(nA);
	*this = Add(A);
	return *this;
}
CFixedFloat &CFixedFloat::operator-=(int nA)
{
	CFixedFloat A(nA);
	*this = Subtract(A);
	return *this;
}

BOOL operator==(CFixedFloat &A,int nB)
{
	CFixedFloat B(nB);
	return B==A;
}
BOOL operator==(int nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	return B==A;
}
BOOL operator>(CFixedFloat &A,int nB)
{
	CFixedFloat B(nB);
	return A>B;
}
BOOL operator>(int nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	return B>A;
}
BOOL operator>(CFixedFloat &A,double nB)
{
	CFixedFloat B(nB);
	return A>B;
}
BOOL operator>(double nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	return B>A;
}
BOOL operator<(CFixedFloat &A,int nB)
{
	CFixedFloat B(nB);
	return A<B;
}
BOOL operator<(int nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	return B<A;
}
BOOL operator<(CFixedFloat &A,double nB)
{
	CFixedFloat B(nB);
	return A<B;
}
BOOL operator<(double nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	return B<A;
}

CFixedFloat operator*(CFixedFloat &A,int nB)
{
	CFixedFloat B(nB);
	return A*B;
}
CFixedFloat operator*(int nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	return A*B;
}
CFixedFloat operator*(CFixedFloat &A,long nB)
{
	CFixedFloat B((int)nB);
	return A*B;
}
CFixedFloat operator*(long nB,CFixedFloat &A)
{
	CFixedFloat B((int)nB);
	return A*B;
}
CFixedFloat operator*(CFixedFloat &A,double nB)
{
	CFixedFloat B(nB);
	return A*B;
}
CFixedFloat operator*(double nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	return A*B;
}
CFixedFloat operator+(CFixedFloat &a,int nB)
{
	CFixedFloat b(nB);
	return a+b;
}
CFixedFloat operator+(int nB,CFixedFloat &a)
{
	CFixedFloat b(nB);
	return a+b;
}
CFixedFloat operator+(CFixedFloat &a,double nB)
{
	CFixedFloat b(nB);
	return a+b;
}
CFixedFloat operator+(double nB,CFixedFloat &a)
{
	CFixedFloat b(nB);
	return a+b;
}
CFixedFloat operator/(CFixedFloat &a,int nB)
{
	CFixedFloat b(nB);
	return a/b;
}
CFixedFloat operator/(int nB,CFixedFloat &a)
{
	CFixedFloat b(nB);
	return b/a;
}
CFixedFloat operator/(CFixedFloat &a,double nB)
{
	CFixedFloat b(nB);
	return a/b;
}
CFixedFloat operator/(double nB,CFixedFloat &a)
{
	CFixedFloat b(nB);
	return b/a;
}
CFixedFloat operator-(CFixedFloat &a,int nB)
{
	CFixedFloat b(nB);
	return a-b;
}
CFixedFloat operator-(int nB,CFixedFloat &a)
{
	CFixedFloat b(nB);
	return b-a;
}
CFixedFloat operator-(CFixedFloat &a,double nB)
{
	CFixedFloat b(nB);
	return a-b;
}
CFixedFloat operator-(double nB,CFixedFloat &a)
{
	CFixedFloat b(nB);
	return b-a;
}

int operator+=(int &nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	B+=A;
	return B.ToInt();
}
int operator+=(double &nB,CFixedFloat &A)
{
	CFixedFloat B(nB);
	B+=A;
	return B.ToInt();
}
int operator+=(CFixedFloat &A,double &nB)
{
	CFixedFloat B(nB);
	B+=A;
	return B.ToInt();
}
CFixedFloat operator*(CFixedFloat &A,CFixedFloat &B)
{
	CFixedFloat Ret = A;
	Ret*=B;
	return Ret;
}
