// Kalles Fraktaler 2
//
//  2014 Karl Runmo ,runmo@hotmail.com
//
// COVERED CODE IS PROVIDED UNDER THIS LICENSE ON AN "AS IS" BASIS, WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
// THAT THE COVERED CODE IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE
// OR NON-INFRINGING. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE COVERED
// CODE IS WITH YOU. SHOULD ANY COVERED CODE PROVE DEFECTIVE IN ANY RESPECT, YOU (NOT
// THE INITIAL DEVELOPER OR ANY OTHER CONTRIBUTOR) ASSUME THE COST OF ANY NECESSARY
// SERVICING, REPAIR OR CORRECTION. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL
// PART OF THIS LICENSE. NO USE OF ANY COVERED CODE IS AUTHORIZED HEREUNDER EXCEPT UNDER
// THIS DISCLAIMER.

#include "fraktal_sft.h"
#include "..\..\common\parallell.h"
#include "..\..\common\StringVector.h"
#include "..\..\common\getimage.h"
#include <float.h>
#include <malloc.h>

//#define _3RD_DEGREE_

double pi=3.14159265;
#define _SMOOTH_COLORS_
#define SMOOTH_TOLERANCE 256
int g_nLDBL=600;
int g_nEXP=4900;
int g_nRefZero=10;
#define SMOOTH_BAILOUT 100
#define APPROX_GRID 19
#define TERM4
#define TERM5
//#define TERM6
//#define TERM7

BOOL g_LDBL=FALSE;
int (*SizeOfLD)();
int (*Version)();
void *(*AllocateArray)(int nSize);
void (*ReleaseArray)(void *p);
void (*AssignInt)(void *p,int nValue);
void (*AssignDouble)(void *p,double nDouble);
void (*AssignLD)(void *p,void *ld);
void (*AssignFloatExp)(void *p,floatexp *fe);
void (*ToInt)(void *p,int *pnValue);
void (*ToDouble)(void *p,double *pnDouble);
void (*ToFloatExp)(void *p,floatexp *pnFloatExp);
void (*Multiply)(void *a,void *b,void *ret);
double (*SquareAdd)(void *a,void *b);
void (*Divide)(void *a,void *b,void *ret);
void (*Add)(void *a,void *b,void *ret);
void (*Subtract)(void *a,void *b,void *ret);
int (*GT)(void *a,void *b);
int (*LT)(void *a,void *b);
int (*Equal)(void *a,void *b);
void (*Print)(void *a,char *szRet);
void (*ConvertFromFixedFloat)(void *p,int nValues, __int64 *pValues, BOOL bSign);
int (*Perturbation4)(int antal,void *pdxr,void *pdxi, void* pDr, void*pDi, void* pD0r, void*pD0i,double *ptest1, double *ptest2, int m_nBailout2, int m_nMaxIter,double *db_z,BOOL *pGlitch);
int (*Perturbation_3rd)(int antal,void *pdxr,void *pdxi, void* pDr, void*pDi, void* pD0r, void*pD0i,double *ptest1, double *ptest2, int m_nBailout2, int m_nMaxIter,double *db_z,BOOL *pGlitch);
//
// The long double library is loaded dynamically, so that there can be error handling
//
class CInitLD
{
public:
	CInitLD()
	{
		g_LDBL=TRUE;
#ifdef _WIN64
		HINSTANCE hLD = LoadLibrary("ldbl64.dll");
#else
		HINSTANCE hLD = LoadLibrary("ldbl.dll");
#endif
		if(!hLD){
			g_LDBL=FALSE;
			return;
		}
		if(!(Version = (int(*)())GetProcAddress(hLD,"Version"))){
			g_LDBL=2;
			return;
		}
		if(Version()!=3){
			g_LDBL=2;
			return;
		}
		if(!(SizeOfLD = (int(*)())GetProcAddress(hLD,"SizeOfLD")))
			g_LDBL=2;
		if(!(AllocateArray = (void*(*)(int))GetProcAddress(hLD,"AllocateArray")))
			g_LDBL=2;
		if(!(ReleaseArray = (void(*)(void*))GetProcAddress(hLD,"ReleaseArray")))
			g_LDBL=2;
		if(!(AssignInt = (void(*)(void*,int))GetProcAddress(hLD,"AssignInt")))
			g_LDBL=2;
		if(!(AssignDouble = (void(*)(void*,double))GetProcAddress(hLD,"AssignDouble")))
			g_LDBL=2;
		if(!(AssignLD = (void(*)(void*,void*))GetProcAddress(hLD,"AssignLD")))
			g_LDBL=2;
		if(!(AssignFloatExp = (void(*)(void*,floatexp*))GetProcAddress(hLD,"AssignFloatExp")))
			g_LDBL=2;
		if(!(ToInt = (void(*)(void*,int*))GetProcAddress(hLD,"ToInt")))
			g_LDBL=2;
		if(!(ToDouble = (void(*)(void*,double*))GetProcAddress(hLD,"ToDouble")))
			g_LDBL=2;
		if(!(ToFloatExp = (void(*)(void *,floatexp *))GetProcAddress(hLD,"ToFloatExp")))
			g_LDBL=2;
		if(!(Multiply = (void(*)(void*,void*,void*))GetProcAddress(hLD,"Multiply")))
			g_LDBL=2;
		if(!(SquareAdd = (double(*)(void*,void*))GetProcAddress(hLD,"SquareAdd")))
			g_LDBL=2;
		if(!(Divide = (void(*)(void*,void*,void*))GetProcAddress(hLD,"Divide")))
			g_LDBL=2;
		if(!(Add = (void(*)(void*,void*,void*))GetProcAddress(hLD,"Add")))
			g_LDBL=2;
		if(!(Subtract = (void(*)(void*,void*,void*))GetProcAddress(hLD,"Subtract")))
			g_LDBL=2;
		if(!(GT = (int(*)(void*,void*))GetProcAddress(hLD,"GT")))
			g_LDBL=2;
		if(!(LT = (int(*)(void*,void*))GetProcAddress(hLD,"LT")))
			g_LDBL=2;
		if(!(Equal = (int(*)(void*,void*))GetProcAddress(hLD,"Equal")))
			g_LDBL=2;
		if(!(Print = (void(*)(void*,char*))GetProcAddress(hLD,"Print")))
			g_LDBL=2;
		if(!(ConvertFromFixedFloat = (void(*)(void*,int,__int64*,BOOL))GetProcAddress(hLD,"ConvertFromFixedFloat")))
			g_LDBL=2;
		if(!(Perturbation4 = (int(*)(int,void*,void*,void*,void*,void*,void*,double*,double*,int,int,double*,BOOL*))GetProcAddress(hLD,"Perturbation4")))
			g_LDBL=2;
		if(!(Perturbation_3rd = (int(*)(int,void*,void*,void*,void*,void*,void*,double*,double*,int,int,double*,BOOL*))GetProcAddress(hLD,"Perturbation_3rd")))
			g_LDBL=2;
		int nSize=0;
		if(!SizeOfLD || (nSize=SizeOfLD())!=sizeof(ldbl))
			g_LDBL=FALSE;
	}
}g_InitLD;

CFraktalSFT::CFraktalSFT()
{
	m_bMirrored=0;
	m_bMW=0;
	m_bNoGlitchDetection=FALSE;
	m_nPower=2;

	m_hMutex = CreateMutex(NULL,0,NULL);
	m_bRunning = FALSE;
	m_szPosition = NULL;
	m_rstart=-2;
	m_istart=-2;
	m_rstop=2;
	m_istop=2;
	m_dxr=NULL;
	m_dxi=NULL;
	m_ldxr=NULL;
	m_ldxi=NULL;
	m_nZoom=0;
	m_nPixels=NULL;
	m_nTrans=NULL;
	m_bTrans=TRUE;
	m_bITrans=FALSE;
	m_bAddReference=FALSE;
	m_bNoApproximation=FALSE;
	m_nXPrev=m_nYPrev=-1;
	m_nSizeImage=-1;
	m_nTotal=-1;
	m_pDX=NULL;
	m_pDY=NULL;
	m_DX=NULL;
	m_DY=NULL;
	m_lDX=NULL;
	m_lDY=NULL;

	m_nBailout=SMOOTH_BAILOUT;
	m_nBailout2=m_nBailout*m_nBailout;
	m_nSmoothMethod=0;
	m_nColorMethod=0;

	m_db_dxr=NULL;
	m_db_dxi=NULL;

	m_lpBits=NULL;
	m_row=0;
	m_nMaxIter=200;
	m_bReuseRef=FALSE;
	m_nIterDiv=1;
	memset(m_pOldGlitch,-1,sizeof(m_pOldGlitch));
	GenerateColors(128,1);
	ApplyColors();
}
void CFraktalSFT::GenerateColors(int nParts,int nSeed)
{
	m_nParts = nParts;
	m_nSeed = nSeed;
	if(m_nSeed==-1)
		m_nSeed = GetTickCount();
	srand(m_nSeed);
	m_cKeys[0].r=m_cKeys[0].g=m_cKeys[0].b=m_cKeys[1024].r=m_cKeys[1024].g=m_cKeys[1024].b=0;
	int i;
	for(i=(m_nSeed==1?1:0);i<1024;i++){
		m_cKeys[i].r=rand()%256;
		m_cKeys[i].g=rand()%256;
		m_cKeys[i].b=rand()%256;
	}
	m_cKeys[m_nParts].r=m_cKeys[0].r;
	m_cKeys[m_nParts].g=m_cKeys[0].g;
	m_cKeys[m_nParts].b=m_cKeys[0].b;
}
int MakePrime(int n)
{
	int i;
	int nE = n/2;
	while(1){
		BOOL bDone=TRUE;
		for(i=2;i<nE;i++)
			if(n%i==0){
				bDone=FALSE;
				break;
			}
		if(bDone)
			break;
		n++;
	}
	return n;
}
void CFraktalSFT::AddWave(int nColor,int nP, int nS)
{
	srand(GetTickCount());
	int nPeriod;
	if(nP==-1){
		nPeriod=rand()%(m_nParts<4?m_nParts/2:m_nParts);
		if(nPeriod==0)
			nPeriod=1;
	}
	else
		nPeriod=nP;
	if(nP==-1)
		nPeriod = MakePrime(nPeriod);
	int nStart;
	if(nS==-1)
		nStart = rand()%nPeriod;
	else
		nStart = nS;
	int i;
	for(i=0;i<m_nParts;i++){
		int val = 127 + 127*sin((double)(i+nStart)*2*pi*((double)nPeriod/(double)m_nParts));
		switch(nColor){
		case 0:
			m_cKeys[i].r=val;
			if(nP==0)
				m_cKeys[i].r=0;
			break;
		case 1:
			m_cKeys[i].g=val;
			if(nP==0)
				m_cKeys[i].g=0;
			break;
		case 2:
			m_cKeys[i].b=val;
			if(nP==0)
				m_cKeys[i].b=0;
			break;
		case 3:
			if(nP){
				m_cKeys[i].r=(int)(m_cKeys[i].r + 1*val)/2;
				m_cKeys[i].g=(int)(m_cKeys[i].g + 1*val)/2;
				m_cKeys[i].b=(int)(m_cKeys[i].b + 1*val)/2;
			}
			break;
		}
	}
}
void CFraktalSFT::GenerateColors2(int nParts,int nSeed,int nWaves)
{
	m_nParts = nParts;
	m_nSeed = nSeed;
	if(m_nSeed==-1)
		m_nSeed = GetTickCount();
	srand(m_nSeed);
	int i;
	for(i=0;i<1024;i++)
		m_cKeys[i].r=m_cKeys[i].g=m_cKeys[i].b=0;
	int nW;
	char szTmp[30];
	CStringTable stPeriods;
	for(nW=0;nW<nWaves;nW++){
		int nTests, nPeriod;
		for(nTests=0;nTests<20;nTests++){
			nPeriod=rand()%(nParts>4?nParts/4:nParts);
			if(nPeriod==0)
				nPeriod=1;
			nPeriod = MakePrime(nPeriod);
			itoa(nPeriod,szTmp,10);
			if(stPeriods.FindString(0,szTmp))
				continue;
			stPeriods.AddRow();
			stPeriods.AddString(stPeriods.GetCount()-1,szTmp);
		}
		int nStart = rand()%nPeriod;
		int nColor = nW%4;
		if(nW<4){
			for(i=0;i<1024;i++){
				int val = 127 + 127*sin((double)(i+nStart)*2*pi*((double)nPeriod/(double)m_nParts));
				switch(nColor){
				case 0:
					m_cKeys[i].r+=(int)(m_cKeys[i].r + val)%256;
					break;
				case 1:
					m_cKeys[i].g+=(int)(m_cKeys[i].g + val)%256;
					break;
				case 2:
					m_cKeys[i].b+=(int)(m_cKeys[i].b + val)%256;
					break;
				case 3:
					m_cKeys[i].r=(int)(m_cKeys[i].r + val)/2;
					m_cKeys[i].g=(int)(m_cKeys[i].g + val)/2;
					m_cKeys[i].b=(int)(m_cKeys[i].b + val)/2;
					break;
				}
			}
		}
		else{
			for(i=0;i<1024;i++){
				int val = 127 + 127*sin((double)(i+nStart)*2*pi*((double)nPeriod/(double)m_nParts));
				switch(nColor){
				case 0:
					m_cKeys[i].r=(int)(m_cKeys[i].r + val)/2;
					break;
				case 1:
					m_cKeys[i].g=(int)(m_cKeys[i].g + val)/2;
					break;
				case 2:
					m_cKeys[i].b=(int)(m_cKeys[i].b + val)/2;
					break;
				case 3:
					m_cKeys[i].r=(int)(m_cKeys[i].r + val)/2;
					m_cKeys[i].g=(int)(m_cKeys[i].g + val)/2;
					m_cKeys[i].b=(int)(m_cKeys[i].b + val)/2;
					break;
				}
			}
		}
	}
}
void CFraktalSFT::ChangeNumOfColors(int nParts)
{
	m_nParts = nParts;
}
int CFraktalSFT::GetNumOfColors()
{
	return m_nParts;
}
void CFraktalSFT::ApplyIterationColors()
{
	if(m_nPixels && m_lpBits){
		int nMin, nMax;
		GetIterations(nMin,nMax);
		if(nMin==nMax)
			nMax=nMin+1;
		int x, y;
		for(x=0;x<m_nX;x++){
			for(y=0;y<m_nY;y++){
				int nIndex = x*3 + (m_bmi->biHeight-1-y)*m_row;
				m_lpBits[nIndex]     = 255*(m_nPixels[x][y]-nMin)/(nMax-nMin);
				m_lpBits[nIndex + 1] = m_lpBits[nIndex];
				m_lpBits[nIndex + 2] = m_lpBits[nIndex];
			}
		}
	}
}
void CFraktalSFT::ApplySmoothColors()
{
	if(m_nTrans && m_lpBits){
		int x, y;
		for(x=0;x<m_nX;x++){
			for(y=0;y<m_nY;y++){
				float tr = m_nTrans[x][y];
				int nIndex = x*3 + (m_bmi->biHeight-1-y)*m_row;
				m_lpBits[nIndex]     = 255*tr;
				m_lpBits[nIndex + 1] = 255*tr;
				m_lpBits[nIndex + 2] = 255*tr;
			}
		}
	}
}
void HSVToRGB(double hue, double sat, double bri,COLOR14 &cPos)
{
	hue*=6;
	int i = (int)floor(hue);

	double f = (hue) - i;
	if(!(i & 1))
		f = 1 - f;
	
	double m = bri * (1 - sat);
	double n = bri * (1 - sat * f);

	bri *= 255.0;
	n *= 255.0;
	m *= 255.0;

	switch (i)
	{
		case 6:
		case 0: cPos.b = (byte)bri;
				cPos.g = (byte)n;
				cPos.r = (byte)m;
				break;
		case 1: cPos.b = (byte)n;
				cPos.g = (byte)bri;
				cPos.r = (byte)m;
				break;
		case 2: cPos.b = (byte)m;
				cPos.g = (byte)bri;
				cPos.r = (byte)n;
				break;
		case 3: cPos.b = (byte)m;
				cPos.g = (byte)n;
				cPos.r = (byte)bri;
				break;
		case 4: cPos.b = (byte)n;
				cPos.g = (byte)m;
				cPos.r = (byte)bri;
				break;
		case 5: cPos.b = (byte)bri;
				cPos.g = (byte)m;
				cPos.r = (byte)n;
	}
}
void CFraktalSFT::SetColor(int nIndex,int nIter,double offs)
{
	if(nIter<0)
		return;
	if(nIter==m_nMaxIter)
		m_lpBits[nIndex]=m_lpBits[nIndex + 1]=m_lpBits[nIndex + 2]=0;
	else{
		double iter = (double)nIter + (double)1-offs;
		if(m_nColorMethod==1){
			iter = sqrt(iter);
		}
		else if(m_nColorMethod==2){
			iter = pow(iter,(double)1/(double)3);
		}
		else if(m_nColorMethod==3){
			iter = log(iter);
		}
		else if(m_nColorMethod==4){
			int nMin, nMax;
			GetIterations(nMin,nMax);
			iter = (double)1024 * ((double)iter-(double)nMin) / ((double)nMax-(double)nMin);
		}
		if(m_nIterDiv!=1){
			iter /= m_nIterDiv;
		}
		if(m_nColorOffset)
			iter+=m_nColorOffset;// = (nIter+m_nColorOffset)%1024;
		nIter = (int)iter;
		offs = 1 - (iter-(double)nIter);
		if(m_bITrans)
			offs = 1-offs;
		if(m_bMW){
			double nH=0, nS=0, nB=0;
			int nDR=0, nDG=0, nDB=0;
			int i;
			for(i=0;i<m_nMW;i++){
				double nPeriod;
				nPeriod=m_MW[i].nPeriod;
				double g;
				if(m_bTrans)
					g = sin((pi*iter)/nPeriod)/2+.5;
				else
					g = sin((pi*((int)iter))/nPeriod)/2+.5;
				if(m_MW[i].nType==0){
					nH += g;
					nDR++;
				}
				if(m_MW[i].nType==1){
					nS += g;
					nDG++;
				}
				if(m_MW[i].nType==2){
					nB += g;
					nDB++;
				}
			}
			if(nDR)
				nH/=nDR;
			if(nDG)
				nS/=nDG;
			if(nDB)
				nB/=nDB;
			COLOR14 cPos;
			HSVToRGB(nH,nS,nB,cPos);

			m_lpBits[nIndex]     = cPos.r;
			m_lpBits[nIndex + 1] = cPos.g;
			m_lpBits[nIndex + 2] = cPos.b;
		}
		else{
			if(m_bTrans && offs){
				double g1 = (1-offs);
				int col = nIter%1024;
				int ncol = (col+1)%1024;
				m_lpBits[nIndex] = m_cPos[col].r*offs+m_cPos[ncol].r*g1;
				m_lpBits[nIndex + 1] = m_cPos[col].g*offs+m_cPos[ncol].g*g1;
				m_lpBits[nIndex + 2] = m_cPos[col].b*offs+m_cPos[ncol].b*g1;
			}
			else{
				int col = nIter%1024;
				m_lpBits[nIndex]     = m_cPos[col].r;//+n;
				m_lpBits[nIndex + 1] = m_cPos[col].g;//+n;
				m_lpBits[nIndex + 2] = m_cPos[col].b;//+n;
			}
		}
	}
}
void CFraktalSFT::ApplyColors()
{
	int i, p=0;
	for(i=0;i<1024;i++){
		double temp = (double)i*(double)m_nParts/(double)1024;
		p = (int)temp;
		int pn = (p+1)%m_nParts;
		temp-=p;
		temp = sin((temp-.5)*pi)/2 + .5;
		m_cPos[i].r = (unsigned char)(temp*m_cKeys[pn].r + (1-temp)*m_cKeys[p].r);
		m_cPos[i].g = (unsigned char)(temp*m_cKeys[pn].g + (1-temp)*m_cKeys[p].g);
		m_cPos[i].b = (unsigned char)(temp*m_cKeys[pn].b + (1-temp)*m_cKeys[p].b);
	}
	if(m_nPixels && m_lpBits){
		int x, y;
		for(x=0;x<m_nX;x++){
			for(y=0;y<m_nY;y++){
				int nIndex = x*3 + (m_bmi->biHeight-1-y)*m_row;
				SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
			}
		}
	}
}
int CFraktalSFT::GetSeed()
{
	return m_nSeed;
}
CFraktalSFT::~CFraktalSFT()
{
}
char *CFraktalSFT::ToZoom()
{
	CFixedFloat div = m_istop-m_istart;
	return ToZoom((CDecNumber)4/((CDecNumber)div.ToText()),m_nZoom);
}
char *CFraktalSFT::ToZoom(CDecNumber &z,int &zoom)
{
	static char szRet[40];
	char *szZoom = z.ToText();
	*szRet=0;
	for(m_nZoom=0;szZoom[m_nZoom] && szZoom[m_nZoom]!='.';m_nZoom++);
	m_nZoom--;
	if(m_nZoom<=0){
		strncpy(szRet,szZoom,3);
		szRet[3]=0;
		return szRet;
	}
	szRet[0] = szZoom[0];
	if(szZoom[1]){
		szRet[1]='.';
		szRet[2]=szZoom[1];
		if(szZoom[2] && szZoom[2]!='.'){
			szRet[3]=szZoom[2];
			wsprintf(szRet+4,"e%03d",zoom);
		}
		else
			wsprintf(szRet+3,"e%03d",zoom);
	}
	else
		szRet[1]=0;
	zoom = m_nZoom;
	return szRet;
}
double CHECK_FLOAT(double a) 
{
	if(a <= DBL_MAX && a >= -DBL_MAX)
		return a;
	return 0;
}
BOOL ISFLOATOK(double a)
{
	if(a <= DBL_MAX && a >= -DBL_MAX)
		return TRUE;
	return 0;
}
void CFraktalSFT::CalculateApproximation(int nType)
{
	floatexp _1=1;
	floatexp _2=2;
	floatexp _3=3;
	floatexp _6=6;
	CFixedFloat cr, ci;
	int i, j;
	floatexp dbTr[4], dbTi[4], dbTr0[4], dbTi0[4];
	cr = m_rstart;
	ci = m_istart;
	
	if(nType==0){
		for(j=0;j<4;j++){
			dbTr0[j]=m_pDX[(j&1)==0?m_rApprox.left:m_rApprox.right-1];
			dbTi0[j]=m_pDY[(j&2)==0?m_rApprox.top:m_rApprox.bottom-1];
			if(m_nScalingOffset){
				dbTr0[j]*=m_nScaling;
				dbTi0[j]*=m_nScaling;
			}
			dbTr[j]=dbTr0[j];
			dbTi[j]=dbTi0[j];
		}
	}
	else if(nType==1){
		for(j=0;j<4;j++){
			ToFloatExp(&m_lDX[(j&1)==0?m_rApprox.left:m_rApprox.right-1],&dbTr0[j]);
			dbTr[j]=dbTr0[j];
			ToFloatExp(&m_lDX[(j&2)==0?m_rApprox.top:m_rApprox.bottom-1],&dbTi0[j]);
			dbTi[j]=dbTi0[j];
		}
	}
	else{
		for(j=0;j<4;j++){
			dbTr[j]=dbTr0[j]=m_DX[(j&1)==0?m_rApprox.left:m_rApprox.right-1];
			dbTi[j]=dbTi0[j]=m_DY[(j&2)==0?m_rApprox.top:m_rApprox.bottom-1];
		}
	}
	m_nMaxApproximation = m_nMaxIter;
	//floatexp mindiff = 0.000001;
	floatexp mindiff = (m_nBailout==2?0.000001:0.001);
//	if(dbTr[0]<0 && dbTi[0]<1e-16 && dbTi[0]>-1e-16)
//		mindiff = 0.0000001;
	if(m_bNoApproximation)
		mindiff=0;
	m_Ar=1;
	m_Ai=0;
	m_Br=0;
	m_Bi=0;
	m_Cr=0;
	m_Ci=0;
#ifdef TERM4
	m_Dr=0;
	m_Di=0;
#ifdef TERM5
	m_Er=0;
	m_Ei=0;
#ifdef TERM6
	m_Fr=0;
	m_Fi=0;
#ifdef TERM7
	m_Gr=0;
	m_Gi=0;
#endif
#endif
#endif
#endif

	floatexp xr;
	floatexp xi;
	floatexp Ar = m_Ar;
	floatexp Ai = m_Ai;
	floatexp Br = m_Br;
	floatexp Bi = m_Bi;
	floatexp Cr = m_Cr;
	floatexp Ci = m_Ci;
#ifdef TERM4
	floatexp Dr = m_Dr;
	floatexp Di = m_Di;
#ifdef TERM5
	floatexp Er = m_Er;
	floatexp Ei = m_Ei;
#ifdef TERM6
	floatexp Fr = m_Fr;
	floatexp Fi = m_Fi;
#ifdef TERM7
	floatexp Gr = m_Gr;
	floatexp Gi = m_Gi;
#endif
#endif
#endif
#endif

	for(i=1;i<m_nMaxIter && !m_bStop;i++){
		// Series approximation
		int n=i-1;
		if(nType==0){
			xr = m_db_dxr[n];
			xi = m_db_dxi[n];
		}
		else if(nType==1){
			ToFloatExp(&m_ldxr[n],&xr);
			ToFloatExp(&m_ldxi[n],&xi);
		}
		else{
			xr = m_dxr[n];
			xi = m_dxi[n];
		}
		Ar = m_Ar;
		Ai = m_Ai;
		Br = m_Br;
		Bi = m_Bi;
		Cr = m_Cr;
		Ci = m_Ci;
#ifdef TERM4
		Dr = m_Dr;
		Di = m_Di;
#ifdef TERM5
		Er = m_Er;
		Ei = m_Ei;
#ifdef TERM6
		Fr = m_Fr;
		Fi = m_Fi;
#ifdef TERM7
		Gr = m_Gr;
		Gi = m_Gi;
#endif
#endif
#endif
#endif

		if(m_nPower==2){
			m_Ar = _2*(xr*Ar-xi*Ai) + _1;
			m_Ai = _2*(xi*Ar+xr*Ai);

			m_Br = _2*(xr*Br-xi*Bi) + Ar*Ar - Ai*Ai;
			m_Bi = _2*(xi*Br+xr*Bi) + _2*Ar*Ai;

			m_Cr = _2*(xr*Cr-xi*Ci) + _2*(Ar*Br-Ai*Bi);
			m_Ci = _2*(xi*Cr+xr*Ci) + _2*(Ai*Br+Ar*Bi);
#ifdef TERM4
			m_Dr = _2*(xr*Dr-xi*Di) + _2*(Ar*Cr-Ai*Ci) + Br*Br - Bi*Bi;
			m_Di = _2*(xi*Dr+xr*Di) + _2*(Ai*Cr+Ar*Ci) + _2*Br*Bi;
#ifdef TERM5
			m_Er = _2*(xr*Er-xi*Ei) + _2*(Ar*Dr-Ai*Di) + _2*(Br*Cr-Bi*Ci);
			m_Ei = _2*(xi*Er+xr*Ei) + _2*(Ai*Dr+Ar*Di) + _2*(Bi*Cr+Br*Ci);

#ifdef TERM6
			m_Fr = _2*(xr*Fr-xi*Fi) + _2*(Ar*Er-Ai*Ei) + _2*(Br*Dr-Bi*Di) + Cr*Cr - Ci*Ci;
			m_Fi = _2*(xi*Fr+xr*Fi) + _2*(Ai*Er+Ar*Ei) + _2*(Bi*Dr+Br*Di) + _2*Cr*Ci;
#ifdef TERM7
			m_Gr = _2*(xr*Gr-xi*Gi) + _2*(Ar*Fr-Ai*Fi) + _2*(Br*Er-Bi*Ei) + _2*(Cr*Dr-Ci*Di);
			m_Gi = _2*(xi*Gr+xr*Gi) + _2*(Ai*Fr+Ar*Fi) + _2*(Bi*Er+Br*Ei) + _2*(Ci*Dr+Cr*Di);
#endif
#endif
#endif
#endif
		}
		else{
			//2966
			m_Ar = _3*(xr*xr*Ar - _2*xr*xi*Ai - xi*xi*Ar) + _1;
			m_Ai = _3*(xr*xr*Ai + _2*xr*xi*Ar  - xi*xi*Ai);
			//2966
			m_Br = _3*(xr*Ar*Ar - xr*Ai*Ai - _2*xi*Ar*Ai + (xr*xr*Br - _2*xr*xi*Bi - xi*xi*Br) );
			m_Bi = _3*(_2*xr*Ar*Ai + xi*Ar*Ar - xi*Ai*Ai + (xr*xr*Bi + _2*xr*xi*Br + xi*xi*Bi) );
			//2967
			m_Cr = Ar*Ar*Ar - _3*Ar*Ai*Ai + _6*(xr*Ar*Br - xr*Ai*Bi - xi*Ar*Bi - xi*Ai*Br) + _3*(xr*xr*Cr - _2*xr*xi*Ci - xi*xi*Cr);
			m_Ci = _3*Ar*Ar*Ai - Ai*Ai*Ai + _6*(xr*Ar*Bi + xr*Ai*Br + xi*Ar*Br + xi*Ai*Bi) + _3*(xr*xr*Ci + _2*xr*xi*Cr + xi*xi*Ci);
		}
/*
An+1 = 2XnAn + 1
Bn+1 = 2XnBn + An2
Cn+1 = 2XnCn + 2AnBn (33097)
Dn+1 = 2XnDn + 2AnCn + Bn2
En+1 = 2XnEn + 2AnDn + 2BnCn (38613)
Fn+1 = 2XnFn + 2AnEn + 2BnDn + Cn2 (38613)
Gn+1 = 2XnGn + 2AnFn + 2BnEn + 2CnDn
Hn+1 = 2XnHn + 2AnGn + 2BnFn + 2CnEn + Dn2
In+1 = 2XnIn + 2AnHn + 2BnGn + 2CnFn + 2DnEn
*/
		if(i<m_nMaxApproximation){
			floatexp dxr, dxi;
			if(nType==0){
				dxr = m_db_dxr[i];
				dxi = m_db_dxi[i];
			}
			else if(nType==1){
				ToFloatExp(&m_ldxr[i],&dxr);
				ToFloatExp(&m_ldxi[i],&dxi);
			}
			else{
				dxr = m_dxr[i];
				dxi = m_dxi[i];
			}
			for(j=0;j<4;j++){
				floatexp Dnr, Dni;
				floatexp D2r = dbTr0[j]*dbTr0[j]-dbTi0[j]*dbTi0[j];
				floatexp D2i = _2*dbTr0[j]*dbTi0[j];
				floatexp D3r = D2r*dbTr0[j]-D2i*dbTi0[j];
				floatexp D3i = D2r*dbTi0[j]+D2i*dbTr0[j];
#ifdef TERM4
				floatexp D4r = D3r*dbTr0[j]-D3i*dbTi0[j];
				floatexp D4i = D3r*dbTi0[j]+D3i*dbTr0[j];
#ifdef TERM5
				floatexp D5r = D4r*dbTr0[j]-D4i*dbTi0[j];
				floatexp D5i = D4r*dbTi0[j]+D4i*dbTr0[j];
#ifdef TERM6
				floatexp D6r = D5r*dbTr0[j]-D5i*dbTi0[j];
				floatexp D6i = D5r*dbTi0[j]+D5i*dbTr0[j];
#ifdef TERM7
				floatexp D7r = D6r*dbTr0[j]-D6i*dbTi0[j];
				floatexp D7i = D6r*dbTi0[j]+D6i*dbTr0[j];
#endif
#endif
#endif
#endif
				Dnr = m_Ar*dbTr0[j]-m_Ai*dbTi0[j];
				Dni = m_Ar*dbTi0[j]+m_Ai*dbTr0[j];
				Dnr+= m_Br*D2r-m_Bi*D2i;
				Dni+= m_Br*D2i+m_Bi*D2r;
				Dnr+= m_Cr*D3r-m_Ci*D3i;
				Dni+= m_Cr*D3i+m_Ci*D3r;
#ifdef TERM4
				Dnr+= m_Dr*D4r-m_Di*D4i;
				Dni+= m_Dr*D4i+m_Di*D4r;
#ifdef TERM5
				Dnr+= m_Er*D5r-m_Ei*D5i;
				Dni+= m_Er*D5i+m_Ei*D5r;
#ifdef TERM6
				Dnr+= m_Fr*D6r-m_Fi*D6i;
				Dni+= m_Fr*D6i+m_Fi*D6r;
#ifdef TERM7
				Dnr+= m_Gr*D7r-m_Gi*D7i;
				Dni+= m_Gr*D7i+m_Gi*D7r;
#endif
#endif
#endif
#endif
				floatexp diff = (Dnr - dbTr[j])/dbTr[j];
				if(diff>mindiff || diff<-mindiff){
					m_nMaxApproximation=i;
					break;
				}
				diff = (Dni - dbTi[j])/dbTi[j];
				if(diff>mindiff || diff<-mindiff){
					m_nMaxApproximation=i;
					break;
				}
				double yr=(dxr+Dnr).todouble();
				double yi=(dxi+Dni).todouble();
				if(yr*yr+yi*yi>m_nBailout2){
					m_nMaxApproximation=i;
					break;
				}

				if(m_nPower==2){
					Dnr = (dxr*dbTr[j] - dxi*dbTi[j])*_2 + dbTr[j]*dbTr[j] - dbTi[j]*dbTi[j] + dbTr0[j];
					Dni = (dxr*dbTi[j] + dxi*dbTr[j] + dbTr[j]*dbTi[j])*_2 + dbTi0[j];
				}
				else{
					Dnr=_3*((dxr*dxr-dxi*dxi)*dbTr[j]+dxr*(dbTr[j]*dbTr[j]-dbTi[j]*dbTi[j])-dbTi[j]*(_2*dxi*(dxr+dbTr[j])+dbTr[j]*dbTi[j]))+dbTr[j]*dbTr[j]*dbTr[j]+dbTr0[j];
					Dni=_3*((dxr*dxr-dxi*dxi)*dbTi[j]+dxi*(dbTr[j]*dbTr[j]-dbTi[j]*dbTi[j])+dbTr[j]*(_2*dxr*(dxi+dbTi[j])+dbTr[j]*dbTi[j]))-dbTi[j]*dbTi[j]*dbTi[j]+dbTi0[j];
				}

				dbTr[j]=Dnr;
				dbTi[j]=Dni;
			}
			if(j<4)
				break;
		}
	}
	m_Ar = Ar;
	m_Ai = Ai;
	m_Br = Br;
	m_Bi = Bi;
	m_Cr = Cr;
	m_Ci = Ci;
#ifdef TERM4
	m_Dr = Dr;
	m_Di = Di;
#ifdef TERM5
	m_Er = Er;
	m_Ei = Ei;
#ifdef TERM6
	m_Fr = Fr;
	m_Fi = Fi;
#ifdef TERM7
	m_Gr = Gr;
	m_Gi = Gi;
#endif
#endif
#endif
#endif
	if(m_bNoApproximation)
		m_nMaxApproximation=0;
}

void CFraktalSFT::CalculateReference()
{
	int i;
	if(m_db_dxr)
		delete [] m_db_dxr;
	m_db_dxr = new double[m_nMaxIter];
	if(m_db_dxi)
		delete [] m_db_dxi;
	m_db_dxi = new double[m_nMaxIter];
	if(m_db_z)
		delete [] m_db_z;
	m_db_z = new double[m_nMaxIter];

	CFixedFloat xr=0, xi=0, xin, xrn, sr=0, si=0, t1, t2;

	if(m_nPower==2){
		for(i=0;i<m_nMaxIter && !m_bStop;i++){
			m_db_dxr[i] = xr.ToDouble();
			m_db_dxi[i] = xi.ToDouble();
			m_db_z[i] = (m_db_dxr[i]*m_db_dxr[i] + m_db_dxi[i]*m_db_dxi[i])*0.0000001;

			xin = (xr*xi).Double() + m_iref;
			xrn = sr - si + m_rref; 
			xr = xrn; 
			xi = xin;
			sr = xr.Square();
			si = xi.Square(); 
			m_nRDone++;
		}
	}
	else{
		for(i=0;i<m_nMaxIter && !m_bStop;i++){
			m_db_dxr[i] = xr.ToDouble();
			m_db_dxi[i] = xi.ToDouble();
			m_db_z[i] = (m_db_dxr[i]*m_db_dxr[i] + m_db_dxi[i]*m_db_dxi[i])*0.0000001;

			xrn = xr*(xr.Square() - 3*xi.Square()) + m_rref;
			xin = (3*xr.Square() - xi.Square())*xi + m_iref;
			xr = xrn;
			xi = xin;
			m_nRDone++;
		}
	}
}
struct MC
{
	CFixedFloat *xr, *xi, *sr, *si, *xrxid;
	HANDLE hDone;
	HANDLE hWait;
	HANDLE hExit;
	int nType;
};
DWORD WINAPI ThMC(MC *pMC)
{
	HANDLE hW[2];
	hW[0]=pMC->hWait;
	hW[1]=pMC->hExit;
	while(WaitForMultipleObjects(2,hW,FALSE,INFINITE)==WAIT_OBJECT_0){
		if(pMC->nType==0)
			*pMC->sr = pMC->xr->Square();
		else if(pMC->nType==1)
			*pMC->si = pMC->xi->Square();
		else
			*pMC->xrxid = ((*pMC->xr)*(*pMC->xi)).Double();
		SetEvent(pMC->hDone);
	}
	SetEvent(pMC->hDone);
	return 0;
}
void CFraktalSFT::CalculateReferenceLDBL()
{
	int i;
	if(m_ldxr)
		ReleaseArray(m_ldxr);
	m_ldxr = (ldbl*)AllocateArray(m_nMaxIter);
	if(m_ldxi)
		ReleaseArray(m_ldxi);
	m_ldxi = (ldbl*)AllocateArray(m_nMaxIter);
	if(m_db_z)
		delete [] m_db_z;
	m_db_z = new double[m_nMaxIter];

	CFixedFloat xr=0, xi=0, xin, xrn, sr=0, si=0, xrxid=0, _4=4;
	if(m_nPower==2){
		MC mc[3];
		HANDLE hDone[3];
		HANDLE hWait[3];
		HANDLE hExit[3];
		for(i=0;i<3;i++){
			mc[i].xr = &xr;
			mc[i].xi = &xi;
			mc[i].sr = &sr;
			mc[i].si = &si;
			mc[i].xrxid = &xrxid;
			hDone[i] = mc[i].hDone = CreateEvent(NULL,0,0,NULL);
			hWait[i] = mc[i].hWait = CreateEvent(NULL,0,0,NULL);
			hExit[i] = mc[i].hExit = CreateEvent(NULL,0,0,NULL);
			mc[i].nType=i;
		}
		HANDLE hThread;
		DWORD dw;
		for(i=0;i<3;i++){
			hThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)ThMC,(LPVOID)&mc[i],0,&dw);
			CloseHandle(hThread);
		}

		for(i=0;i<m_nMaxIter && !m_bStop;i++){
			ConvertFromFixedFloat(&m_ldxr[i],xr.m_nValues,xr.m_pValues,xr.m_bSign);
			ConvertFromFixedFloat(&m_ldxi[i],xi.m_nValues,xi.m_pValues,xi.m_bSign);
			m_db_z[i] = SquareAdd(&m_ldxr[i],&m_ldxi[i])*0.000001;

			xin = xrxid + m_iref;
			//xin = (xr+xi).Square() -si-sr+ ci;
			xrn = sr - si + m_rref; 
			xr = xrn; 
			xi = xin;
			//sr = xr.Square();
			//si = xi.Square(); 
			//xrxid = (xr*xi).Double();
			for(int k=0;k<3;k++)
				SetEvent(hWait[k]);
			WaitForMultipleObjects(3,hDone,TRUE,INFINITE);
			m_nRDone++;
		}
		for(int k=0;k<3;k++)
			SetEvent(hExit[k]);
		WaitForMultipleObjects(3,hDone,TRUE,INFINITE);
		for(;i<m_nMaxIter && !m_bStop;i++){
			ConvertFromFixedFloat(&m_ldxr[i],xr.m_nValues,xr.m_pValues,xr.m_bSign);
			ConvertFromFixedFloat(&m_ldxi[i],xi.m_nValues,xi.m_pValues,xi.m_bSign);
		}
		for(i=0;i<3;i++){
			CloseHandle(hDone[i]);
			CloseHandle(hWait[i]);
			CloseHandle(hExit[i]);
		}
	}
	else{
		for(i=0;i<m_nMaxIter && !m_bStop;i++){
			ConvertFromFixedFloat(&m_ldxr[i],xr.m_nValues,xr.m_pValues,xr.m_bSign);
			ConvertFromFixedFloat(&m_ldxi[i],xi.m_nValues,xi.m_pValues,xi.m_bSign);
			m_db_z[i] = SquareAdd(&m_ldxr[i],&m_ldxi[i])*0.000001;

			xrn = xr*(xr.Square() - 3*xi.Square()) + m_rref;
			xin = (3*xr.Square() - xi.Square())*xi + m_iref;
			xr = xrn;
			xi = xin;
			m_nRDone++;
		}
	}
}
void CFraktalSFT::CalculateReferenceEXP()
{
	int i;
	if(m_dxr)
		delete [] m_dxr;
	m_dxr = new floatexp[m_nMaxIter];
	if(m_dxi)
		delete [] m_dxi;
	m_dxi = new floatexp[m_nMaxIter];
	if(m_db_z)
		delete [] m_db_z;
	m_db_z = new double[m_nMaxIter];

	CFixedFloat xr=0, xi=0, xin, xrn, sr=0, si=0, xrxid=0, _4=4;
	if(m_nPower==2){
		MC mc[3];
		HANDLE hDone[3];
		HANDLE hWait[3];
		HANDLE hExit[3];
		for(i=0;i<3;i++){
			mc[i].xr = &xr;
			mc[i].xi = &xi;
			mc[i].sr = &sr;
			mc[i].si = &si;
			mc[i].xrxid = &xrxid;
			hDone[i] = mc[i].hDone = CreateEvent(NULL,0,0,NULL);
			hWait[i] = mc[i].hWait = CreateEvent(NULL,0,0,NULL);
			hExit[i] = mc[i].hExit = CreateEvent(NULL,0,0,NULL);
			mc[i].nType=i;
		}
		HANDLE hThread;
		DWORD dw;
		for(i=0;i<3;i++){
			hThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)ThMC,(LPVOID)&mc[i],0,&dw);
			CloseHandle(hThread);
		}

		for(i=0;i<m_nMaxIter && !m_bStop;i++){
			m_dxr[i] = xr;
			m_dxi[i] = xi;
			m_db_z[i] = (m_dxr[i]*m_dxr[i] + m_dxi[i]*m_dxi[i]).todouble()*0.000001;

			xin = xrxid + m_iref;
			//xin = (xr+xi).Square() -si-sr+ ci;
			xrn = sr - si + m_rref; 
			xr = xrn; 
			xi = xin;
			//sr = xr.Square();
			//si = xi.Square(); 
			//xrxid = (xr*xi).Double();
			for(int k=0;k<3;k++)
				SetEvent(hWait[k]);
			WaitForMultipleObjects(3,hDone,TRUE,INFINITE);
			m_nRDone++;
		}
		for(int k=0;k<3;k++)
			SetEvent(hExit[k]);
		WaitForMultipleObjects(3,hDone,TRUE,INFINITE);
		for(;i<m_nMaxIter && !m_bStop;i++){
			m_dxr[i] = xr;
			m_dxi[i] = xi;
		}
		for(i=0;i<3;i++){
			CloseHandle(hDone[i]);
			CloseHandle(hWait[i]);
			CloseHandle(hExit[i]);
		}
	}
	else{
		for(i=0;i<m_nMaxIter && !m_bStop;i++){
			m_dxr[i] = xr;
			m_dxi[i] = xi;
			m_db_z[i] = (m_dxr[i]*m_dxr[i] + m_dxi[i]*m_dxi[i]).todouble()*0.000001;
			xrn = xr*(xr.Square() - 3*xi.Square()) + m_rref;
			xin = (3*xr.Square() - xi.Square())*xi + m_iref;
			xr = xrn;
			xi = xin;
			m_nRDone++;
		}
	}
}
int ThMandelCalc(TH_PARAMS *pMan)
{
	pMan->p->MandelCalc(pMan->nXStart,pMan->nXStop);
	return 0;
}
int ThMandelCalcEXP(TH_PARAMS *pMan)
{
	pMan->p->MandelCalcEXP(pMan->nXStart,pMan->nXStop);
	return 0;
}
int ThMandelCalcLDBL(TH_PARAMS *pMan)
{
	pMan->p->MandelCalcLDBL(pMan->nXStart,pMan->nXStop);
	return 0;
}
void CFraktalSFT::Mirror(int x, int y)
{
	if(!m_bMirrored)
		return;
	int ty = m_nY - y - 1;
	if(ty<y)
		return;
	int tx = m_nX - x - 1;

	m_nPixels[tx][ty] = m_nPixels[x][y];
	m_nTrans[tx][ty] = m_nTrans[x][y];
	int nIndex1 = tx*3 + (m_bmi->biHeight-1-ty)*m_row;
	SetColor(nIndex1,m_nPixels[x][ty],m_nTrans[x][ty]);
}
int CFraktalSFT::GetMirror()
{
	return m_bMirrored;
}
void CFraktalSFT::SetMirror(BOOL bMirror)
{
	m_bMirrored = bMirror;
}

#define GET_EXP(val) ((*((__int64*)&val) & 0x7FF0000000000000)>>52)

#define GUESS
//#define HARD_GUESS
#define HARD_GUESS_EXP
//60 2.5

floatexp g_2 = 2;
floatexp g_4 = 4;
void CFraktalSFT::MandelCalc(int nXStart,int nXStop)
{
	m_bIterChanged=TRUE;
	double Dnr, Dni, yr, yi;
	int antal, x, y;
	int nPStep;

	while(!m_bStop && m_P.GetPixel(x,y,m_bMirrored)){
		nPStep = m_P.GetStep();
		if(nPStep>1)
			nPStep=0;
		else
			nPStep=1;
		int nIndex = x*3 + (m_bmi->biHeight-1-y)*m_row;
		if(m_nPixels[x][y]!=-1){
			SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
			continue;
		}
		if(nPStep){
			if(x && x<m_nX-1 && m_nPixels[x-1][y]!=-1 && m_nPixels[x-1][y]==m_nPixels[x+1][y]){
				m_nTrans[x][y] = (m_nTrans[x-1][y] + m_nTrans[x+1][y])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && m_nPixels[x][y-1]!=-1 && m_nPixels[x][y-1]==m_nPixels[x][y+1]){
				m_nTrans[x][y] = (m_nTrans[x][y-1] + m_nTrans[x][y+1])/2;
				int nIndex1 = (x)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && x && x<m_nX-1 && m_nPixels[x-1][y-1]!=-1 && m_nPixels[x-1][y-1]==m_nPixels[x+1][y+1]){
				m_nTrans[x][y] = (m_nTrans[x-1][y-1] + m_nTrans[x+1][y+1])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && x && x<m_nX-1 && m_nPixels[x-1][y+1]!=-1 && m_nPixels[x-1][y+1]==m_nPixels[x+1][y-1]){
				m_nTrans[x][y] = (m_nTrans[x-1][y+1] + m_nTrans[x+1][y-1])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y+1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
		}
		if(m_nPixels[x][y]!=-1){
			SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
			continue;
		}
		// Series approximation
		floatexp D0r=m_pDX[x];
		D0r*=m_nScaling;
		floatexp D0i=m_pDY[y];
		D0i*=m_nScaling;
		floatexp D2r = D0r*D0r-D0i*D0i;
		floatexp D2i = g_2*D0r*D0i;
		floatexp D3r = D2r*D0r-D2i*D0i;
		floatexp D3i = D2r*D0i+D2i*D0r;
#ifdef TERM4
		floatexp D4r = D3r*D0r-D3i*D0i;
		floatexp D4i = D3r*D0i+D3i*D0r;
#ifdef TERM5
		floatexp D5r = D4r*D0r-D4i*D0i;
		floatexp D5i = D4r*D0i+D4i*D0r;
#ifdef TERM6
		floatexp D6r = D5r*D0r-D5i*D0i;
		floatexp D6i = D5r*D0i+D5i*D0r;
#ifdef TERM7
		floatexp D7r = D6r*D0r-D6i*D0i;
		floatexp D7i = D6r*D0i+D6i*D0r;
#endif
#endif
#endif
#endif
		if(m_nMaxApproximation)
			antal = m_nMaxApproximation-1;
		else
			antal=0;
		floatexp TDnr = m_Ar*D0r-m_Ai*D0i;
		floatexp TDni = m_Ar*D0i+m_Ai*D0r;
		TDnr+= m_Br*D2r-m_Bi*D2i;
		TDni+= m_Br*D2i+m_Bi*D2r;
		TDnr+= m_Cr*D3r-m_Ci*D3i;
		TDni+= m_Cr*D3i+m_Ci*D3r;
#ifdef TERM4
		TDnr+= m_Dr*D4r-m_Di*D4i;
		TDni+= m_Dr*D4i+m_Di*D4r;
#ifdef TERM5
		TDnr+= m_Er*D5r-m_Ei*D5i;
		TDni+= m_Er*D5i+m_Ei*D5r;
#ifdef TERM6
		TDnr+= m_Fr*D6r-m_Fi*D6i;
		TDni+= m_Fr*D6i+m_Fi*D6r;
#ifdef TERM7
		TDnr+= m_Gr*D7r-m_Gi*D7i;
		TDni+= m_Gr*D7i+m_Gi*D7r;
#endif
#endif
#endif
#endif
		double test1=0 ,test2=0;
		BOOL bGlitch=FALSE;
		if(m_nScalingOffset){
			double Dr = TDnr.todouble(m_nScalingOffset);
			double Di = TDni.todouble(m_nScalingOffset);
			if(m_nPower==2){
				if(antal<m_nMaxIter && test1 <= m_nBailout2){
					for(;antal<m_nMaxIter && test1 <= m_nBailout2;antal++){
						yr=m_db_dxr[antal]+Dr*m_nScaling;
						yi=m_db_dxi[antal]+Di*m_nScaling;
						test2=test1;
						test1 = yr*yr+yi*yi;
						if(test1<m_db_z[antal]){
							test1 = m_nBailout2*2;
							bGlitch=TRUE;
						}
						Dnr = (2*m_db_dxr[antal] + Dr*m_nScaling)*Dr - (2*m_db_dxi[antal] + Di*m_nScaling)*Di + m_pDX[x];
						Dni = 2*((m_db_dxr[antal] + Dr*m_nScaling)*Di + m_db_dxi[antal]*Dr) + m_pDY[y];
						Di = Dni;
						Dr = Dnr;
					}
				}
			}
			else{
				if(antal<m_nMaxIter && test1 <= m_nBailout2){
					for(;antal<m_nMaxIter && test1 <= m_nBailout2;antal++){
						yr=m_db_dxr[antal]+Dr*m_nScaling;
						yi=m_db_dxi[antal]+Di*m_nScaling;
						test2=test1;
						test1 = yr*yr+yi*yi;
						if(test1<m_db_z[antal]){
							test1 = m_nBailout2*2;
							bGlitch=TRUE;
						}
						//Dnr=3*((m_db_dxr[antal]*m_db_dxr[antal]-m_db_dxi[antal]*m_db_dxi[antal])*Dr+m_db_dxr[antal]*(Dr*Dr*m_nScaling-Di*Di*m_nScaling)-Di*(2*m_db_dxi[antal]*(m_db_dxr[antal]+Dr*m_nScaling)+Dr*m_nScaling*Di*m_nScaling))+Dr*m_nScaling*Dr*m_nScaling*Dr+m_pDX[x];
						//Dni=3*((m_db_dxr[antal]*m_db_dxr[antal]-m_db_dxi[antal]*m_db_dxi[antal])*Di+m_db_dxi[antal]*(Dr*Dr*m_nScaling-Di*Di*m_nScaling)+Dr*(2*m_db_dxr[antal]*(m_db_dxi[antal]+Di)+Dr*m_nScaling*Di*m_nScaling))-Di*Di*m_nScaling*Di*m_nScaling+m_pDY[y];
						Dnr = 3*m_db_dxr[antal]*m_db_dxr[antal]*Dr - 6*m_db_dxr[antal]*m_db_dxi[antal]*Di - 3*m_db_dxi[antal]*m_db_dxi[antal]*Dr + 3*m_db_dxr[antal]*Dr*Dr*m_nScaling - 3*m_db_dxr[antal]*Di*Di*m_nScaling - 3*m_db_dxi[antal]*2*Dr*Di*m_nScaling + Dr*Dr*Dr*m_nScaling*m_nScaling - 3*Dr*Di*Di*m_nScaling*m_nScaling + m_pDX[x];
						Dni = 3*m_db_dxr[antal]*m_db_dxr[antal]*Di + 6*m_db_dxr[antal]*m_db_dxi[antal]*Dr - 3*m_db_dxi[antal]*m_db_dxi[antal]*Di + 3*m_db_dxr[antal]*2*Dr*Di*m_nScaling + 3*m_db_dxi[antal]*Dr*Dr*m_nScaling - 3*m_db_dxi[antal]*Di*Di*m_nScaling + 3*Dr*Dr*Di*m_nScaling*m_nScaling - Di*Di*Di*m_nScaling*m_nScaling + m_pDY[y];
						Di = Dni;
						Dr = Dnr;
					}
				}
			}
		}
		else{
			double Dr = TDnr.todouble();
			double Di = TDni.todouble();
			if(m_nPower==2){
				if(antal<m_nMaxIter && test1 <= m_nBailout2){
					for(;antal<m_nMaxIter && test1 <= m_nBailout2;antal++){
						yr=m_db_dxr[antal]+Dr;
						yi=m_db_dxi[antal]+Di;
						test2=test1;
						test1 = yr*yr+yi*yi;
						if(test1<m_db_z[antal]){
							test1 = m_nBailout2*2;
							bGlitch=TRUE;
						}
						Dnr = (2*m_db_dxr[antal] + Dr)*Dr - (2*m_db_dxi[antal] + Di)*Di + m_pDX[x];
						Dni = 2*((m_db_dxr[antal] + Dr)*Di + m_db_dxi[antal]*Dr) + m_pDY[y];
						Di = Dni;
						Dr = Dnr;
					}
				}
			}
			else{
				if(antal<m_nMaxIter && test1 <= m_nBailout2){
					for(;antal<m_nMaxIter && test1 <= m_nBailout2;antal++){
						yr=m_db_dxr[antal]+Dr;
						yi=m_db_dxi[antal]+Di;
						test2=test1;
						test1 = yr*yr+yi*yi;
						if(test1<m_db_z[antal]){
							test1 = m_nBailout2*2;
							bGlitch=TRUE;
						}
						//Dnr=3*((m_db_dxr[antal]*m_db_dxr[antal]-m_db_dxi[antal]*m_db_dxi[antal])*Dr+m_db_dxr[antal]*(Dr*Dr-Di*Di)-Di*(2*m_db_dxi[antal]*(m_db_dxr[antal]+Dr)+Dr*Di))+Dr*Dr*Dr+m_pDX[x];
						//Dni=3*((m_db_dxr[antal]*m_db_dxr[antal]-m_db_dxi[antal]*m_db_dxi[antal])*Di+m_db_dxi[antal]*(Dr*Dr-Di*Di)+Dr*(2*m_db_dxr[antal]*(m_db_dxi[antal]+Di)+Dr*Di))-Di*Di*Di+m_pDY[y];
						Dnr = 3*m_db_dxr[antal]*m_db_dxr[antal]*Dr - 6*m_db_dxr[antal]*m_db_dxi[antal]*Di - 3*m_db_dxi[antal]*m_db_dxi[antal]*Dr + 3*m_db_dxr[antal]*Dr*Dr - 3*m_db_dxr[antal]*Di*Di - 3*m_db_dxi[antal]*2*Dr*Di + Dr*Dr*Dr - 3*Dr*Di*Di + m_pDX[x];
						Dni = 3*m_db_dxr[antal]*m_db_dxr[antal]*Di + 6*m_db_dxr[antal]*m_db_dxi[antal]*Dr - 3*m_db_dxi[antal]*m_db_dxi[antal]*Di + 3*m_db_dxr[antal]*2*Dr*Di + 3*m_db_dxi[antal]*Dr*Dr - 3*m_db_dxi[antal]*Di*Di + 3*Dr*Dr*Di - Di*Di*Di + m_pDY[y];
						Di = Dni;
						Dr = Dnr;
					}
				}
			}
		}
		if(antal==m_nMaxIter){
			m_nPixels[x][y] = antal;
			m_nTrans[x][y]=0;
			m_lpBits[nIndex]     = 0;
			m_lpBits[nIndex + 1] = 0;
			m_lpBits[nIndex + 2] = 0;
		}
		else{
			m_nPixels[x][y] = antal+(m_nZoom<g_nRefZero?1:0);
			if(m_nSmoothMethod==1){
				double div = sqrt(test1)-sqrt(test2);
				if(div!=0)
					m_nTrans[x][y] = (sqrt(test1)-m_nBailout)/div;
				else
					m_nTrans[x][y] = 0;
			}

			else if(m_nSmoothMethod==0){
				if(m_nPower==2)
					m_nTrans[x][y] = log (log  (sqrt(test1))) / log (2.0);
				else
					m_nTrans[x][y] = log (log  (sqrt(test1))) / log (3.0);
				while(m_nTrans[x][y]<0){
					m_nPixels[x][y]++;
					m_nTrans[x][y]+=1;
				}
				while(m_nTrans[x][y]>1){
					m_nPixels[x][y]--;
					m_nTrans[x][y]-=1;
				}

			}
			if(bGlitch && !m_bNoGlitchDetection){
				m_nTrans[x][y]=2;
				m_nPixels[x][y]=m_nMaxIter-1;//(m_nMaxApproximation?m_nMaxApproximation-1:0);
			}
			SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
		}
		if(m_bMirrored)
			Mirror(x,y);
		InterlockedIncrement((LPLONG)&m_nDone);
		if(!nPStep){
			int q;
			for(q=0;q<3;q++){
				int tx = x + (q!=1?1:0);
				int ty = y + (q>0?1:0);
				if(tx<m_nX-1 && ty<m_nY-1 && m_nPixels[tx][ty]==-1){
					int nIndex1 = tx*3 + (m_bmi->biHeight-1-ty)*m_row;
					m_lpBits[nIndex1]=m_lpBits[nIndex];
					m_lpBits[nIndex1+1]=m_lpBits[nIndex+1];
					m_lpBits[nIndex1+2]=m_lpBits[nIndex+2];
				}
			}
		}
	}
}


void CFraktalSFT::MandelCalcLDBL(int nXStart,int nXStop)
{
	m_bIterChanged=TRUE;
	int antal, x, y;
	int nPStep;


	while(!m_bStop && m_P.GetPixel(x,y)){
		nPStep = m_P.GetStep();
		if(nPStep>1)
			nPStep=0;
		else
			nPStep=1;
		int nIndex = x*3 + (m_bmi->biHeight-1-y)*m_row;
		if(m_nPixels[x][y]!=-1){
			SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
			continue;
		}
		if(nPStep){
			if(x && x<m_nX-1 && m_nPixels[x-1][y]!=-1 && m_nPixels[x-1][y]==m_nPixels[x+1][y]){
				m_nTrans[x][y] = (m_nTrans[x-1][y] + m_nTrans[x+1][y])/2;
				if(m_nTrans[x][y]==2)
					m_nTrans[x-1][y]=2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && m_nPixels[x][y-1]!=-1 && m_nPixels[x][y-1]==m_nPixels[x][y+1]){
				m_nTrans[x][y] = (m_nTrans[x][y-1] + m_nTrans[x][y+1])/2;
				int nIndex1 = (x)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && x && x<m_nX-1 && m_nPixels[x-1][y-1]!=-1 && m_nPixels[x-1][y-1]==m_nPixels[x+1][y+1]){
				m_nTrans[x][y] = (m_nTrans[x-1][y-1] + m_nTrans[x+1][y+1])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && x && x<m_nX-1 && m_nPixels[x-1][y+1]!=-1 && m_nPixels[x-1][y+1]==m_nPixels[x+1][y-1]){
				m_nTrans[x][y] = (m_nTrans[x-1][y+1] + m_nTrans[x+1][y-1])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y+1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
#ifdef HARD_GUESS_EXP
			if(x && x<m_nX-2 && m_nPixels[x-1][y]!=-1 && m_nPixels[x-1][y]==m_nPixels[x+2][y]){
				m_nTrans[x][y] = (m_nTrans[x-1][y] + m_nTrans[x+2][y])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-y)*m_row;
				int nIndex2 = (x+2)*3 + (m_bmi->biHeight-1-y)*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-2 && m_nPixels[x][y-1]!=-1 && m_nPixels[x][y-1]==m_nPixels[x][y+2]){
				m_nTrans[x][y] = (m_nTrans[x][y-1] + m_nTrans[x][y+2])/2;
				int nIndex1 = (x)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x)*3 + (m_bmi->biHeight-1-(y+2))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-2 && x && x<m_nX-2 && m_nPixels[x-1][y-1]!=-1 && m_nPixels[x-1][y-1]==m_nPixels[x+2][y+2]){
				m_nTrans[x][y] = (m_nTrans[x-1][y-1] + m_nTrans[x+2][y+2])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x+2)*3 + (m_bmi->biHeight-1-(y+2))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-2 && x && x<m_nX-2 && m_nPixels[x-1][y+2]!=-1 && m_nPixels[x-1][y+2]==m_nPixels[x+2][y-1]){
				m_nTrans[x][y] = (m_nTrans[x-1][y+2] + m_nTrans[x+2][y-1])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y+2))*m_row;
				int nIndex2 = (x+2)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y+2];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y>1 && y<m_nY-2 && x && x<m_nX-2 && m_nPixels[x-1][y+2]!=-1 && m_nPixels[x-1][y+2]==m_nPixels[x+2][y-2]){
				m_nTrans[x][y] = (m_nTrans[x-1][y+2] + m_nTrans[x+2][y-2])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y+2))*m_row;
				int nIndex2 = (x+2)*3 + (m_bmi->biHeight-1-(y-2))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y+2];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
#endif
		}
		if(m_nPixels[x][y]!=-1){
			SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
			continue;
		}
		// Series approximation - Start
		floatexp D0r;
		floatexp D0i;
		ToFloatExp(&m_lDX[x],&D0r);
		ToFloatExp(&m_lDY[y],&D0i);
		floatexp D2r = D0r*D0r-D0i*D0i;
		floatexp D2i = g_2*D0r*D0i;
		floatexp D3r = D2r*D0r-D2i*D0i;
		floatexp D3i = D2r*D0i+D2i*D0r;
#ifdef TERM4
		floatexp D4r = D3r*D0r-D3i*D0i;
		floatexp D4i = D3r*D0i+D3i*D0r;
#ifdef TERM5
		floatexp D5r = D4r*D0r-D4i*D0i;
		floatexp D5i = D4r*D0i+D4i*D0r;
#ifdef TERM6
		floatexp D6r = D5r*D0r-D5i*D0i;
		floatexp D6i = D5r*D0i+D5i*D0r;
#ifdef TERM7
		floatexp D7r = D6r*D0r-D6i*D0i;
		floatexp D7i = D6r*D0i+D6i*D0r;
#endif
#endif
#endif
#endif
		if(m_nMaxApproximation)
			antal = m_nMaxApproximation-1;
		else
			antal=0;
		floatexp TDnr = m_Ar*D0r-m_Ai*D0i;
		floatexp TDni = m_Ar*D0i+m_Ai*D0r;
		TDnr+= m_Br*D2r-m_Bi*D2i;
		TDni+= m_Br*D2i+m_Bi*D2r;
		TDnr+= m_Cr*D3r-m_Ci*D3i;
		TDni+= m_Cr*D3i+m_Ci*D3r;
#ifdef TERM4
		TDnr+= m_Dr*D4r-m_Di*D4i;
		TDni+= m_Dr*D4i+m_Di*D4r;
#ifdef TERM5
		TDnr+= m_Er*D5r-m_Ei*D5i;
		TDni+= m_Er*D5i+m_Ei*D5r;
#ifdef TERM6
		TDnr+= m_Fr*D6r-m_Fi*D6i;
		TDni+= m_Fr*D6i+m_Fi*D6r;
#ifdef TERM7
		TDnr+= m_Gr*D7r-m_Gi*D7i;
		TDni+= m_Gr*D7i+m_Gi*D7r;
#endif
#endif
#endif
#endif
		ldbl Dr, Di;
		AssignFloatExp(&Dr,&TDnr);
		AssignFloatExp(&Di,&TDni);
		double test1=0 ,test2=0;
		BOOL bGlitch=FALSE;
		if(m_nPower==2)
			m_nPixels[x][y] = Perturbation4(antal,m_ldxr,m_ldxi,&Dr,&Di,&m_lDX[x],&m_lDY[y],&test1, &test2, m_nBailout2, m_nMaxIter,m_db_z,&bGlitch);
		else
			m_nPixels[x][y] = Perturbation_3rd(antal,m_ldxr,m_ldxi,&Dr,&Di,&m_lDX[x],&m_lDY[y],&test1, &test2, m_nBailout2, m_nMaxIter,m_db_z,&bGlitch);

		if(m_nSmoothMethod==1){
			if(m_nPixels[x][y]==m_nMaxIter)
				m_nTrans[x][y]=0;
			else{
				double div = sqrt(test1)-sqrt(test2);
				if(div!=0)
					m_nTrans[x][y] = (sqrt(test1)-m_nBailout)/div;
				else
					m_nTrans[x][y] = 0;
			}

		}
		else if(m_nSmoothMethod==0){
			if(m_nPixels[x][y]==m_nMaxIter)
				m_nTrans[x][y]=0;
			else{
				if(m_nPower==2)
					m_nTrans[x][y] = log (log  (sqrt(test1))) / log (2.0);
				else
					m_nTrans[x][y] = log (log  (sqrt(test1))) / log (3.0);
				while(m_nTrans[x][y]<0){
					m_nPixels[x][y]++;
					m_nTrans[x][y]+=1;
				}
				while(m_nTrans[x][y]>1){
					m_nPixels[x][y]--;
					m_nTrans[x][y]-=1;
				}
			}
		}
		if(bGlitch && !m_bNoGlitchDetection){
			m_nTrans[x][y]=2;
			m_nPixels[x][y]=m_nMaxIter-1;//(m_nMaxApproximation?m_nMaxApproximation-1:0);
		}

		InterlockedIncrement((LPLONG)&m_nDone);
		SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
		if(m_bMirrored)
			Mirror(x,y);
		if(!nPStep){
			int q;
			for(q=0;q<9;q++){
				int tx = x + q%3;
				int ty = y + q/3;
				if(tx<m_nX-1 && ty<m_nY-1 && m_nPixels[tx][ty]==-1){
					int nIndex1 = tx*3 + (m_bmi->biHeight-1-ty)*m_row;
					m_lpBits[nIndex1]=m_lpBits[nIndex];
					m_lpBits[nIndex1+1]=m_lpBits[nIndex+1];
					m_lpBits[nIndex1+2]=m_lpBits[nIndex+2];
				}
			}
		}
	}
}
void CFraktalSFT::MandelCalcEXP(int nXStart,int nXStop)
{
	m_bIterChanged=TRUE;
	floatexp Dnr, Dni, yr, yi, _2=2, _3=3, _4=4, _6=6;
	int antal, x, y;
	int nPStep;


	while(!m_bStop && m_P.GetPixel(x,y)){
		nPStep = m_P.GetStep();
		if(nPStep>1)
			nPStep=0;
		else
			nPStep=1;
		int nIndex = x*3 + (m_bmi->biHeight-1-y)*m_row;
		if(m_nPixels[x][y]!=-1){
			SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
			continue;
		}
		if(nPStep){
			if(x && x<m_nX-1 && m_nPixels[x-1][y]!=-1 && m_nPixels[x-1][y]==m_nPixels[x+1][y]){
				m_nTrans[x][y] = (m_nTrans[x-1][y] + m_nTrans[x+1][y])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && m_nPixels[x][y-1]!=-1 && m_nPixels[x][y-1]==m_nPixels[x][y+1]){
				m_nTrans[x][y] = (m_nTrans[x][y-1] + m_nTrans[x][y+1])/2;
				int nIndex1 = (x)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && x && x<m_nX-1 && m_nPixels[x-1][y-1]!=-1 && m_nPixels[x-1][y-1]==m_nPixels[x+1][y+1]){
				m_nTrans[x][y] = (m_nTrans[x-1][y-1] + m_nTrans[x+1][y+1])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-1 && x && x<m_nX-1 && m_nPixels[x-1][y+1]!=-1 && m_nPixels[x-1][y+1]==m_nPixels[x+1][y-1]){
				m_nTrans[x][y] = (m_nTrans[x-1][y+1] + m_nTrans[x+1][y-1])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y+1))*m_row;
				int nIndex2 = (x+1)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y+1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
#ifdef HARD_GUESS_EXP
			if(x && x<m_nX-2 && m_nPixels[x-1][y]!=-1 && m_nPixels[x-1][y]==m_nPixels[x+2][y]){
				m_nTrans[x][y] = (m_nTrans[x-1][y] + m_nTrans[x+2][y])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-y)*m_row;
				int nIndex2 = (x+2)*3 + (m_bmi->biHeight-1-y)*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-2 && m_nPixels[x][y-1]!=-1 && m_nPixels[x][y-1]==m_nPixels[x][y+2]){
				m_nTrans[x][y] = (m_nTrans[x][y-1] + m_nTrans[x][y+2])/2;
				int nIndex1 = (x)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x)*3 + (m_bmi->biHeight-1-(y+2))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-2 && x && x<m_nX-2 && m_nPixels[x-1][y-1]!=-1 && m_nPixels[x-1][y-1]==m_nPixels[x+2][y+2]){
				m_nTrans[x][y] = (m_nTrans[x-1][y-1] + m_nTrans[x+2][y+2])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				int nIndex2 = (x+2)*3 + (m_bmi->biHeight-1-(y+2))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y-1];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y && y<m_nY-2 && x && x<m_nX-2 && m_nPixels[x-1][y+2]!=-1 && m_nPixels[x-1][y+2]==m_nPixels[x+2][y-1]){
				m_nTrans[x][y] = (m_nTrans[x-1][y+2] + m_nTrans[x+2][y-1])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y+2))*m_row;
				int nIndex2 = (x+2)*3 + (m_bmi->biHeight-1-(y-1))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y+2];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
			if(y>1 && y<m_nY-2 && x && x<m_nX-2 && m_nPixels[x-1][y+2]!=-1 && m_nPixels[x-1][y+2]==m_nPixels[x+2][y-2]){
				m_nTrans[x][y] = (m_nTrans[x-1][y+2] + m_nTrans[x+2][y-2])/2;
				int nIndex1 = (x-1)*3 + (m_bmi->biHeight-1-(y+2))*m_row;
				int nIndex2 = (x+2)*3 + (m_bmi->biHeight-1-(y-2))*m_row;
				m_lpBits[nIndex]     = (m_lpBits[nIndex1]+m_lpBits[nIndex2])/2;
				m_lpBits[nIndex + 1] = (m_lpBits[nIndex1 + 1]+m_lpBits[nIndex2 + 1])/2;
				m_lpBits[nIndex + 2] = (m_lpBits[nIndex1 + 2]+m_lpBits[nIndex2 + 2])/2;
				InterlockedIncrement((LPLONG)&m_nDone);
				InterlockedIncrement((LPLONG)&m_nGuessed);
				m_nPixels[x][y] = m_nPixels[x-1][y+2];
				if(m_bMirrored)
					Mirror(x,y);
				continue;
			}
#endif
		}
		if(m_nPixels[x][y]!=-1){
			SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
			continue;
		}
		// Series approximation
		floatexp D0r=m_DX[x];//(cr-rref);
		floatexp D0i=m_DY[y];
		floatexp Dr = D0r;
		floatexp Di = D0i;
		floatexp D2r = Dr*Dr-Di*Di;
		floatexp D2i = _2*Dr*Di;
		floatexp D3r = D2r*Dr-D2i*Di;
		floatexp D3i = D2r*Di+D2i*Dr;
#ifdef TERM4
		floatexp D4r = D3r*Dr-D3i*Di;
		floatexp D4i = D3r*Di+D3i*Dr;
#ifdef TERM5
		floatexp D5r = D4r*Dr-D4i*Di;
		floatexp D5i = D4r*Di+D4i*Dr;
#ifdef TERM6
		floatexp D6r = D5r*Dr-D5i*Di;
		floatexp D6i = D5r*Di+D5i*Dr;
#ifdef TERM7
		floatexp D7r = D6r*Dr-D6i*Di;
		floatexp D7i = D6r*Di+D6i*Dr;
#endif
#endif
#endif
#endif
		if(m_nMaxApproximation)
			antal = m_nMaxApproximation-1;
		else
			antal=0;
		Dnr = m_Ar*Dr-m_Ai*Di;
		Dni = m_Ar*Di+m_Ai*Dr;
		Dnr+= m_Br*D2r-m_Bi*D2i;
		Dni+= m_Br*D2i+m_Bi*D2r;
		Dnr+= m_Cr*D3r-m_Ci*D3i;
		Dni+= m_Cr*D3i+m_Ci*D3r;
#ifdef TERM4
		Dnr+= m_Dr*D4r-m_Di*D4i;
		Dni+= m_Dr*D4i+m_Di*D4r;
#ifdef TERM5
		Dnr+= m_Er*D5r-m_Ei*D5i;
		Dni+= m_Er*D5i+m_Ei*D5r;
#ifdef TERM6
		Dnr+= m_Fr*D6r-m_Fi*D6i;
		Dni+= m_Fr*D6i+m_Fi*D6r;
#ifdef TERM7
		Dnr+= m_Gr*D7r-m_Gi*D7i;
		Dni+= m_Gr*D7i+m_Gi*D7r;
#endif
#endif
#endif
#endif
		Dr=Dnr;
		Di=Dni;


		double test1=0 ,test2=0;
		BOOL bGlitch=FALSE;
		if(m_nPower==2){
			if(antal<m_nMaxIter && test1 <= m_nBailout2){
				for(;antal<m_nMaxIter && test1 <= m_nBailout2;antal++){
					yr=m_dxr[antal]+Dr;
					yi=m_dxi[antal]+Di;
					test2=test1;
					test1 = (yr*yr+yi*yi).todouble();
					if(test1<m_db_z[antal]){
						test1 = m_nBailout2*2;
						bGlitch=TRUE;
					}
					Dnr = (m_dxr[antal]*Dr - m_dxi[antal]*Di)*_2 + Dr*Dr - Di*Di + D0r;
					Dni = (m_dxr[antal]*Di + m_dxi[antal]*Dr + Dr*Di)*_2 + D0i;
					Di = Dni;
					Dr = Dnr;
				}
			}
		}
		else{
			if(antal<m_nMaxIter && test1 <= m_nBailout2){
				for(;antal<m_nMaxIter && test1 <= m_nBailout2;antal++){
					yr=m_dxr[antal]+Dr;
					yi=m_dxi[antal]+Di;
					test2=test1;
					test1 = (yr*yr+yi*yi).todouble();
					if(test1<m_db_z[antal]){
						test1 = m_nBailout2*2;
						bGlitch=TRUE;
					}
					Dnr = _3*m_dxr[antal]*m_dxr[antal]*Dr - _6*m_dxr[antal]*m_dxi[antal]*Di - _3*m_dxi[antal]*m_dxi[antal]*Dr + _3*m_dxr[antal]*Dr*Dr - _3*m_dxr[antal]*Di*Di - _3*m_dxi[antal]*2*Dr*Di + Dr*Dr*Dr - _3*Dr*Di*Di + D0r;
					Dni = _3*m_dxr[antal]*m_dxr[antal]*Di + _6*m_dxr[antal]*m_dxi[antal]*Dr - _3*m_dxi[antal]*m_dxi[antal]*Di + _3*m_dxr[antal]*2*Dr*Di + _3*m_dxi[antal]*Dr*Dr - _3*m_dxi[antal]*Di*Di + _3*Dr*Dr*Di - Di*Di*Di + D0i;
					Di = Dni;
					Dr = Dnr;
				}
			}
		}

		InterlockedIncrement((LPLONG)&m_nDone);
		if(antal==m_nMaxIter){
			m_nPixels[x][y] = antal;
			m_nTrans[x][y]=0;
			m_lpBits[nIndex]     = 0;
			m_lpBits[nIndex + 1] = 0;
			m_lpBits[nIndex + 2] = 0;
			if(!nPStep){
				int q;
				for(q=0;q<9;q++){
					int tx = x + q%3;
					int ty = y + q/3;
					if(tx<m_nX-1 && ty<m_nY-1 && m_nPixels[tx][ty]==-1){
						int nIndex1 = tx*3 + (m_bmi->biHeight-1-ty)*m_row;
						m_lpBits[nIndex1]=m_lpBits[nIndex];
						m_lpBits[nIndex1+1]=m_lpBits[nIndex+1];
						m_lpBits[nIndex1+2]=m_lpBits[nIndex+2];
					}
				}
			}
		}
		else{
			m_nPixels[x][y] = antal;
			if(m_nSmoothMethod==1){
				double div = sqrt(test1)-sqrt(test2);
				if(div!=0)
					m_nTrans[x][y] = (sqrt(test1)-m_nBailout)/div;
				else
					m_nTrans[x][y] = 0;
			}
			else if(m_nSmoothMethod==0){
				if(m_nPower==2)
					m_nTrans[x][y] = log (log  (sqrt(test1))) / log (2.0);
				else
					m_nTrans[x][y] = log (log  (sqrt(test1))) / log (3.0);
				while(m_nTrans[x][y]<0){
					m_nPixels[x][y]++;
					m_nTrans[x][y]+=1;
				}
				while(m_nTrans[x][y]>1){
					m_nPixels[x][y]--;
					m_nTrans[x][y]-=1;
				}
			}
			if(bGlitch && !m_bNoGlitchDetection){
				m_nTrans[x][y]=2;
				m_nPixels[x][y]=m_nMaxIter-1;//(m_nMaxApproximation?m_nMaxApproximation-1:0);
			}
			SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
			if(m_bMirrored)
				Mirror(x,y);
			if(!nPStep){
				int q;
				for(q=0;q<9;q++){
					int tx = x + q%3;
					int ty = y + q/3;
					if(tx<m_nX-1 && ty<m_nY-1 && m_nPixels[tx][ty]==-1){
						int nIndex1 = tx*3 + (m_bmi->biHeight-1-ty)*m_row;
						m_lpBits[nIndex1]=m_lpBits[nIndex];
						m_lpBits[nIndex1+1]=m_lpBits[nIndex+1];
						m_lpBits[nIndex1+2]=m_lpBits[nIndex+2];
					}
				}
			}
		}
	}
}
int WINAPI ThRenderFractal(CFraktalSFT *p)
{
#ifndef _DEBUG
	__try{
#endif
	p->RenderFractal();
#ifndef _DEBUG
	}__except(1){
	}
#endif
	return 0;
}
void CFraktalSFT::RenderFractal(int nX,int nY,int nMaxIter,HWND hWnd,BOOL bNoThread,BOOL bResetOldGlitch)
{
	m_bStop=FALSE;
	if(hWnd)
		m_hWnd = hWnd;
	m_nX = nX;
	m_nY = nY;
	m_nMaxIter = nMaxIter;
	m_nRDone = m_nDone = m_nGuessed = 0;
	if(m_pDX){
		delete [] m_pDX;
		m_pDX=NULL;
	}
	if(m_pDY){
		delete [] m_pDY;
		m_pDY=NULL;
	}
	if(m_DX){
		delete [] m_DX;
		m_DX=NULL;
	}
	if(m_DY){
		delete [] m_DY;
		m_DY=NULL;
	}
	if(m_lDX){
		ReleaseArray(m_lDX);
		m_lDX=NULL;
	}
	if(m_lDY){
		ReleaseArray(m_lDY);
		m_lDY=NULL;
	}
	if(bResetOldGlitch)
		memset(m_pOldGlitch,-1,sizeof(m_pOldGlitch));

	WaitForSingleObject(m_hMutex,INFINITE);
	int i;
	if(m_nXPrev!=m_nX || m_nYPrev!=m_nY){
		if(m_nPixels){
			for(i=0;i<m_nXPrev;i++)
				delete [] m_nPixels[i];
			delete [] m_nPixels;
		}
		m_nPixels = new int*[m_nX];
		for(i=0;i<m_nX;i++)
			m_nPixels[i] = new int[m_nY];

		if(m_nTrans){
			for(i=0;i<m_nXPrev;i++)
				delete [] m_nTrans[i];
			delete [] m_nTrans;
		}
		m_nTrans = new float*[m_nX];
		for(i=0;i<m_nX;i++){
			m_nTrans[i] = new float[m_nY];
			memset(m_nTrans[i],0,sizeof(float)*m_nY);
		}

		m_nXPrev=m_nX;
		m_nYPrev=m_nY;
		DeleteObject(m_bmBmp);
		m_bmBmp=NULL;
	}

	HDC hDC = GetDC(NULL);
	if(!m_bmBmp)
		m_bmBmp = CreateCompatibleBitmap(hDC,m_nX,m_nY);
	if(!m_bAddReference){
		if(m_bmi)
			free(m_bmi);
		m_bmi = (BITMAPINFOHEADER *)malloc(sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*256);
		memset(m_bmi,0,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*256);
		m_bmi->biSize = sizeof(BITMAPINFOHEADER);
		if(!GetDIBits(hDC,m_bmBmp,0,0,NULL,(LPBITMAPINFO)m_bmi,DIB_RGB_COLORS))
			/*Beep(1000,10)*/;
		m_bmi->biCompression=m_bmi->biClrUsed=m_bmi->biClrImportant=0;
		m_bmi->biBitCount = 24;
		if(m_bmi->biBitCount!=24)
			m_bmi->biClrUsed = 1<<m_bmi->biBitCount;
		m_row = ((((m_bmi->biWidth*(DWORD)m_bmi->biBitCount)+31)&~31) >> 3);
		m_bmi->biSizeImage=m_row*m_bmi->biHeight;
		if(!m_lpBits || (int)m_bmi->biSizeImage!=m_nSizeImage){
			m_nSizeImage=m_bmi->biSizeImage;
			if(m_lpBits)
				delete [] m_lpBits;
			m_lpBits = new BYTE[m_bmi->biSizeImage];

			if(!GetDIBits(hDC,m_bmBmp,0,m_bmi->biHeight,m_lpBits,
					(LPBITMAPINFO)m_bmi,DIB_RGB_COLORS))
				/*Beep(1000,10)*/;
		}
	}
	ReleaseDC(NULL,hDC);
	ReleaseMutex(m_hMutex);

	if(bNoThread){
		SetTimer(m_hWnd,0,100,NULL);
		ThRenderFractal(this);
	}
	else{
		m_bRunning=TRUE;
		DWORD dw;
		HANDLE hThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)ThRenderFractal,(LPVOID)this,0,&dw);
		CloseHandle(hThread);
	}
}
void CFraktalSFT::RenderFractal()
{
	CFixedFloat div = m_istop-m_istart;

	int nZeroes=0;
	char *szZoom = m_istop.ToText();
	if(*szZoom=='-')
		szZoom++;
	if(*szZoom=='0'){
		szZoom++;
		if(*szZoom=='.'){
			szZoom++;
			while(*szZoom=='0'){
				nZeroes++;
				szZoom++;
			}
		}
	}

	ToZoom((CDecNumber)4/((CDecNumber)div.ToText()),m_nZoom);
	m_rstart.SetMaxSignificant((int)m_nZoom+nZeroes+16);
	if(m_bAddReference){
		int x, y;
		m_nTotal=0;
		for(x=0;x<m_nX;x++)
			for(y=0;y<m_nY;y++)
				if(m_nPixels[x][y]==-1)
					m_nTotal++;
	}
	else
		m_nTotal=m_nX*m_nY;
	if(m_nZoom>/*600*/g_nLDBL && g_LDBL && m_nZoom<=g_nEXP){
		if(m_db_dxr){
			delete [] m_db_dxr;
			m_db_dxr=NULL;
		}
		if(m_db_dxi){
			delete [] m_db_dxi;
			m_db_dxi=NULL;
		}
		if(m_dxr){
			delete [] m_dxr;
			m_dxr=NULL;
		}
		if(m_dxi){
			delete [] m_dxi;
			m_dxi=NULL;
		}
		RenderFractalLDBL();
		return;
	}
	else if(m_nZoom>g_nLDBL/*600*/){
		if(m_db_dxr){
			delete [] m_db_dxr;
			m_db_dxr=NULL;
		}
		if(m_db_dxi){
			delete [] m_db_dxi;
			m_db_dxi=NULL;
		}
		if(m_ldxr){
			ReleaseArray(m_ldxr);
			m_ldxr=NULL;
		}
		if(m_ldxi){
			ReleaseArray(m_ldxi);
			m_ldxi=NULL;
		}
		RenderFractalEXP();
		return;
	}
	if(m_ldxr){
		ReleaseArray(m_ldxr);
		m_ldxr=NULL;
	}
	if(m_ldxi){
		ReleaseArray(m_ldxi);
		m_ldxi=NULL;
	}
	if(m_dxr){
		delete [] m_dxr;
		m_dxr=NULL;
	}
	if(m_dxi){
		delete [] m_dxi;
		m_dxi=NULL;
	}
	m_P.Init(2,m_nX,m_nY);
	int i;
	if(!m_bReuseRef || !m_db_dxr || m_nZoom<g_nRefZero){
		if(!m_bAddReference || m_nZoom<g_nRefZero){
			if(m_nZoom>=g_nRefZero){
				m_rref = (m_rstop+m_rstart)/2;
				m_iref = (m_istop+m_istart)/2;
			}
			else{
				m_rref=0;
				m_iref=0;
			}
		}
		m_nScalingOffset=0;
		m_nScaling=1;
		for(i=300;i<m_nZoom;i++){
			m_nScalingOffset++;
			m_nScaling=m_nScaling*.1;
		}
		CalculateReference();
	}
	int x, y;
	if(!m_pDX || !m_pDY){
		CFixedFloat c = m_rstart;
		CFixedFloat step = (m_rstop-m_rstart)*(1/(double)m_nX);
		m_pDX = new double[m_nX];
		for(x=0;x<m_nX;x++,c+=step)
			m_pDX[x]=(c-m_rref).ToDouble(m_nScalingOffset);
		c = m_istart;
		step = (m_istop-m_istart)*(1/(double)m_nY);
		m_pDY = new double[m_nY];
		for(y=0;y<m_nY;y++,c+=step)
			m_pDY[y]=(c-m_iref).ToDouble(m_nScalingOffset);
	}

	m_rApprox.left=0;
	m_rApprox.top=0;
	m_rApprox.right=m_nX;
	m_rApprox.bottom=m_nY;

	CalculateApproximation(0);

	// CalcStart
	if(!m_bAddReference){
		for(y=0;y<m_nY;y++){
			for(x=0;x<m_nX;x++){
				m_nPixels[x][y]=-1;
				m_nTrans[x][y]=0;
			}
		}
	}

	SYSTEM_INFO sysinfo; 
	GetSystemInfo( &sysinfo ); 
	int nParallel=1; 
	if(sysinfo.dwNumberOfProcessors>1)
		nParallel = 4*sysinfo.dwNumberOfProcessors;
	int nStep = m_nX/nParallel;
	int nXStart = 0;

	CParallell P(
#ifdef _DEBUG
		1
#else
		nParallel
#endif
		);
	TH_PARAMS *pMan = new TH_PARAMS[nParallel];
	nXStart = 0;
	for(i=0;i<nParallel;i++){
		pMan[i].p = this;
		pMan[i].nXStart = nXStart;
		nXStart+=nStep;
		if(nXStart>m_nX)
			nXStart=m_nX;
		if(i==nParallel-1)
			pMan[i].nXStop = m_nX;
		else
			pMan[i].nXStop = nXStart;
		P.AddFunction((LPEXECUTE)ThMandelCalc,&pMan[i]);
		if(pMan[i].nXStop==m_nX && pMan[i].nXStop-pMan[i].nXStart>1 && i<nParallel-1){
			pMan[i].nXStop--;
			nXStart=pMan[i].nXStop;
		}
		if(pMan[i].nXStop==m_nX){
			break;
		}
	}
	P.Execute();
	P.Reset();
	delete [] pMan;
	m_bAddReference=FALSE;
	m_bNoGlitchDetection=FALSE;
	PostMessage(m_hWnd,WM_USER+199,m_bStop,0);
	m_bRunning=FALSE;
}
void CFraktalSFT::RenderFractalLDBL()
{
	m_P.Init(3,m_nX,m_nY);
	if(!m_bReuseRef || !m_ldxr){
		if(!m_bAddReference){
			m_rref = (m_rstop+m_rstart)/2;
			m_iref = (m_istop+m_istart)/2;
		}
		CalculateReferenceLDBL();
	}
	int i;
	int x, y;
	if(!m_lDX || !m_lDY){
		CFixedFloat c = m_rstart;
		CFixedFloat step = (m_rstop-m_rstart)*(1/(double)m_nX);
		m_lDX = (ldbl*)AllocateArray(m_nX);
		CFixedFloat tmp;
		for(x=0;x<m_nX;x++,c+=step){
			tmp = c-m_rref;
			ConvertFromFixedFloat(&m_lDX[x],tmp.m_nValues,tmp.m_pValues,tmp.m_bSign);
		}
		c = m_istart;
		step = (m_istop-m_istart)*(1/(double)m_nY);
		m_lDY = (ldbl*)AllocateArray(m_nY);
		for(y=0;y<m_nY;y++,c+=step){
			tmp = c-m_iref;
			ConvertFromFixedFloat(&m_lDY[y],tmp.m_nValues,tmp.m_pValues,tmp.m_bSign);
		}
	}
	m_rApprox.left=0;
	m_rApprox.top=0;
	m_rApprox.right=m_nX;
	m_rApprox.bottom=m_nY;
	CalculateApproximation(1);
	if(0 && m_bStop){
		PostMessage(m_hWnd,WM_USER+199,m_bStop,0);
		m_bRunning=FALSE;
		return;
	}


	// CalcStart
	if(!m_bAddReference){
		for(y=0;y<m_nY;y++){
			for(x=0;x<m_nX;x++){
				m_nPixels[x][y]=-1;
				m_nTrans[x][y]=0;
			}
		}
	}

	SYSTEM_INFO sysinfo; 
	GetSystemInfo( &sysinfo ); 
	int nParallel=1; 
	if(sysinfo.dwNumberOfProcessors>1)
		nParallel = 4*sysinfo.dwNumberOfProcessors;
	CParallell P(
#ifdef _DEBUG
		1
#else
		nParallel
#endif
		);
	TH_PARAMS *pMan = new TH_PARAMS[nParallel];
	int nStep = m_nX/nParallel;
	if(nStep<2)
		nStep=2;
	else
		nStep++;
	int nXStart = 0;
	for(i=0;i<nParallel;i++){
		pMan[i].p = this;
		pMan[i].nXStart = nXStart;
		nXStart+=nStep;
		if(nXStart>m_nX)
			nXStart=m_nX;
		if(i==nParallel-1)
			pMan[i].nXStop = m_nX;
		else
			pMan[i].nXStop = nXStart;
		P.AddFunction((LPEXECUTE)ThMandelCalcLDBL,&pMan[i]);
		if(pMan[i].nXStop==m_nX && pMan[i].nXStop-pMan[i].nXStart>1 && i<nParallel-1){
			pMan[i].nXStop--;
			nXStart=pMan[i].nXStop;
		}
		if(pMan[i].nXStop==m_nX){
			break;
		}
	}
	P.Execute();
	P.Reset();
	delete [] pMan;
	m_bAddReference=FALSE;
	m_bNoGlitchDetection=FALSE;
	PostMessage(m_hWnd,WM_USER+199,m_bStop,0);
	m_bRunning=FALSE;
}
void CFraktalSFT::RenderFractalEXP()
{
	m_P.Init(3,m_nX,m_nY);
	if(!m_bReuseRef || !m_dxr){
		if(!m_bAddReference){
			m_rref = (m_rstop+m_rstart)/2;
			m_iref = (m_istop+m_istart)/2;
		}
		CalculateReferenceEXP();
	}
	int i;
	int x, y;
	if(!m_DX || !m_DY){
		CFixedFloat c = m_rstart;
		CFixedFloat step = (m_rstop-m_rstart)*(1/(double)m_nX);
		m_DX = new floatexp[m_nX];
		for(x=0;x<m_nX;x++,c+=step)
			m_DX[x]=(c-m_rref);
		c = m_istart;
		step = (m_istop-m_istart)*(1/(double)m_nY);
		m_DY = new floatexp[m_nY];
		for(y=0;y<m_nY;y++,c+=step)
			m_DY[y]=(c-m_iref);
	}
	m_rApprox.left=0;
	m_rApprox.top=0;
	m_rApprox.right=m_nX;
	m_rApprox.bottom=m_nY;
	CalculateApproximation(2);

	// CalcStart
	if(!m_bAddReference){
		for(y=0;y<m_nY;y++){
			for(x=0;x<m_nX;x++){
				m_nPixels[x][y]=-1;
				m_nTrans[x][y]=0;
			}
		}
	}
	if(0 && m_bStop){
		PostMessage(m_hWnd,WM_USER+199,m_bStop,0);
		m_bRunning=FALSE;
		return;
	}

	SYSTEM_INFO sysinfo; 
	GetSystemInfo( &sysinfo ); 
	int nParallel=1; 
	if(sysinfo.dwNumberOfProcessors>1)
		nParallel = 4*sysinfo.dwNumberOfProcessors;
	CParallell P(
#ifdef _DEBUG
		1
#else
		nParallel
#endif
		);
	TH_PARAMS *pMan = new TH_PARAMS[nParallel];
	int nStep = m_nX/nParallel;
	if(nStep<2)
		nStep=2;
	else
		nStep++;
	int nXStart = 0;
	for(i=0;i<nParallel;i++){
		pMan[i].p = this;
		pMan[i].nXStart = nXStart;
		nXStart+=nStep;
		if(nXStart>m_nX)
			nXStart=m_nX;
		if(i==nParallel-1)
			pMan[i].nXStop = m_nX;
		else
			pMan[i].nXStop = nXStart;
		P.AddFunction((LPEXECUTE)ThMandelCalcEXP,&pMan[i]);
		if(pMan[i].nXStop==m_nX && pMan[i].nXStop-pMan[i].nXStart>1 && i<nParallel-1){
			pMan[i].nXStop--;
			nXStart=pMan[i].nXStop;
		}
		if(pMan[i].nXStop==m_nX){
			break;
		}
	}
	P.Execute();
	delete [] pMan;
	m_bAddReference=FALSE;
	m_bNoGlitchDetection=FALSE;
	PostMessage(m_hWnd,WM_USER+199,m_bStop,0);
	m_bRunning=FALSE;
}
void CFraktalSFT::SetPosition(CFixedFloat &rstart, CFixedFloat &rstop, CFixedFloat &istart,CFixedFloat &istop,int nX, int nY)
{
	m_rstart.SetMaxSignificant(0);
	m_rstart = rstart;
	m_rstop = rstop;
	m_istart = istart;
	m_istop = istop;
	CFixedFloat re = (rstop+rstart)/2;
	if(m_nX!=nX || m_nY!=nY){
		int i;
		for(i=0;i<m_nXPrev;i++)
			delete [] m_nPixels[i];
		delete [] m_nPixels;
		m_nPixels=NULL;

		for(i=0;i<m_nXPrev;i++)
			delete [] m_nTrans[i];
		delete [] m_nTrans;
		m_nTrans=NULL;
	}
	m_nX = nX;
	m_nY = nY;

	CFixedFloat d = ((CFixedFloat)nX/(CFixedFloat)(nY))*(istop-istart)/2;
	m_rstart = re-d;
	m_rstop = re+d;
}
void CFraktalSFT::SetPosition(char *szR, char *szI, char *szZ)
{
	m_rref = szR;
	m_iref = szI;
	CDecNumber re = szR;
	CDecNumber im = szI;
	CDecNumber z = szZ;
	CDecNumber d = 2/z;
	CDecNumber istart = im-d;
	CDecNumber istop = im+d;
	d = ((CDecNumber)640/(CDecNumber)(360))*(istop-istart)/2;
	CDecNumber rstart = re-d;
	CDecNumber rstop = re+d;
	m_rstart.SetMaxSignificant(0);
	m_rstart = rstart.ToText();
	m_rstop = rstop.ToText();
	m_istart = istart.ToText();
	m_istop = istop.ToText();
}

HBITMAP CFraktalSFT::GetBitmap()
{
	WaitForSingleObject(m_hMutex,INFINITE);
	if(m_bmi && m_lpBits){
		HDC hDC = GetDC(NULL);
		if(!SetDIBits(hDC,m_bmBmp,0,m_bmi->biHeight,m_lpBits,
				(LPBITMAPINFO)m_bmi,DIB_RGB_COLORS))
			Beep(1000,10);
		ReleaseDC(NULL,hDC);
	}
	ReleaseMutex(m_hMutex);
	return m_bmBmp;
}
void CFraktalSFT::UpdateBitmap()
{
	WaitForSingleObject(m_hMutex,INFINITE);
	if(m_bmi && m_lpBits){
		HDC hDC = GetDC(NULL);
		if(!GetDIBits(hDC,m_bmBmp,0,m_bmi->biHeight,m_lpBits,
				(LPBITMAPINFO)m_bmi,DIB_RGB_COLORS))
			/*Beep(1000,10)*/;
		ReleaseDC(NULL,hDC);
	}
	ReleaseMutex(m_hMutex);
}
int CFraktalSFT::GetWidth()
{
	return m_nX;
}
int CFraktalSFT::GetHeight()
{
	return m_nY;
}
void CFraktalSFT::Stop()
{
	m_bStop=TRUE;
	m_bAddReference=FALSE;
	m_bNoGlitchDetection=FALSE;
	while(m_bRunning)
		Sleep(1);
	m_bStop=FALSE;
}

void CFraktalSFT::Zoom(int nXPos,int nYPos,double nZoomSize,int nWidth,int nHeight,BOOL bReuseCenter)
{
	Stop();
	int **Org;
	float **OrgT;
	int nOX, nOY;
	int i;
	m_bAddReference=FALSE;
	m_bNoGlitchDetection=FALSE;
	if(m_nX!=nWidth || m_nY!=nHeight){
		for(i=0;i<m_nXPrev;i++)
			delete [] m_nPixels[i];
		delete [] m_nPixels;
		m_nPixels=NULL;

		for(i=0;i<m_nXPrev;i++)
			delete [] m_nTrans[i];
		delete [] m_nTrans;
		m_nTrans=NULL;
	}
	else if(bReuseCenter && nZoomSize<1){
		m_bAddReference=TRUE;
		nOX = nWidth*nZoomSize;
		nOY = nHeight*nZoomSize;
		Org = new int*[nOX];
		for(i=0;i<nOX;i++)
			Org[i] = new int[nOY];
		OrgT = new float*[nOX];
		for(i=0;i<nOX;i++)
			OrgT[i] = new float[nOY];
		int x, y, a, b;
		for(x=0;x<nOX;x++){
			for(y=0;y<nOY;y++){
				a = x/nZoomSize;
				b = y/nZoomSize;
				if(a>=0 && a<m_nX && b>=0 && b<m_nY)
					Org[x][y]=m_nPixels[a][b];
				if(a>=0 && a<m_nX && b>=0 && b<m_nY)
					OrgT[x][y]=m_nTrans[a][b];
			}
		}
		a = (nWidth-nOX)/2;
		b = (nHeight-nOY)/2;
		for(x=0;x<m_nX;x++){
			for(y=0;y<m_nY;y++){
				if(x-a>0 && x-a<nOX-1 && y-b>0 && y-b<nOY-1){
					m_nPixels[x][y]=Org[x-a][y-b];
					m_nTrans[x][y]=OrgT[x-a][y-b];
				}
				else
					m_nPixels[x][y]=-1;
			}
		}
		for(i=0;i<nOX;i++){
			delete [] Org[i];
			delete [] OrgT[i];
		}
		delete [] Org;
		delete [] OrgT;
	}
	m_nX=nWidth;
	m_nY=nHeight;
	CFixedFloat nr = (m_rstop-m_rstart)/(CFixedFloat)(nZoomSize*2);
	CFixedFloat ni = (m_istop-m_istart)/(CFixedFloat)(nZoomSize*2);
	CFixedFloat offsr = (CFixedFloat)nXPos*(m_rstop-m_rstart)/(CFixedFloat)m_nX + m_rstart;
	CFixedFloat offsi = (CFixedFloat)nYPos*(m_istop-m_istart)/(CFixedFloat)m_nY + m_istart;
	m_rstart = offsr-nr;
	m_rstop = offsr+nr;
	m_istart = offsi-ni;
	m_istop = offsi+ni;
	RenderFractal(m_nX,m_nY,m_nMaxIter,m_hWnd);
}

int CFraktalSFT::GetProgress(int *pnGuessed,int *pnRDone)
{
	if(pnGuessed)
		*pnGuessed = m_nGuessed*100/(m_nDone?m_nDone:1);
	if(pnRDone)
		*pnRDone = m_nRDone*100/(m_nMaxIter?m_nMaxIter:1);
	if(!m_bmi)
		return 0;
	if(!m_nTotal)
		return 100;
	return m_nDone*100/m_nTotal;
}
char *CFraktalSFT::GetPosition()
{
	CStringTable st;
	if(m_szPosition)
		st.DeleteToText(m_szPosition);
	st.AddRow();
	st.AddString(st.GetCount()-1,"MANDELBROT:");
	st.AddRow();
	st.AddString(st.GetCount()-1,"R-Start");
	st.AddString(st.GetCount()-1,m_rstart.ToText());
	st.AddRow();
	st.AddString(st.GetCount()-1,"R-Stop");
	st.AddString(st.GetCount()-1,m_rstop.ToText());
	st.AddRow();
	st.AddString(st.GetCount()-1,"I-Start");
	st.AddString(st.GetCount()-1,m_istart.ToText());
	st.AddRow();
	st.AddString(st.GetCount()-1,"I-Stop");
	st.AddString(st.GetCount()-1,m_istop.ToText());
	st.AddRow();
	st.AddString(st.GetCount()-1,"Max-Iter");
	st.AddInt(st.GetCount()-1,m_nMaxIter);
	if(m_nPixels){
		int x, y;
		int nMax=-1, nMin=-1;
		for(x=0;x<m_nX;x++){
			for(y=0;y<m_nY;y++){
				if(nMin==-1 || nMin>m_nPixels[x][y])
					nMin=m_nPixels[x][y];
				if(nMax==-1 || nMax<m_nPixels[x][y])
					nMax=m_nPixels[x][y];
			}
		}
		st.AddRow();
		st.AddString(st.GetCount()-1,"Iter-Min");
		st.AddInt(st.GetCount()-1,nMin);
		st.AddRow();
		st.AddString(st.GetCount()-1,"Iter-Max");
		st.AddInt(st.GetCount()-1,nMax);
	}
	m_szPosition = st.ToText(":","\n");
	return m_szPosition;
}
int CFraktalSFT::CountFrames(int nProcent)
{
	char szTmp[10];
	strcpy(szTmp,ToZoom());
	if(strlen(szTmp)>4)
		szTmp[4]=0;
	return (int)((log10(atof(szTmp)) + m_nZoom)/(log10(1 + (double)2*(double)nProcent/(double)100))) + 1;

	CFixedFloat t_istart = m_istart;
	CFixedFloat t_istop = m_istop;
	if(nProcent==0)
		nProcent=1;

	int i;
	for(i=0;;i++){
		t_istart = t_istart - (CFixedFloat)nProcent*(t_istop-t_istart)/(CFixedFloat)100;
		t_istop = t_istop + (CFixedFloat)nProcent*(t_istop-t_istart)/(CFixedFloat)100;
		if((t_istop-t_istart)>4)
			break;
	}
	return i+1;
}
void CFraktalSFT::GetIterations(int &nMin,int &nMax,int *pnCalculated,int *pnType)
{
	if(m_bIterChanged || pnCalculated){
		int nMA = (m_nMaxApproximation==m_nMaxIter?0:m_nMaxApproximation);
		int nCalc1=0;
		int nCalc2=0;
		if(pnType)
			*pnType=0;
		if(m_nPixels){
			int x, y;
			nMax=-1;
			nMin=-1;
			for(x=0;x<m_nX;x++){
				for(y=0;y<m_nY;y++){
					if(m_nPixels[x][y]!=-1 && (nMin==-1 || nMin>m_nPixels[x][y]))
						nMin=m_nPixels[x][y];
					if(m_nPixels[x][y]!=-1 && (nMax==-1 || nMax<m_nPixels[x][y]))
						nMax=m_nPixels[x][y];
					if(pnCalculated && m_nPixels[x][y]!=-1){
						nCalc1+=m_nPixels[x][y]-nMA;
						if(nCalc1>1000000){
							nCalc2+=nCalc1/1000000;
							nCalc1%=1000000;
						}
					}
				}
			}
		}
		m_bIterChanged=FALSE;
		m_nMinI = nMin;
		m_nMaxI = nMax;
		if(pnCalculated){
			if(nCalc2>2000){
				if(pnType)
					*pnType=1;
				*pnCalculated=nCalc2;
			}
			else{
				*pnCalculated=nCalc2*1000000+nCalc1;
			}
		}
	}
	else{
		nMin = m_nMinI;
		nMax = m_nMaxI;
	}
}
int CFraktalSFT::GetIterations()
{
	return m_nMaxIter;
}
void CFraktalSFT::SetIterations(int nIterations)
{
	m_nMaxIter = nIterations;
}
char *CFraktalSFT::GetRe()
{
	CFixedFloat re = (m_rstop+m_rstart)/2;
	CStringTable stRet;
	if(m_szPosition)
		stRet.DeleteToText(m_szPosition);
	stRet.AddRow();
	stRet.AddString(stRet.GetCount()-1,re.ToText());
	m_szPosition = stRet.ToText("","");
	return m_szPosition;
}
char *CFraktalSFT::GetIm()
{
	CFixedFloat im = (m_istop+m_istart)/2;
	CStringTable stRet;
	if(m_szPosition)
		stRet.DeleteToText(m_szPosition);
	stRet.AddRow();
	stRet.AddString(stRet.GetCount()-1,im.ToText());
	m_szPosition = stRet.ToText("","");
	return m_szPosition;
}
char *CFraktalSFT::GetZoom()
{
	CDecNumber zoom = (CDecNumber)4/((CDecNumber)m_istop.ToText()-(CDecNumber)m_istart.ToText());
	CStringTable stRet;
	if(m_szPosition)
		stRet.DeleteToText(m_szPosition);
	stRet.AddRow();
	stRet.AddString(stRet.GetCount()-1,zoom.ToText());
	m_szPosition = stRet.ToText("","");
	char *e = strstr(m_szPosition,"e");
	char szNum[20];
	if(!e)
		e = strstr(m_szPosition,"E");
	if(!e){
		char *szP = strstr(m_szPosition,".");
		if(szP)
			*szP=0;
		int exp = strlen(m_szPosition)-1;
		if(exp>2){
			int end = 12;
			if(end>exp)
				end=exp;
			m_szPosition[end+1]=0;
			while(end>1){
				m_szPosition[end]=m_szPosition[end-1];
				end--;
			}
			m_szPosition[end]='.';
			stRet.SetString(0,0,m_szPosition);
			wsprintf(szNum,"E%d",exp);
			stRet.AppendString(0,0,szNum);
			stRet.DeleteToText(m_szPosition);
			m_szPosition = stRet.ToText("","");
		}

	}
	else{
		m_szPosition[12]=0;
		stRet.SetString(0,0,m_szPosition);
		stRet.AppendString(0,0,e);
	}
	return m_szPosition;
}
BOOL CFraktalSFT::HighestIteration(int &rx, int &ry)
{
	if(!m_nPixels)
		return FALSE;
	int x, y;
	int nMax=-1;
	for(x=0;x<m_nX;x++)
		for(y=0;y<m_nY;y++)
			if(m_nPixels[x][y]!=-1 && m_nPixels[x][y]>nMax){
				nMax = m_nPixels[x][y];
				rx=x;
				ry=y;
			}
	return TRUE;
}
BOOL CFraktalSFT::Center(int &rx, int &ry,BOOL bSkipM,BOOL bQuick)
{
	if(!m_nPixels)
		return FALSE;
	int x, y;
	int nSegmentX = m_nX/4;
	int nSegmentY = m_nY/4;
	int nHalfX = m_nX/2;
	int nHalfY = m_nY/2;
	int tx, ty;
	double val, minval=0;
	BOOL bFirst=TRUE;
	int nStep = (bQuick?6:4)*m_nX*m_nX/(640*640);
	if(nStep==0)
		nStep=1;
	
	double nAvgIter=0;
	int nAvgDiv=0;
	for(x=0;x<m_nX;x+=nStep)
		for(y=0;y<m_nY;y+=nStep){
			if(bSkipM && x>nHalfX-nSegmentX/3 && x<nHalfX+nSegmentX/3)
				continue;
			nAvgIter+=m_nPixels[x][y];
			nAvgDiv++;
		}
	int nMinIter=(int)(2*(nAvgIter/nAvgDiv)/3);
	if(bSkipM)
		nMinIter = (int)(nAvgIter/nAvgDiv);

	for(tx=nSegmentX;tx<nHalfX+nSegmentX;tx++){
		if(bSkipM && tx>nHalfX-nSegmentX/3 && tx<nHalfX+nSegmentX/3)
			continue;
		for(ty=nSegmentY;ty<nHalfY+nSegmentY;ty++){
			if(nMinIter>m_nPixels[tx][ty])
				continue;
			val=0;
			for(x=0;x<nSegmentX;x+=nStep){
				for(y=0;y<nSegmentY;y+=nStep){
					int x1 = tx-x;
					int x2 = tx+x;
					int y1 = ty-y;
					int y2 = ty+y;
					int t = m_nPixels[x1][y1]-m_nPixels[x2][y2];
					val+=(t<0?-t:t);
					x1 = tx-x;
					x2 = tx+x;
					y1 = ty+y;
					y2 = ty-y;
					int tt = m_nPixels[x1][y1]-m_nPixels[x2][y2];
					val+=(tt<0?-tt:tt);
				}
			}
			if(bFirst || minval>val){
				rx=tx;
				ry=ty;
				minval=val;
				bFirst=FALSE;
			}
		}
	}
	if(minval==0)
		return FALSE;
	return TRUE;
}
void CFraktalSFT::ReuseReference(BOOL bReuse)
{
	m_bReuseRef=bReuse;
}

COLOR14 CFraktalSFT::GetKeyColor(int i)
{
	if(i<0 || i>=m_nParts)
		return m_cKeys[0];
	else
		return m_cKeys[i];
}
void CFraktalSFT::SetKeyColor(COLOR14 col,int i)
{
	if(i<0 || i>=m_nParts)
		return;
	m_cKeys[i] = col;
}
COLOR14 CFraktalSFT::GetColor(int i)
{
	if(i<0 || i>=1024)
		return m_cPos[0];
	else
		return m_cPos[i];
}
BOOL CFraktalSFT::OpenFile(char *szFile)
{
	DWORD dw;
	HANDLE hFile = CreateFile(szFile,GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
	if(hFile==INVALID_HANDLE_VALUE)
		return FALSE;
	int nData = GetFileSize(hFile,NULL);
	char *szData = new char[nData+1];
	ReadFile(hFile,szData,nData,&dw,NULL);
	CloseHandle(hFile);
	szData[nData]=0;
	CStringTable stParams(szData,": ","\r\n");
	delete [] szData;
	int nR = stParams.FindString(0,"Re");
	if(nR==-1)
		return FALSE;
	int nI = stParams.FindString(0,"Im");
	if(nI==-1)
		return FALSE;
	int nZ = stParams.FindString(0,"Zoom");
	if(nZ==-1)
		return FALSE;
	int nC = stParams.FindString(0,"Colors");
	if(nC==-1)
		return FALSE;
	int nIterations = stParams.FindString(0,"Iterations");
	if(nIterations==-1)
		return FALSE;
	int nID = stParams.FindString(0,"IterDiv");
	if(nID==-1)
		m_nIterDiv=1;
	else
		m_nIterDiv = atof(stParams[nID][1]);
	int nT = stParams.FindString(0,"Smooth");
	if(nT!=-1)
		m_bTrans = atoi(stParams[nT][1]);
	nID = stParams.FindString(0,"SmoothMethod");
	if(nID!=-1){
		m_nSmoothMethod = atoi(stParams[nID][1]);
		if(m_nSmoothMethod<0 || m_nSmoothMethod>1)
			m_nSmoothMethod=0;
	}
	m_nBailout = m_nSmoothMethod==1?2:SMOOTH_BAILOUT;
	m_nBailout2 = m_nBailout*m_nBailout;

	nID = stParams.FindString(0,"ColorMethod");
	if(nID!=-1){
		m_nColorMethod = atoi(stParams[nID][1]);
		if(m_nColorMethod<0 || m_nColorMethod>4)
			m_nColorMethod=0;
	}
	nID = stParams.FindString(0,"ColorOffset");
	if(nID!=-1){
		m_nColorOffset = atoi(stParams[nID][1]);
		if(m_nColorOffset<0 || m_nColorOffset>1023)
			m_nColorOffset=0;
	}
	nID = stParams.FindString(0,"Power");
	if(nID!=-1){
		m_nPower = atoi(stParams[nID][1]);
		if(m_nPower!=2 && m_nPower!=3)
			m_nPower=2;
		if(g_nLDBL>100){
			if(m_nPower==3)
				g_nLDBL=400;
			else
				g_nLDBL=600;
		}
	}

	SetPosition(stParams[nR][1],stParams[nI][1],stParams[nZ][1]);
	CStringTable stColors(stParams[nC][1],"",",");
	m_nParts = stColors.GetCount()/3;
	int i;
	for(i=0;i<m_nParts;i++){
		m_cKeys[i].r = atoi(stColors[i*3][0]);
		m_cKeys[i].g = atoi(stColors[i*3+1][0]);
		m_cKeys[i].b = atoi(stColors[i*3+2][0]);
	}
	i = stParams.FindString(0,"MultiColor");
	if(i!=-1){
		m_bMW = atoi(stParams[i][1]);
		m_nMW = 0;
		i = stParams.FindString(0,"MultiColors");
		if(i!=-1){
			stColors.Reset();
			stColors.SplitString(stParams[i][1],"\t",",");
			for(i=0;i<stColors.GetCount() && m_nMW<MULTIWAVE_MAX;i++){
				m_MW[m_nMW].nPeriod = atoi(stColors[i][0]);
				m_MW[m_nMW].nStart = atoi(stColors[i][1]);
				m_MW[m_nMW].nType = atoi(stColors[i][2]);
				m_nMW++;
			}
		}
	}
	ApplyColors();
	m_nMaxIter = atoi(stParams[nIterations][1]);
	return TRUE;
}
BOOL CFraktalSFT::OpenMapB(char *szFile,BOOL bReuseCenter,double nZoomSize)
{
	int **Org;
	float **OrgT;
	int nOX, nOY;
	int i;
	int x, y, a, b;
	if(bReuseCenter && nZoomSize<1){
		int i;
		nOX = m_nX*nZoomSize;
		nOY = m_nY*nZoomSize;
		Org = new int*[nOX];
		for(i=0;i<nOX;i++)
			Org[i] = new int[nOY];
		OrgT = new float*[nOX];
		for(i=0;i<nOX;i++)
			OrgT[i] = new float[nOY];
		for(x=0;x<nOX;x++){
			for(y=0;y<nOY;y++){
				a = x/nZoomSize;
				b = y/nZoomSize;
				if(a>=0 && a<m_nX && b>=0 && b<m_nY)
					Org[x][y]=m_nPixels[a][b];
				if(a>=0 && a<m_nX && b>=0 && b<m_nY)
					OrgT[x][y]=m_nTrans[a][b];
			}
		}
		a = (m_nX-nOX)/2;
		b = (m_nY-nOY)/2;
	}
	//HANDLE hFile = CreateFile(szFile,GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
	FILE *hFile = fopen(szFile,"rb");
	//if(hFile==INVALID_HANDLE_VALUE)
	if(hFile==NULL)
		return FALSE;
	DWORD dw;
	char szId[3];
	//ReadFile(hFile,szId,3,&dw,NULL);
	fread(szId,1,3,hFile);
	BOOL bNewFormat=FALSE;
	if(!strncmp(szId,"KFC",3))
		bNewFormat=1;
	if(!strncmp(szId,"KFD",3))
		bNewFormat=2;
	else if(strncmp(szId,"KFB",3)){
		//CloseHandle(hFile);
		fclose(hFile);
		return NULL;
	}
	//ReadFile(hFile,&m_nX,sizeof(int),&dw,NULL);
	//ReadFile(hFile,&m_nY,sizeof(int),&dw,NULL);
	fread(&m_nX,1,sizeof(int),hFile);
	fread(&m_nY,1,sizeof(int),hFile);
	if(m_nPixels){
		int i;
		for(i=0;i<m_nXPrev;i++)
			delete [] m_nPixels[i];
		delete [] m_nPixels;

		for(i=0;i<m_nXPrev;i++)
			delete [] m_nTrans[i];
		delete [] m_nTrans;
	}
	m_nXPrev = m_nX;
	m_nYPrev = m_nY;
	m_nPixels = new int*[m_nX];
	m_nTrans =  new float*[m_nX];
	float *pLine=NULL;
	if(bNewFormat==1)
		pLine = new float[m_nY];
	else if(bNewFormat==2)
		pLine = new float[m_nX];
	if(bNewFormat==2){
		for(y=0;y<m_nY;y++){
			//ReadFile(hFile,pLine,sizeof(float)*m_nX,&dw,NULL);
			fread(pLine,1,sizeof(float)*m_nX,hFile);
			for(x=0;x<m_nX;x++){
				if(y==0){
					m_nTrans[x] = new float[m_nY];
					m_nPixels[x] = new int[m_nY];
				}
				m_nPixels[x][y] = (int)pLine[x];
				m_nTrans[x][y] = pLine[x] - (int)m_nPixels[x][y];
			}
		}
	}
	else{
		for(x=0;x<m_nX;x++){
			m_nPixels[x] = new int[m_nY];
			if(bNewFormat){
				m_nTrans[x] = new float[m_nY];
				//ReadFile(hFile,pLine,sizeof(float)*m_nY,&dw,NULL);
				fread(pLine,1,sizeof(float)*m_nY,hFile);
				for(y=0;y<m_nY;y++){
					m_nPixels[x][y] = (int)pLine[y];
					m_nTrans[x][y] = pLine[y] - (int)m_nPixels[x][y];
				}
			}
			else
				//ReadFile(hFile,m_nPixels[x],sizeof(int)*m_nY,&dw,NULL);
				fread(m_nPixels[x],1,sizeof(float)*m_nY,hFile);
		}
	}
	if(pLine)
		delete [] pLine;
	//ReadFile(hFile,&m_nIterDiv,sizeof(int),&dw,NULL);
	int div=1;
	fread(&div,1,sizeof(int),hFile);
	m_nIterDiv = div;
	//ReadFile(hFile,&m_nParts,sizeof(int),&dw,NULL);
	fread(&m_nParts,1,sizeof(int),hFile);
	//ReadFile(hFile,m_cKeys,sizeof(COLOR14)*m_nParts,&dw,NULL);
	fread(m_cKeys,1,sizeof(COLOR14)*m_nParts,hFile);
	int nTest;
	//ReadFile(hFile,&nTest,sizeof(int),&dw,NULL);
	dw = fread(&nTest,1,sizeof(int),hFile);
	if(sizeof(int)==dw)
		m_nMaxIter = nTest;

	if(!bNewFormat){
		for(x=0;x<m_nX;x++){
			m_nTrans[x] = new float[m_nY];
			memset(m_nTrans[x],0,sizeof(float)*m_nY);
			//ReadFile(hFile,m_nTrans[x],sizeof(float)*m_nY,&dw,NULL);
			fread(m_nTrans[x],1,sizeof(float)*m_nY,hFile);
		}
	}
	//CloseHandle(hFile);
	fclose(hFile);

	if(bReuseCenter && nZoomSize<1){
		for(x=0;x<m_nX;x++){
			for(y=0;y<m_nY;y++){
				if(x-a>0 && x-a<nOX-1 && y-b>0 && y-b<nOY-1){
					m_nPixels[x][y]=Org[x-a][y-b];
					m_nTrans[x][y]=OrgT[x-a][y-b];
				}
			}
		}
		for(i=0;i<nOX;i++){
			delete [] Org[i];
			delete [] OrgT[i];
		}
		delete [] Org;
		delete [] OrgT;
	}
	if(m_bmBmp)
		DeleteObject(m_bmBmp);
	HDC hDC = GetDC(NULL);
	m_bmBmp = CreateCompatibleBitmap(hDC,m_nX,m_nY);
	if(m_bmi)
		free(m_bmi);
	m_bmi = (BITMAPINFOHEADER *)malloc(sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*256);
	memset(m_bmi,0,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*256);
	m_bmi->biSize = sizeof(BITMAPINFOHEADER);
	if(!GetDIBits(hDC,m_bmBmp,0,0,NULL,(LPBITMAPINFO)m_bmi,DIB_RGB_COLORS))
		/*Beep(1000,10)*/;
	ReleaseDC(NULL,hDC);
	m_bmi->biCompression=m_bmi->biClrUsed=m_bmi->biClrImportant=0;
	m_bmi->biBitCount = 24;
	if(m_bmi->biBitCount!=24)
		m_bmi->biClrUsed = 1<<m_bmi->biBitCount;
	m_row = ((((m_bmi->biWidth*(DWORD)m_bmi->biBitCount)+31)&~31) >> 3);
	m_bmi->biSizeImage=m_row*m_bmi->biHeight;

	if(!m_lpBits || (int)m_bmi->biSizeImage!=m_nSizeImage){
		m_nSizeImage=m_bmi->biSizeImage;
		if(m_lpBits)
			delete [] m_lpBits;
		m_lpBits = new BYTE[m_bmi->biSizeImage];

		if(!GetDIBits(hDC,m_bmBmp,0,m_bmi->biHeight,m_lpBits,
				(LPBITMAPINFO)m_bmi,DIB_RGB_COLORS))
			/*Beep(1000,10)*/;
	}
	return TRUE;
}
BOOL CFraktalSFT::SaveFile(char *szFile)
{
	CStringTable stSave;
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"Re");
	stSave.AddString(stSave.GetCount()-1,GetRe());
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"Im");
	stSave.AddString(stSave.GetCount()-1,GetIm());
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"Zoom");
	stSave.AddString(stSave.GetCount()-1,GetZoom());
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"Iterations");
	stSave.AddInt(stSave.GetCount()-1,m_nMaxIter);
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"IterDiv");
	char szDiv[256];
	sprintf(szDiv,"%f",m_nIterDiv);
	stSave.AddString(stSave.GetCount()-1,szDiv);
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"SmoothMethod");
	stSave.AddInt(stSave.GetCount()-1,m_nSmoothMethod);
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"ColorMethod");
	stSave.AddInt(stSave.GetCount()-1,m_nColorMethod);
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"ColorOffset");
	stSave.AddInt(stSave.GetCount()-1,m_nColorOffset);
	
	CStringTable stColors;
	int i;
	for(i=0;i<m_nParts;i++){
		stColors.AddRow();
		stColors.AddInt(stColors.GetCount()-1,m_cKeys[i].r);
		stColors.AddRow();
		stColors.AddInt(stColors.GetCount()-1,m_cKeys[i].g);
		stColors.AddRow();
		stColors.AddInt(stColors.GetCount()-1,m_cKeys[i].b);
	}
	char *szColors = stColors.ToText("",",");
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"Colors");
	stSave.AddString(stSave.GetCount()-1,szColors);
	stColors.DeleteToText(szColors);
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"Smooth");
	stSave.AddInt(stSave.GetCount()-1,m_bTrans);

	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"MultiColor");
	stSave.AddInt(stSave.GetCount()-1,m_bMW);
	stColors.Reset();
	for(i=0;i<m_nMW;i++){
		stColors.AddRow();
		stColors.AddInt(stColors.GetCount()-1,m_MW[i].nPeriod);
		stColors.AddInt(stColors.GetCount()-1,m_MW[i].nStart);
		stColors.AddInt(stColors.GetCount()-1,m_MW[i].nType);
	}
	szColors = stColors.ToText("\t",",");
	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"MultiColors");
	stSave.AddString(stSave.GetCount()-1,szColors);
	stColors.DeleteToText(szColors);

	stSave.AddRow();
	stSave.AddString(stSave.GetCount()-1,"Power");
	stSave.AddInt(stSave.GetCount()-1,m_nPower);

	DWORD dw;
	HANDLE hFile = CreateFile(szFile,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,0,NULL);
	if(hFile==INVALID_HANDLE_VALUE)
		return FALSE;
	char *szData = stSave.ToText(": ","\r\n");
	WriteFile(hFile,szData,strlen(szData),&dw,NULL);
	stSave.DeleteToText(szData);
	CloseHandle(hFile);
	return TRUE;
}
double CFraktalSFT::GetIterDiv()
{
	return m_nIterDiv;
}
void CFraktalSFT::SetIterDiv(double nIterDiv)
{
	if(nIterDiv>0)
		m_nIterDiv = nIterDiv;
}

int SaveJpg(char *szFileName,HBITMAP bmBmp,int nQuality);

int CFraktalSFT::SaveJpg(char *szFile,int nQuality,int nWidth, int nHeight)
{
	if(nWidth==0)
		nWidth=m_nX;
	if(nHeight==0)
		nHeight=m_nY;
	if(m_nX==nWidth && m_nY==nHeight)
		return ::SaveJpg(szFile,m_bmBmp,nQuality);
	else{
		HDC hDC = GetDC(NULL);
		HDC dcBmp = CreateCompatibleDC(hDC);
		HBITMAP bmOldBmp = (HBITMAP)SelectObject(dcBmp,m_bmBmp);
		HDC dcSave = CreateCompatibleDC(hDC);
		HBITMAP bmSave = CreateCompatibleBitmap(hDC,nWidth,nHeight);
		HBITMAP bmOldSave = (HBITMAP)SelectObject(dcSave,bmSave);
		SetStretchBltMode(dcSave,HALFTONE);
		StretchBlt(dcSave,0,0,nWidth,nHeight,dcBmp,0,0,m_nX,m_nY,SRCCOPY);
		SelectObject(dcBmp,bmOldBmp);
		SelectObject(dcSave,bmOldSave);
		DeleteDC(dcBmp);
		DeleteDC(dcSave);
		int nRet = ::SaveJpg(szFile,bmSave,nQuality);
		DeleteObject(bmSave);
		ReleaseDC(NULL,hDC);
		return nRet;
	}
}
int CFraktalSFT::GetMaxApproximation()
{
	return m_nMaxApproximation;
}
int CFraktalSFT::GetIterationOnPoint(int x, int y)
{
	WaitForSingleObject(m_hMutex,INFINITE);
	if(!m_nPixels || m_nXPrev!=m_nX || m_nYPrev!=m_nY){
		ReleaseMutex(m_hMutex);
		return -1;
	}
	if(x<0 || x>=m_nX || y<0 || y>=m_nY){
		ReleaseMutex(m_hMutex);
		return -1;
	}
	int nRet = m_nPixels[x][y];
 	ReleaseMutex(m_hMutex);
	return nRet;
}
int CFraktalSFT::GetTransOnPoint(int x, int y)
{
	if(x<0 || x>=m_nX || y<0 || y>=m_nY || !m_nTrans){
		return 0;
	}
	return (int)(SMOOTH_TOLERANCE*m_nTrans[x][y]);
}
BOOL IsEqual(int a, int b,int nSpan=2,BOOL bGreaterThan=FALSE)
{
//	return a==b;
	if(a==-1 || b==-1)
		return 0;
	if(bGreaterThan)
		return a>nSpan;
	int diff = a-b;
	if(diff<0)
		diff=-diff;
	return diff<nSpan;
}
BOOL CFraktalSFT::AddReference(int nXPos, int nYPos,BOOL bEraseAll,BOOL bNP,BOOL bNoGlitchDetection)
{
	if(!m_nPixels || (m_nZoom<g_nRefZero && !bEraseAll))
		return FALSE;
	m_bNoGlitchDetection = bNoGlitchDetection;
	int **Pixels = m_nPixels;
	if(m_nZoom>=g_nRefZero){
		m_rref = (CFixedFloat)nXPos*(m_rstop-m_rstart)/(CFixedFloat)m_nX + m_rstart;
		m_iref = (CFixedFloat)nYPos*(m_istop-m_istart)/(CFixedFloat)m_nY + m_istart;
	}
	else{
		m_rref=0;
		m_iref=0;
	}
	int x, y;
	int i = Pixels[nXPos][nYPos];

	int nCount=0;
	if(bEraseAll){
		for(x=0;x<m_nX;x++)
			for(y=0;y<m_nY;y++)
				m_nPixels[x][y]=-1;
	}
	else if(bNP){
		int **Node = new int*[m_nX];
		for(i=0;i<m_nX;i++)
			Node[i] = new int[m_nY];
		for(x=0;x<m_nX;x++)
			for(y=0;y<m_nY;y++)
				Node[x][y]=m_nPixels[x][y];
		GetArea(Node,nXPos,nYPos,2,NULL,-1);
		for(x=0;x<m_nX;x++)
			for(y=0;y<m_nY;y++)
				if(Node[x][y]==-1)
					m_nPixels[x][y]=-1;
	}
	else{
		int t = SMOOTH_TOLERANCE*m_nTrans[nXPos][nYPos];
		for(x=0;x<m_nX;x++){
			for(y=0;y<m_nY;y++){
				if(IsEqual(i,Pixels[x][y],4) && IsEqual(t,(int)(SMOOTH_TOLERANCE*m_nTrans[x][y]),4)){
					m_nPixels[x][y]=-1;
					nCount++;
				}
			}
		}
	}

	BOOL bPrevReuseRef=m_bReuseRef;
	m_bAddReference=TRUE;
	RenderFractal(m_nX,m_nY,m_nMaxIter,m_hWnd,FALSE,FALSE);
	return TRUE;
}
#define SMOOTH_TO 7
int CFraktalSFT::GetArea(int **Node, int nXStart,int nYStart,int nEqSpan,int **Pixels,int nDone)
{
	int x, y;
	int nAreaC=0;
	int nTarget = m_nPixels[nXStart][nYStart];

	int nQSize = m_nX*m_nY;
	POINT *pQ = new POINT[nQSize];
	nQSize--;
	int nQ=1;
	pQ[nQ-1].x = nXStart;
	pQ[nQ-1].y = nYStart;
	int nValidate = nQSize*2;
	while(nQ && nValidate){
		x = pQ[nQ-1].x;
		y = pQ[nQ-1].y;
		nQ--;
		nValidate--;
		if(IsEqual(Node[x][y],nTarget,nEqSpan,Pixels?TRUE:FALSE) && nQ<nQSize){
			nAreaC++;
			Node[x][y]=nDone;
			if(Pixels)
				Pixels[x][y]=-1;
			int w=x, e=x;
			while(nValidate && w && IsEqual(Node[w-1][y],nTarget,nEqSpan,Pixels?TRUE:FALSE)){
				nAreaC++;
				nValidate--;
				w--;
				Node[w][y]=nDone;
				if(Pixels)
					Pixels[w][y]=-1;
				if(y && 
					IsEqual(Node[w][y-1],nTarget,nEqSpan,Pixels?TRUE:FALSE) 
					&& nQ<nQSize-1){
					nQ++;
					pQ[nQ-1].x = w;
					pQ[nQ-1].y = y-1;
				}
				if(y<m_nY-1 && 
					IsEqual(Node[w][y+1],nTarget,nEqSpan,Pixels?TRUE:FALSE) 
					&& nQ<nQSize-1){
					nQ++;
					pQ[nQ-1].x = w;
					pQ[nQ-1].y = y+1;
				}
			}
			while(nValidate && e<m_nX-1 && IsEqual(Node[e+1][y],nTarget,nEqSpan,Pixels?TRUE:FALSE)){
				nAreaC++;
				nValidate--;
				e++;
				Node[e][y]=nDone;
				if(Pixels)
					Pixels[e][y]=-1;
				if(y && 
					IsEqual(Node[e][y-1],nTarget,nEqSpan,Pixels?TRUE:FALSE) 
					&& nQ<nQSize-1){
					nQ++;
					pQ[nQ-1].x = e;
					pQ[nQ-1].y = y-1;
				}
				if(y<m_nY-1 && 
					IsEqual(Node[e][y+1],nTarget,nEqSpan,Pixels?TRUE:FALSE) 
					&& nQ<nQSize-1){
					nQ++;
					pQ[nQ-1].x = e;
					pQ[nQ-1].y = y+1;
				}
			}
			w=y; 
			e=y;
			while(nValidate && w && IsEqual(Node[x][w-1],nTarget,nEqSpan,Pixels?TRUE:FALSE)){
				nAreaC++;
				nValidate--;
				w--;
				Node[x][w]=nDone;
				if(Pixels)
					Pixels[x][w]=-1;
				if(x && 
					IsEqual(Node[x-1][w],nTarget,nEqSpan,Pixels?TRUE:FALSE) 
					&& nQ<nQSize-1){
					nQ++;
					pQ[nQ-1].x = x-1;
					pQ[nQ-1].y = w;
				}
				if(x<m_nX-1 && 
					IsEqual(Node[x+1][w],nTarget,nEqSpan,Pixels?TRUE:FALSE) 
					&& nQ<nQSize-1){
					nQ++;
					pQ[nQ-1].x = x+1;
					pQ[nQ-1].y = w;
				}
			}
			while(nValidate && e<m_nY-1 && IsEqual(Node[x][e+1],nTarget,nEqSpan,Pixels?TRUE:FALSE)){
				nAreaC++;
				nValidate--;
				e++;
				Node[x][e]=nDone;
				if(Pixels)
					Pixels[x][e]=-1;
				if(x && 
					IsEqual(Node[x-1][e],nTarget,nEqSpan,Pixels?TRUE:FALSE) 
					&& nQ<nQSize-1){
					nQ++;
					pQ[nQ-1].x = x-1;
					pQ[nQ-1].y = e;
				}
				if(x<m_nX-1 && 
					IsEqual(Node[x+1][e],nTarget,nEqSpan,Pixels?TRUE:FALSE) 
					&& nQ<nQSize-1){
					nQ++;
					pQ[nQ-1].x = x+1;
					pQ[nQ-1].y = e;
				}
			}
		}
	}
	delete [] pQ;
	return nAreaC;
}
BOOL CFraktalSFT::FindCenterOfGlitch(int &ret_x, int &ret_y,BOOL bNP)
{
	int x, y, i=0, io;
	int rx, ry;

	int **Pixels = m_nPixels;
	int **Node = new int*[m_nX];
	for(i=0;i<m_nX;i++)
		Node[i] = new int[m_nY];
	for(x=0;x<m_nX;x++)
		for(y=0;y<m_nY;y++)
			Node[x][y]=Pixels[x][y];

	int nDistance=-1;
	for(x=1;x<m_nX-1;x++){
		for(y=1;y<m_nY-1;y++){
			int nDone = - (x*m_nY+y);
			if(Node[x][y]>0 && m_nTrans[x][y]==2){
				int nMatch=1;
				if(Pixels[x][y]==Pixels[x][y-1])nMatch++;
				if(Pixels[x][y]==Pixels[x][y+1])nMatch++;
				if(Pixels[x][y]==Pixels[x-1][y])nMatch++;
				if(Pixels[x][y]==Pixels[x+1][y])nMatch++;
				if(Pixels[x][y]==Pixels[x-1][y-1])nMatch++;
				if(Pixels[x][y]==Pixels[x+1][y-1])nMatch++;
				if(Pixels[x][y]==Pixels[x-1][y+1])nMatch++;
				if(Pixels[x][y]==Pixels[x+1][y+1])nMatch++;
				if(nMatch==1){
					m_nTrans[x][y]=m_nTrans[x-1][y];
					m_nPixels[x][y]=m_nPixels[x-1][y];
					continue;
				}
				int nDist = GetArea(Node,x,y,2,NULL,nDone);
				for(io=0;io<OLD_GLITCH;io++)
					if(m_pOldGlitch[io].x==-1 || (m_pOldGlitch[io].x==x && m_pOldGlitch[io].y==y))
						break;
				if(io<OLD_GLITCH && m_pOldGlitch[io].x!=-1 && nDist<50){
					continue;
				}
				if(nDistance<nDist){
					nDistance=nDist;
					rx=x;
					ry=y;
				}
			}
		}
	}

	if(nDistance!=-1){
		for(io=0;io<OLD_GLITCH;io++){
			if(m_pOldGlitch[io].x==-1)
				break;
		}
		if(io<OLD_GLITCH){
			m_pOldGlitch[io].x=rx;
			m_pOldGlitch[io].y=ry;
		}
		ret_x=rx;
		ret_y=ry;
		int nMaxDist=0;
		if(io%2==0 && io>3){
			for(x=1;x<m_nX-1;x++){
				for(y=1;y<m_nY-1;y++){
					if(Node[x][y]!=Node[ret_x][ret_y])
						continue;
					int tm=m_nX*m_nY, to;
					for(to=0;x-to>=0 && Node[x-to][y]==Node[ret_x][ret_y];to++);
					if(tm>to)
						tm=to;
					for(to=0;x+to<m_nX && Node[x+to][y]==Node[ret_x][ret_y];to++);
					if(tm>to)
						tm=to;
					for(to=0;y-to>=0 && Node[x][y-to]==Node[ret_x][ret_y];to++);
					if(tm>to)
						tm=to;
					for(to=0;y+to<m_nY && Node[x][y+to]==Node[ret_x][ret_y];to++);
					if(tm>to)
						tm=to;
					for(to=0;x-to>=0 && y-to>=0 && Node[x-to][y-to]==Node[ret_x][ret_y];to++);
					if(tm>to)
						tm=to;
					for(to=0;x+to<m_nX && y+to<m_nY && Node[x+to][y+to]==Node[ret_x][ret_y];to++);
					if(tm>to)
						tm=to;
					for(to=0;x-to>=0 && y+to<m_nY && Node[x-to][y+to]==Node[ret_x][ret_y];to++);
					if(tm>to)
						tm=to;
					for(to=0;x+to<m_nX && y-to>=0 && Node[x+to][y-to]==Node[ret_x][ret_y];to++);
					if(tm>to)
						tm=to;
					if(nMaxDist<tm){
						nMaxDist=tm;
						rx=x;
						ry=y;
					}
				}
			}
			ret_x=rx;
			ret_y=ry;
		}
		else{
			for(x=1;x<m_nX-1;x++){
				for(y=1;y<m_nY-1;y++){
					if(Node[x][y]!=Node[ret_x][ret_y])
						continue;
					int t=0, to, c, ct;
					ct=c=0;
					for(to=0;x-to>=0 && Node[x-to][y]==Node[ret_x][ret_y];to++){
						t++;
						ct++;
					}
					for(to=0;x+to<m_nX && Node[x+to][y]==Node[ret_x][ret_y];to++){
						t++;
						ct--;
					}
					c+=(ct<0?-ct:ct);
					ct=0;
					for(to=0;y-to>=0 && Node[x][y-to]==Node[ret_x][ret_y];to++){
						t++;
						ct++;
					}
					for(to=0;y+to<m_nY && Node[x][y+to]==Node[ret_x][ret_y];to++){
						t++;
						ct--;
					}

					c+=(ct<0?-ct:ct);
					ct=0;
					for(to=0;x-to>=0 && y-to>=0 && Node[x-to][y-to]==Node[ret_x][ret_y];to++){
						t++;
						ct++;
					}
					for(to=0;x+to<m_nX && y+to<m_nY && Node[x+to][y+to]==Node[ret_x][ret_y];to++){
						t++;
						ct--;
					}
					c+=(ct<0?-ct:ct);
					ct=0;
					for(to=0;x-to>=0 && y+to<m_nY && Node[x-to][y+to]==Node[ret_x][ret_y];to++){
						t++;
						ct++;
					}
					for(to=0;x+to<m_nX && y-to>=0 && Node[x+to][y-to]==Node[ret_x][ret_y];to++){
						t++;
						ct--;
					}
					c+=(ct<0?-ct:ct);

					t-=c;

					if(nMaxDist<t){
						nMaxDist=t;
						rx=x;
						ry=y;
					}
				}
			}
			ret_x=rx;
			ret_y=ry;
		}
	}

	for(i=0;i<m_nX;i++)
		delete [] Node[i];
	delete [] Node;
	if(nDistance==-1)
		return FALSE;

	if(io<2 && Center(rx,ry,FALSE,TRUE) && Pixels[ret_x][ret_y]==Pixels[rx][ry] && Pixels[rx][ry]!=m_nMaxIter){
		for(io=0;io<OLD_GLITCH;io++)
			if(m_pOldGlitch[io].x==-1 || (m_pOldGlitch[io].x==rx && m_pOldGlitch[io].y==ry))
				break;
		if(io<OLD_GLITCH && m_pOldGlitch[io].x==-1){
			ret_x=rx;
			ret_y=ry;
			io--;
			m_pOldGlitch[io].x=rx;
			m_pOldGlitch[io].y=ry;
		}
	}
	return TRUE;
}
BOOL CFraktalSFT::GetNoApproximation()
{
	return m_bNoApproximation;
}
void CFraktalSFT::SetNoApproximation(BOOL bNoApproximation)
{
	m_bNoApproximation = bNoApproximation;
}
BOOL CFraktalSFT::GetTransition()
{
	return m_bTrans;
}
void CFraktalSFT::SetTransition(BOOL bTransition)
{
	m_bTrans = bTransition;
}
BOOL CFraktalSFT::GetITransition()
{
	return m_bITrans;
}
void CFraktalSFT::SetITransition(BOOL bITransition)
{
	m_bITrans = bITransition;
}

int CFraktalSFT::GetColorIndex(int x, int y)
{
	if(x<0 || x>=m_nX || y<0 || y>=m_nY || !m_nPixels)
		return -1;
	return ((int)(m_nPixels[x][y]/m_nIterDiv))%1024;
}
void CFraktalSFT::SaveMap(char *szFile)
{
	if(!m_nPixels)
		return;
	DWORD dw;
	HANDLE hFile = CreateFile(szFile,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,0,NULL);
	int x, y;
	char szNum[64];
	for(y=0;y<m_nY;y++){
		if(y)
			WriteFile(hFile,"\r\n",2,&dw,NULL);
		for(x=0;x<m_nX;x++){
			if(x)
				WriteFile(hFile," ",1,&dw,NULL);
			itoa(m_nPixels[x][y],szNum,10);
			WriteFile(hFile,szNum,strlen(szNum),&dw,NULL);
		}
	}
	char *szC = "\r\nColors: ";
	WriteFile(hFile,szC,strlen(szC),&dw,NULL);
	CStringTable stColors;
	int i;
	for(i=0;i<m_nParts;i++){
		stColors.AddRow();
		stColors.AddInt(stColors.GetCount()-1,m_cKeys[i].r);
		stColors.AddRow();
		stColors.AddInt(stColors.GetCount()-1,m_cKeys[i].g);
		stColors.AddRow();
		stColors.AddInt(stColors.GetCount()-1,m_cKeys[i].b);
	}
	szC = stColors.ToText("",",");
	WriteFile(hFile,szC,strlen(szC),&dw,NULL);
	stColors.DeleteToText(szC);
	CloseHandle(hFile);
}
void CFraktalSFT::SaveMapB(char *szFile)
{
	if(!m_nPixels)
		return;
	DWORD dw;
	HANDLE hFile = CreateFile(szFile,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,0,NULL);
	int x;
	WriteFile(hFile,"KFB",3,&dw,NULL);
	WriteFile(hFile,&m_nX,sizeof(m_nX),&dw,NULL);
	WriteFile(hFile,&m_nY,sizeof(m_nY),&dw,NULL);
	for(x=0;x<m_nX;x++)
		WriteFile(hFile,m_nPixels[x],m_nY*sizeof(int),&dw,NULL);
	int div = m_nIterDiv;
	WriteFile(hFile,&div,sizeof(m_nParts),&dw,NULL);
	WriteFile(hFile,&m_nParts,sizeof(m_nParts),&dw,NULL);
	WriteFile(hFile,m_cKeys,sizeof(COLOR14)*m_nParts,&dw,NULL);
	WriteFile(hFile,&m_nMaxIter,sizeof(int),&dw,NULL);
	for(x=0;x<m_nX;x++)
		WriteFile(hFile,m_nTrans[x],m_nY*sizeof(float),&dw,NULL);
	CloseHandle(hFile);
}

int CFraktalSFT::GetSmoothMethod()
{
	return m_nSmoothMethod;
}
void CFraktalSFT::SetSmoothMethod(int nSmoothMethod)
{
	if(nSmoothMethod==0){
		m_nSmoothMethod=0;
		m_nBailout = SMOOTH_BAILOUT;
		m_nBailout2 = m_nBailout*m_nBailout;
	}
	else if(nSmoothMethod==1){
		m_nSmoothMethod=1;
		m_nBailout = 2;
		m_nBailout2 = m_nBailout*m_nBailout;
	}
}
int CFraktalSFT::GetPower()
{
	return m_nPower;
}
void CFraktalSFT::SetPower(int nPower)
{
	m_nPower = nPower;
	if(g_nLDBL>100){
		if(m_nPower==3)
			g_nLDBL=400;
		else
			g_nLDBL=600;
	}
}

void CFraktalSFT::SetColorMethod(int nColorMethod)
{
	m_nColorMethod = nColorMethod;
}
int CFraktalSFT::GetColorMethod()
{
	return m_nColorMethod;
}
void CFraktalSFT::SetColorOffset(int nColorOffset)
{
	while(nColorOffset<0)
		nColorOffset+=1024;
	while(nColorOffset>=1024)
		nColorOffset-=1024;
	m_nColorOffset = nColorOffset;
}
int CFraktalSFT::GetColorOffset()
{
	return m_nColorOffset;
}
void CFraktalSFT::ErasePixel(int x, int y)
{
	if(x>=0 && y>=0 && x<m_nX && y<m_nY){
		m_nPixels[x][y]=1;
		m_nTrans[x][y]=0;
		int nIndex = x*3 + (m_bmi->biHeight-1-y)*m_row;
		SetColor(nIndex,m_nPixels[x][y],m_nTrans[x][y]);
		m_nPixels[x][y]=-1;
	}
}
void CFraktalSFT::StoreLocation()
{
	m_storedr = m_rref;
	m_storedi = m_iref;
}
void CFraktalSFT::SetMW(BOOL bMW)
{
	m_bMW = bMW;
}
int CFraktalSFT::GetMWCount()
{
	return m_nMW;
}
int CFraktalSFT::GetMW()
{
	return m_bMW;
}
BOOL CFraktalSFT::GetMW(int nIndex, int &nPeriod,int &nStart,int &nType)
{
	if(nIndex<0 || nIndex>=m_nMW)
		return FALSE;
	nPeriod = m_MW[nIndex].nPeriod;
	nStart = m_MW[nIndex].nStart;
	nType = m_MW[nIndex].nType;
	return TRUE;
}
BOOL CFraktalSFT::AddMW(int nPeriod,int nStart,int nType)
{
	if(m_nMW==MULTIWAVE_MAX-1)
		return FALSE;
	int i = m_nMW++;
	m_MW[i].nPeriod = nPeriod;
	m_MW[i].nStart = nStart;
	m_MW[i].nType = nType;
	return TRUE;
}
BOOL CFraktalSFT::UpdateMW(int nIndex, int nPeriod,int nStart,int nType)
{
	if(nIndex<0 || nIndex>=m_nMW)
		return FALSE;
	m_MW[nIndex].nPeriod = nPeriod;
	m_MW[nIndex].nStart = nStart;
	m_MW[nIndex].nType = nType;
	return TRUE;
}
BOOL CFraktalSFT::DeleteMW(int nIndex)
{
	int i;
	if(!m_nMW)
		return FALSE;
	m_nMW--;
	for(i=nIndex;i<m_nMW;i++)
		m_MW[i].nPeriod = m_MW[i+1].nPeriod;
	return TRUE;
}

CPixels::CPixels()
{
	m_pPixels=NULL;
	m_hMutex = CreateMutex(NULL,0,NULL);
}
void CPixels::Init(int nStep,int nX,int nY)
{
	m_nStep = nStep;
	m_nRectPos = -nStep;
	m_nRectPart = 3;
	m_nX = nX;
	m_nX2 = m_nX/2;
	m_nY = nY;
	m_nY2 = m_nY/2;
	m_rRect.left=m_rRect.right=m_nX/2;
	m_rRect.top=m_rRect.bottom=m_nY/2;
	m_nPixels = m_nX*m_nY;
	m_nNextPixel=-1;
	if(m_pPixels)
		delete [] m_pPixels;
	int *pnDone = new int[m_nPixels];
	memset(pnDone,-1,sizeof(int)*m_nPixels);
	m_pPixels = new POINT[m_nPixels];

	int i=0;
	int rx, ry;
	CStringTable st;
	st.BuildHash(0);
	while(i<m_nPixels){
		while(1){
			m_nRectPos+=m_nStep;
			if(m_nRectPart==0){
				rx=m_rRect.left+m_nRectPos;
				ry=m_rRect.top;
				if(rx==m_rRect.right){
					m_nRectPart++;
					m_nRectPos=0;
				}
			}
			else if(m_nRectPart==1){
				rx=m_rRect.right;
				ry=m_rRect.top+m_nRectPos;
				if(ry==m_rRect.bottom){
					m_nRectPart++;
					m_nRectPos=0;
				}
			}
			else if(m_nRectPart==2){
				rx=m_rRect.right-m_nRectPos;
				ry=m_rRect.bottom;
				if(rx==m_rRect.left){
					m_nRectPart++;
					m_nRectPos=0;
				}
			}
			else if(m_nRectPart==3){
				rx=m_rRect.left;
				ry=m_rRect.bottom-m_nRectPos;
				if(ry==m_rRect.top){
					m_nRectPart = 0;
					m_nRectPos = -m_nStep;
					m_rRect.left-=m_nStep;
					m_rRect.top-=m_nStep;
					m_rRect.right+=m_nStep;
					m_rRect.bottom+=m_nStep;
					if(m_rRect.left<0 && m_rRect.top<0 && m_rRect.right>=m_nX && m_rRect.bottom>=m_nY){
						if(m_nStep>1){
							m_nStep=1;
							m_nStepPos=i;
							m_nRectPos = -m_nStep;
							m_nRectPart = 3;
							m_rRect.left=m_rRect.right=m_nX/2;
							m_rRect.top=m_rRect.bottom=m_nY/2;
							continue;
						}
					}
				}
			}
			if(rx>=0 && ry>=0 && rx<m_nX && ry<m_nY)
				break;
		}
		int nDoneIndex = m_nX*ry+rx;
		if(pnDone[nDoneIndex]==-1){
			m_pPixels[i].x=rx;
			m_pPixels[i].y=ry;
			pnDone[nDoneIndex]=i;
			i++;
		}
	}
	delete [] pnDone;
	m_nStep=nStep;
}
int CPixels::GetStep()
{
	if(m_nNextPixel<m_nStepPos)
		return m_nStep;
	return 1;
}
BOOL CPixels::GetPixel(int &rx,int &ry,BOOL bMirrored)
{
	do{
		int nNext = InterlockedIncrement((LPLONG)&m_nNextPixel);
		if(nNext<m_nPixels){
			rx=m_pPixels[nNext].x;
			ry=m_pPixels[nNext].y;
			if(bMirrored && ry>m_nY2)
				continue;
			return TRUE;
		}
		return FALSE;
	}while(bMirrored);
	return FALSE;
}
BOOL CPixels::GetPixels(int *prx,int *pry,int &nCount)
{
	int i, bRet=0;
	if(m_nNextPixel==m_nPixels)
		return FALSE;
	WaitForSingleObject(m_hMutex,INFINITE);
	for(i=0;i<nCount;i++){
		prx[i]=m_pPixels[m_nNextPixel].x;
		pry[i]=m_pPixels[m_nNextPixel].y;
		m_nNextPixel++;
		if(m_nNextPixel==m_nPixels)
			break;
		bRet=1;
		return TRUE;
	}
	nCount=i;
	ReleaseMutex(m_hMutex);
	return TRUE;
}
