#include <windows.h>
#include "CFixedFloat.h"
#ifdef _WIN64
#include "CDecNumber.h"
#else
#include "CDecNumber_old.h"
#endif

#include "floatexp.h"

class CPixels
{
	RECT m_rRect;
	int m_nX;
	int m_nX2;
	int m_nY;
	int m_nY2;
	int m_nStep;
	int m_nStepPos;
	int m_nRectPos;
	int m_nRectPart;
	POINT *m_pPixels;
	int m_nPixels;
	int m_nNextPixel;
	HANDLE m_hMutex;
public:
	CPixels();
	void Init(int nStep,int nX,int nY);
	int GetStep();
	BOOL GetPixel(int &x,int &y,BOOL bMirrored=0);
	BOOL GetPixels(int *px,int *py,int &nCount);
};

struct COLOR14 { unsigned char r,g,b; };
#define OLD_GLITCH 29
struct ldbl { unsigned char val[
#ifdef _WIN64
16
#else
12
#endif
]; };

struct ldblexp { 
	ldbl val;
	__int64 exp;
};
#define MULTIWAVE_MAX 30
struct MULTIWAVE
{
	int nPeriod;
	int nStart;
	int nType;
};
class CFraktalSFT
{
	MULTIWAVE m_MW[MULTIWAVE_MAX];
	int m_nMW;
	BOOL m_bMW;
	HANDLE m_hMutex;
	CPixels m_P;
	CFixedFloat m_rstart, m_istart, m_rstop, m_istop, m_rref, m_iref;
	CFixedFloat m_storedr, m_storedi;
	POINT m_pOldGlitch[OLD_GLITCH];
	int m_nSizeImage;
	int m_nZoom;
	int m_nMaxIter;
	int m_nTotal;
	HBITMAP m_bmBmp;
	COLOR14 m_cPos[1025], m_cKeys[1025];
	int m_nParts;
	int m_nSeed;
	int **m_nPixels;
	BOOL m_bTrans;
	BOOL m_bITrans;
	float **m_nTrans;
	BOOL m_bNoGlitchDetection;
	int m_nPower;
	
	double m_nBailout;
	double m_nBailout2;
	int m_nSmoothMethod;
	int m_nColorMethod;
	int m_nColorOffset;
	BOOL m_bIterChanged;
	int m_nMinI, m_nMaxI;

	double m_xrd, m_xid;

	floatexp *m_dxr, *m_dxi;
	floatexp m_Ar;
	floatexp m_Ai;
	floatexp m_Br;
	floatexp m_Bi;
	floatexp m_Cr;
	floatexp m_Ci;
	floatexp m_Dr;
	floatexp m_Di;
	floatexp m_Er;
	floatexp m_Ei;
	floatexp m_Fr;
	floatexp m_Fi;
	floatexp m_Gr;
	floatexp m_Gi;
	floatexp *m_DX;
	floatexp *m_DY;

/*	ldblexp m_lAr;
	ldblexp m_lAi;
	ldblexp m_lBr;
	ldblexp m_lBi;
	ldblexp m_lCr;
	ldblexp m_lCi;
	ldblexp m_lDr;
	ldblexp m_lDi;
	ldblexp m_lEr;
	ldblexp m_lEi;
	ldblexp m_lFr;
	ldblexp m_lFi;
	ldblexp m_lGr;
	ldblexp m_lGi;
*/
	BOOL m_bMirrored;

	ldbl *m_ldxr, *m_ldxi;
	ldbl *m_lDX;
	ldbl *m_lDY;

	double m_nIterDiv;
	int m_nMaxApproximation;
	RECT m_rApprox;

	double *m_db_dxr, *m_db_dxi, *m_db_z;
	double *m_pDX;
	double *m_pDY;

	BYTE *m_lpBits;
	int m_row;
	BITMAPINFOHEADER *m_bmi;
	int m_nX, m_nXPrev;
	int m_nY, m_nYPrev;
	int m_nDone;
	int m_nGuessed;
	int m_nRDone;
	BOOL m_bStop;
	BOOL m_bRunning;
	HWND m_hWnd;
	char *m_szPosition;
	BOOL m_bReuseRef;
	double m_nScaling;
	int m_nScalingOffset;
	int m_nStatus;
	int m_nFrameDone;
	BOOL m_bAddReference;
	BOOL m_bNoApproximation;

	void CalculateApproximation(int nType);
	void CalculateReference();
	void CalculateReferenceEXP();
	void CalculateReferenceLDBL();
	void CreateLists();
	char *ToZoom(CDecNumber &z,int &zoom);
	void RenderFractalEXP();
	void RenderFractalLDBL();
	int GetArea(int **Node, int nXStart,int nXStop,int nEqSpan=2,int **Pixels=NULL,int nDone=-1);

	void SetColor(int nIndex,int nIter,double offs=0);
public:
	int nPos;
	void MandelCalc(int nX, int nY);
	void MandelCalcEXP(int nX, int nY);
	void MandelCalcLDBL(int nX, int nY);

	CFraktalSFT();
	~CFraktalSFT();

	void SetPosition(CFixedFloat &rstart, CFixedFloat &rstop, CFixedFloat &istart,CFixedFloat &istop,int nX, int nY);
	void SetPosition(char *szR, char *szI, char *szZ);
	char *ToZoom();
	void RenderFractal(int nX, int nY,int nMaxIter,HWND hWnd,BOOL bNoThread=FALSE,BOOL bResetOldGlitch=TRUE);
	void RenderFractal();
	HBITMAP GetBitmap();
	void UpdateBitmap();
	int GetWidth();
	int GetHeight();
	void Stop();
	int CountFrames(int nProcent);
	void Zoom(int nXPos,int nYPos,double nZoomSize,int nWidth,int nHeight,BOOL bReuseCenter=FALSE);
	BOOL Center(int &rx, int &ry,BOOL bSkipM=FALSE,BOOL bQuick=FALSE);
	int GetProgress(int *pnGuessed=NULL,int *pnRDone=NULL);
	char *GetPosition();
	void GetIterations(int &nMin, int &nMax,int *pnCalculated=NULL,int *pnType=NULL);
	int GetIterations();
	void SetIterations(int nIterations);
	char *GetRe();
	char *GetIm();
	char *GetZoom();
	void GenerateColors(int nParts,int nSeed=-1);
	void GenerateColors2(int nParts,int nSeed=-1,int nWaves=9);
	void AddWave(int nCol,int nPeriod=-1, int nStart=-1);
	void ChangeNumOfColors(int nParts);
	int GetNumOfColors();
	void ApplyColors();
	void ApplyIterationColors();
	void ApplySmoothColors();
	int GetSeed();
	void ReuseReference(BOOL bReuse);
	COLOR14 GetKeyColor(int i);
	void SetKeyColor(COLOR14 col,int i);
	COLOR14 GetColor(int i);
	BOOL OpenFile(char *szFile);
	BOOL OpenMapB(char *szFile,BOOL bReuseCenter=FALSE,double nZoomSize=1);
	BOOL SaveFile(char *szFile);
	double GetIterDiv();
	void SetIterDiv(double nIterDiv);
	int SaveJpg(char *szFile,int nQuality,int nWidth=0, int nHeight=0);
	int GetMaxApproximation();
	int GetIterationOnPoint(int x, int y);
	int GetTransOnPoint(int x, int y);
	BOOL AddReference(int x, int y,BOOL bEraseAll=FALSE,BOOL bNP=FALSE,BOOL bNoGlitchDetection=FALSE);
	BOOL HighestIteration(int &rx, int &ry);
	BOOL FindCenterOfGlitch(int &rx, int &ry,BOOL bNP=FALSE);
	BOOL GetNoApproximation();
	void SetNoApproximation(BOOL bNoApproximation);
	int GetColorIndex(int x, int y);
	BOOL GetTransition();
	void SetTransition(BOOL bTransition);
	BOOL GetITransition();
	void SetITransition(BOOL bITransition);

	void SaveMap(char *szFile);
	void SaveMapB(char *szFile);

	int GetSmoothMethod();
	void SetSmoothMethod(int nSmoothMethod);
	int GetPower();
	void SetPower(int nPower);
	void SetColorMethod(int nColorMethod);
	int GetColorMethod();
	void SetColorOffset(int nColorOffset);
	int GetColorOffset();
	void ErasePixel(int x, int y);

	void StoreLocation();
	void Mirror(int x, int y);
	int GetMirror();
	void SetMirror(BOOL bMirror);

	int GetMWCount();
	void SetMW(BOOL bMW);
	int GetMW();
	BOOL GetMW(int nIndex, int &nPeriod,int &nStart,int &nType);
	BOOL AddMW(int nPeriod,int nStart,int nType);
	BOOL UpdateMW(int nIndex, int nPeriod,int nStart,int nType);
	BOOL DeleteMW(int nIndex);
};

struct TH_PARAMS
{
	int nXStart;
	int nXStop;
	CFraktalSFT *p;
};
