#include <windows.h>
#include <commctrl.h>
#include <math.h>
#include "..\..\common\parallell.h"
#include "..\..\common\getimage.h"
#include "..\..\common\StringVector.h"
#include "..\..\common\FolderBrowser.h"
#include "..\..\common\listbox.h"
#include "resource.h"
#include "fraktal_sft.h"
#include <malloc.h>

extern BOOL g_LDBL;
extern int g_nLDBL;
extern int g_nEXP;
#ifdef _WIN64
#define GCL_WNDPROC -24
#define GWL_WNDPROC -4
#define GWL_USERDATA -21
#endif

double CHECK_FLOAT(double a);
BOOL ISFLOATOK(double a);
CFraktalSFT g_SFT;
BOOL g_bAddReference=FALSE;
BOOL g_bEraser=FALSE;
BOOL g_bAddMainReference=FALSE;
BOOL g_bAutoGlitch=TRUE;
BOOL g_bAutoGlitchNP=FALSE;

BOOL g_bAutoIterations=TRUE;
int g_nPrevGlitchX=-1;
int g_nPrevGlitchY=-1;
BOOL g_bStoreZoom=FALSE;
BOOL g_bStoreZoomJpg=FALSE;
BOOL g_bWaitRead=FALSE;
int MakePrime(int n);

char *g_pszStatus[] = {
			"Generate reference",
			"Render first image",
			"Check done images",
			"Center",
			"Top",
			"Bottom",
			"Top left",
			"Bottom left",
			"Top right",
			"Bottom right",
			"Left",
			"Right"};
int g_nStatus=0;
BOOL g_bFirstDone=TRUE;
BOOL g_bSaveJpeg=FALSE;
char g_szRecovery[256];

BOOL g_bResetReference=FALSE;
BOOL g_bFindMinibrot=FALSE;
BOOL g_bFindMinibrotCount=0;

BOOL g_bZoomRunning=FALSE;
BOOL g_bZoomStop=FALSE;
HWND g_hwExamine=NULL;
char g_szExamine[256];
CStringTable g_stExamine;
int g_nExamine=-1;
int g_nExamineZoom=-1;
BOOL g_bExamineDirty=FALSE;
int SaveJPG(char *szFileName, char *Data, int nHeight, int nWidth, int nColors, int nQuality);
int SaveJpg(char *szFileName,HBITMAP bmBmp,int nQuality)
{
	int row, height, nXStart, nYStart;
	BYTE *lpBits, *lpJeg;
	BITMAPINFOHEADER bmi={sizeof(BITMAPINFOHEADER)};
	HDC hDC = GetDC(NULL);
	if(!GetDIBits(hDC,bmBmp,0,0,NULL,(LPBITMAPINFO)&bmi,DIB_RGB_COLORS))
		Beep(1000,10);
	bmi.biCompression=bmi.biClrUsed=bmi.biClrImportant=0;
	bmi.biBitCount = 24;
	row = ((((bmi.biWidth*(DWORD)bmi.biBitCount)+31)&~31) >> 3);
	height = bmi.biHeight*3;
	bmi.biSizeImage=row*bmi.biHeight;
	lpBits = new BYTE[bmi.biSizeImage];
	lpJeg = new BYTE[bmi.biSizeImage];
	if(!GetDIBits(hDC,bmBmp,0,bmi.biHeight,lpBits,
			(LPBITMAPINFO)&bmi,DIB_RGB_COLORS))
		Beep(1000,10);

	int nPos=0;
	for(nYStart=bmi.biHeight;nYStart>=0;nYStart--){
		for(nXStart=0;nXStart<bmi.biWidth;nXStart++){
			if(nXStart*3 + nYStart*row + 2 < (int)bmi.biSizeImage){
				lpJeg[nPos++]=lpBits[nXStart*3 + nYStart*row + 2];
				lpJeg[nPos++]=lpBits[nXStart*3 + nYStart*row + 1];
				lpJeg[nPos++]=lpBits[nXStart*3 + nYStart*row];
			}
		}
	}
	int nRet = SaveJPG(szFileName,(char*)lpJeg,bmi.biHeight,bmi.biWidth,3,nQuality);
	delete [] lpJeg;
	delete [] lpBits;
	ReleaseDC(NULL,hDC);
	return nRet;
}
POINT g_pSelect, g_pStart;
int g_bSelect=0;
int g_nZoomSize=4;
BOOL g_bReuseRef=FALSE;
HWND g_hwStatus=NULL;
__int64 g_nTStart;
BOOL g_bRunning=FALSE;
HWND g_hwHair;
HWND g_hwColors=NULL;
char g_szFile[256]={0};

int g_nPrevCalc=-1;
int WINAPI IterationProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if(uMsg==WM_INITDIALOG || uMsg==WM_TIMER){
		if(uMsg==WM_INITDIALOG){
			SetDlgItemInt(hWnd,IDC_EDIT1,g_SFT.GetIterations(),FALSE);
			SetTimer(hWnd,0,1000,NULL);

			SendDlgItemMessage(hWnd,IDC_COMBO2,CB_ADDSTRING,0,(LPARAM)"High bailout");
			SendDlgItemMessage(hWnd,IDC_COMBO2,CB_ADDSTRING,0,(LPARAM)"Bailout=2");
			SendDlgItemMessage(hWnd,IDC_COMBO2,CB_SETCURSEL,g_SFT.GetSmoothMethod(),0);
			SendDlgItemMessage(hWnd,IDC_COMBO3,CB_ADDSTRING,0,(LPARAM)"2");
			SendDlgItemMessage(hWnd,IDC_COMBO3,CB_ADDSTRING,0,(LPARAM)"3");
			SendDlgItemMessage(hWnd,IDC_COMBO3,CB_SETCURSEL,g_SFT.GetPower()-2,0);
		}
		int nMin, nMax, nCalc=0,nType=0;
		g_SFT.GetIterations(nMin,nMax,&nCalc,&nType);
		SetDlgItemInt(hWnd,IDC_EDIT2,nMin,FALSE);
		SetDlgItemInt(hWnd,IDC_EDIT5,nMax,FALSE);
		SetDlgItemInt(hWnd,IDC_EDIT7,g_SFT.GetMaxApproximation(),FALSE);
		if(uMsg==WM_TIMER){
			char szCalc[128];
			wsprintf(szCalc,"%d",nCalc);
			int k=strlen(szCalc);
			while(k>3){
				int n=strlen(szCalc);
				while(n>k-4){
					szCalc[n+1]=szCalc[n];
					n--;
				}
				szCalc[k-3]=' ';
				k-=3;
			}
			if(nType)
				strcat(szCalc," 000 000");
			if(g_nPrevCalc!=-1){
				int nC = nCalc-g_nPrevCalc;
				if(!nType)
					nC/=1000000;
				wsprintf(szCalc+strlen(szCalc),", %d M/s",nC);
			}
			g_nPrevCalc=nCalc;
			SetDlgItemText(hWnd,IDC_EDIT8,szCalc);
		}
		else 
			g_nPrevCalc=-1;
		return 1;
	}
	else if(uMsg==WM_COMMAND){
		if(wParam==IDOK){
			g_bExamineDirty=TRUE;
			g_SFT.SetSmoothMethod(SendDlgItemMessage(hWnd,IDC_COMBO2,CB_GETCURSEL,0,0));
			g_SFT.SetPower(SendDlgItemMessage(hWnd,IDC_COMBO3,CB_GETCURSEL,0,0)+2);
			EndDialog(hWnd,GetDlgItemInt(hWnd,IDC_EDIT1,NULL,0));
		}
		else if(wParam==IDCANCEL)
			EndDialog(hWnd,0);
	}
	return 0;
}
long WINAPI ShowProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if(uMsg==WM_PAINT){
		PAINTSTRUCT ps;
		BeginPaint(hWnd,&ps);
		int i;
		RECT cr;
		GetClientRect(hWnd,&cr);
		for(i=0;i<1024;i++){
			RECT r={i*cr.right/1024,0,(i+1)*cr.right/1024,cr.bottom};
			COLOR14 c = g_SFT.GetColor(i);
			HBRUSH br = CreateSolidBrush(RGB(c.b,c.g,c.r));
			FillRect(ps.hdc,&r,br);
			DeleteObject(br);
		}
		EndPaint(hWnd,&ps);
		return 0;
	}
	return CallWindowProc((WNDPROC)GetClassLong(hWnd,GCL_WNDPROC),hWnd,uMsg,lParam,wParam);
}
RECT g_rShow;
COLOR14 g_colCopy={0};
BOOL g_bCaptureMouse=FALSE;
BOOL g_bInitColorDialog=FALSE;
CListBoxEdit *g_pWaves=NULL;
int WINAPI ColorProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	static COLORREF colCust[16]={0};
	if(uMsg==WM_INITDIALOG || uMsg==WM_USER+99 || (uMsg==WM_COMMAND && wParam==IDC_CHECK6)){
		if(!g_pWaves){
			HWND hwnds[2]={GetDlgItem(hWnd,IDC_EDIT23),GetDlgItem(hWnd,IDC_EDIT25)};
			g_pWaves = new CListBoxEdit(GetDlgItem(hWnd,IDC_BUTTON26), GetDlgItem(hWnd,IDC_BUTTON27), GetDlgItem(hWnd,IDC_BUTTON28), GetDlgItem(hWnd,IDC_EDIT24), GetDlgItem(hWnd,IDC_LIST6),hwnds, 2);

			SendDlgItemMessage(hWnd,IDC_COMBO4,CB_ADDSTRING,0,(LPARAM)"Hue");
			SendDlgItemMessage(hWnd,IDC_COMBO4,CB_ADDSTRING,0,(LPARAM)"Saturation");
			SendDlgItemMessage(hWnd,IDC_COMBO4,CB_ADDSTRING,0,(LPARAM)"Brightness");
		}
		if(uMsg==WM_COMMAND && wParam==IDC_CHECK6){
			g_SFT.SetMW(SendDlgItemMessage(hWnd,IDC_CHECK6,BM_GETCHECK,0,0));
			PostMessage(hWnd,WM_COMMAND,IDOK,0);
		}
		else
			SendDlgItemMessage(hWnd,IDC_CHECK6,BM_SETCHECK,g_SFT.GetMW(),0);
		EnableWindow(GetDlgItem(hWnd,IDC_COMBO4),g_SFT.GetMW());
		EnableWindow(GetDlgItem(hWnd,IDC_EDIT23),g_SFT.GetMW());
		EnableWindow(GetDlgItem(hWnd,IDC_BUTTON29),g_SFT.GetMW());
		EnableWindow(GetDlgItem(hWnd,IDC_EDIT25),g_SFT.GetMW());
		EnableWindow(GetDlgItem(hWnd,IDC_LIST6),g_SFT.GetMW());
		EnableWindow(GetDlgItem(hWnd,IDC_BUTTON26),g_SFT.GetMW());
		EnableWindow(GetDlgItem(hWnd,IDC_BUTTON27),g_SFT.GetMW());
		EnableWindow(GetDlgItem(hWnd,IDC_BUTTON28),g_SFT.GetMW());
	}
	else if(HIWORD(wParam)==LBN_SELCHANGE && LOWORD(wParam)==IDC_LIST6){
		char szTmp[256];
		int i = SendDlgItemMessage(hWnd,IDC_LIST6,LB_GETCURSEL,0,0);
		if(i!=-1){
			SendDlgItemMessage(hWnd,IDC_LIST6,LB_GETTEXT,i,(LPARAM)szTmp);
			if(*szTmp=='H')
				SendDlgItemMessage(hWnd,IDC_COMBO4,CB_SETCURSEL,0,0);
			else if(*szTmp=='S')
				SendDlgItemMessage(hWnd,IDC_COMBO4,CB_SETCURSEL,1,0);
			else if(*szTmp=='B')
				SendDlgItemMessage(hWnd,IDC_COMBO4,CB_SETCURSEL,2,0);
		}
	}
	else if(HIWORD(wParam)==CBN_SELCHANGE && LOWORD(wParam)==IDC_COMBO4){
		int i = SendDlgItemMessage(hWnd,IDC_COMBO4,CB_GETCURSEL,0,0);
		if(i==0)
			SetDlgItemText(hWnd,IDC_EDIT24,"H");
		else if(i==1)
			SetDlgItemText(hWnd,IDC_EDIT24,"S");
		else if(i==2)
			SetDlgItemText(hWnd,IDC_EDIT24,"B");
	}
	if(uMsg==WM_INITDIALOG || uMsg==WM_USER+99){
		g_bInitColorDialog=FALSE;
		
		SendDlgItemMessage(hWnd,IDC_LIST6,LB_RESETCONTENT,0,0);
		int i;
		char szTmp[256];
		for(i=0;i<g_SFT.GetMWCount();i++){
			int nPeriod, nStart, nType;
			g_SFT.GetMW(i,nPeriod, nStart, nType);
			if(nType==0)
				strcpy(szTmp,"H\t");
			else if(nType==1)
				strcpy(szTmp,"S\t");
			else if(nType==2)
				strcpy(szTmp,"B\t");
			itoa(nPeriod,szTmp+strlen(szTmp),10);
			strcat(szTmp,"\t");
			itoa(nStart,szTmp+strlen(szTmp),10);
			SendDlgItemMessage(hWnd,IDC_LIST6,LB_ADDSTRING,0,(LPARAM)szTmp);
		}

		SetWindowText(hWnd,"Number of Colors");
		SetDlgItemInt(hWnd,IDC_EDIT1,g_SFT.GetNumOfColors(),FALSE);
		SetDlgItemInt(hWnd,IDC_EDIT2,g_SFT.GetSeed(),FALSE);
		SetDlgItemInt(hWnd,IDC_EDIT3,g_SFT.GetIterDiv(),FALSE);
		SetDlgItemInt(hWnd,IDC_EDIT12,g_SFT.GetColorOffset(),FALSE);
		SendDlgItemMessage(hWnd,IDC_SPIN1,UDM_SETRANGE,0,MAKELONG(1024,2));
		SendDlgItemMessage(hWnd,IDC_SPIN2,UDM_SETRANGE,0,MAKELONG(1000000,1));
		SendDlgItemMessage(hWnd,IDC_SPIN5,UDM_SETRANGE,0,MAKELONG(1023,0));

		SendDlgItemMessage(hWnd,IDC_LIST1,WM_SETREDRAW,0,0);
		SendDlgItemMessage(hWnd,IDC_LIST1,LB_RESETCONTENT,0,0);
		for(i=0;i<g_SFT.GetNumOfColors();i++)
			SendDlgItemMessage(hWnd,IDC_LIST1,LB_ADDSTRING,0,(LPARAM)"");
		SendDlgItemMessage(hWnd,IDC_LIST1,WM_SETREDRAW,1,0);
		HWND hw = GetDlgItem(hWnd,IDC_SHOW);
		if(hw){
//		BOOL b = SetWindowLong(hw,GWL_WNDPROC,(LONG)ShowProc);
			GetWindowRect(hw,&g_rShow);
			g_rShow.right-=g_rShow.left;
			g_rShow.bottom-=g_rShow.top;
			ScreenToClient(hWnd,(LPPOINT)&g_rShow);
			DestroyWindow(hw);
		}
		SendDlgItemMessage(hWnd,IDC_CHECK2,BM_SETCHECK,g_SFT.GetTransition(),0);
		SendDlgItemMessage(hWnd,IDC_CHECK3,BM_SETCHECK,g_SFT.GetITransition(),0);
		if(uMsg==WM_INITDIALOG){
			SetDlgItemInt(hWnd,IDC_EDIT9,2,0);
			SetDlgItemInt(hWnd,IDC_EDIT11,4,0);
			SendDlgItemMessage(hWnd,IDC_SPIN3,UDM_SETRANGE,0,MAKELONG(1,1024));
			SetDlgItemInt(hWnd,IDC_EDIT10,50,0);
			SendDlgItemMessage(hWnd,IDC_SPIN4,UDM_SETRANGE,0,MAKELONG(1,100));

			SendDlgItemMessage(hWnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)"Standard");
			SendDlgItemMessage(hWnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)"Square root");
			SendDlgItemMessage(hWnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)"Cubic root");
			SendDlgItemMessage(hWnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)"Logarithm");
			SendDlgItemMessage(hWnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)"Histogram");
		}
		else
			InvalidateRect(hWnd,NULL,FALSE);
		SendDlgItemMessage(hWnd,IDC_COMBO1,CB_SETCURSEL,g_SFT.GetColorMethod(),0);
		g_bInitColorDialog=TRUE;
		return 1;
	}
	else if(uMsg==WM_PAINT){
		PAINTSTRUCT ps;
		BeginPaint(hWnd,&ps);
		int i;
		RECT rb={g_rShow.left,g_rShow.top,g_rShow.right+g_rShow.left,g_rShow.top+g_rShow.bottom+1};
		FillRect(ps.hdc,&rb,(HBRUSH)GetStockObject(WHITE_BRUSH));
		for(i=0;i<1024;i++){
			RECT r={i*g_rShow.right/1024 + g_rShow.left,g_rShow.top,(i+1)*g_rShow.right/1024+g_rShow.left,g_rShow.top+g_rShow.bottom/4};
			COLOR14 c = g_SFT.GetColor(i);
			HBRUSH br = CreateSolidBrush(RGB(c.b,c.g,c.r));
			FillRect(ps.hdc,&r,br);
			DeleteObject(br);
		}
		HPEN pn = CreatePen(0,1,RGB(255,0,0));
		HPEN pnOld = (HPEN)SelectObject(ps.hdc,pn);
		MoveToEx(ps.hdc,g_rShow.left,g_rShow.top+g_rShow.bottom/2 - g_SFT.GetColor(0).b*(g_rShow.bottom/4)/255,NULL);
		for(i=1;i<1024;i++)
			LineTo(ps.hdc,i*g_rShow.right/1024 + g_rShow.left,g_rShow.top+g_rShow.bottom/2 - g_SFT.GetColor(i).b*(g_rShow.bottom/4)/255);
		SelectObject(ps.hdc,pnOld);
		DeleteObject(pn);

		pn = CreatePen(0,1,RGB(0,255,0));
		pnOld = (HPEN)SelectObject(ps.hdc,pn);
		MoveToEx(ps.hdc,g_rShow.left,g_rShow.top+3*g_rShow.bottom/4 - g_SFT.GetColor(0).g*(g_rShow.bottom/4)/255,NULL);
		for(i=1;i<1024;i++)
			LineTo(ps.hdc,i*g_rShow.right/1024 + g_rShow.left,g_rShow.top+3*g_rShow.bottom/4 - g_SFT.GetColor(i).g*(g_rShow.bottom/4)/255);
		SelectObject(ps.hdc,pnOld);
		DeleteObject(pn);

		pn = CreatePen(0,1,RGB(0,0,255));
		pnOld = (HPEN)SelectObject(ps.hdc,pn);
		MoveToEx(ps.hdc,g_rShow.left,g_rShow.top+g_rShow.bottom - g_SFT.GetColor(0).r*(g_rShow.bottom/4)/255,NULL);
		for(i=1;i<1024;i++)
			LineTo(ps.hdc,i*g_rShow.right/1024 + g_rShow.left,g_rShow.top+g_rShow.bottom - g_SFT.GetColor(i).r*(g_rShow.bottom/4)/255);
		SelectObject(ps.hdc,pnOld);
		DeleteObject(pn);

		EndPaint(hWnd,&ps);
		return 0;
	}
/*	else if(uMsg==WM_NOTIFY){
		LPNMUPDOWN lpnmud = (LPNMUPDOWN)lParam;
		if(lpnmud->hdr.code==UDN_DELTAPOS && (lpnmud->hdr.idFrom==IDC_SPIN5 || lpnmud->hdr.idFrom==IDC_SPIN1 || lpnmud->hdr.idFrom==IDC_SPIN2))
			SendMessage(hWnd,WM_COMMAND,IDOK,0);
	}
*/	else if(uMsg==WM_COMMAND){
		if(g_bInitColorDialog && (HIWORD(wParam)==EN_UPDATE && (LOWORD(wParam)==IDC_EDIT1 || LOWORD(wParam)==IDC_EDIT3 || LOWORD(wParam)==IDC_EDIT12)) || (HIWORD(wParam)==CBN_SELCHANGE && LOWORD(wParam)==IDC_COMBO1)){
			g_bInitColorDialog=FALSE;
			SendMessage(hWnd,WM_COMMAND,IDOK,0);
			return 0;
		}	
		if(wParam==IDCANCEL)
			ShowWindow(hWnd,SW_HIDE);
		else if(wParam==IDOK){
			int nColors = GetDlgItemInt(hWnd,IDC_EDIT1,NULL,0);
			if(nColors<=0 || nColors>1024){
				nColors=1024;
				SetDlgItemInt(hWnd,IDC_EDIT1,nColors,FALSE);
			}
			g_SFT.ChangeNumOfColors(nColors);
			char szDiv[256];
			GetDlgItemText(hWnd,IDC_EDIT3,szDiv,sizeof(szDiv));
			double nDiv = atof(szDiv);
			if(nDiv==0)
				nDiv=1;
			g_SFT.SetIterDiv(nDiv);
			int nO = GetDlgItemInt(hWnd,IDC_EDIT12,NULL,0);
			g_SFT.SetColorOffset(nO);
			if(nO!=g_SFT.GetColorOffset())
				SetDlgItemInt(hWnd,IDC_EDIT12,g_SFT.GetColorOffset(),FALSE);
			g_SFT.SetColorMethod(SendDlgItemMessage(hWnd,IDC_COMBO1,CB_GETCURSEL,0,0));
			g_SFT.SetTransition(SendDlgItemMessage(hWnd,IDC_CHECK2,BM_GETCHECK,0,0));
			g_SFT.SetITransition(SendDlgItemMessage(hWnd,IDC_CHECK3,BM_GETCHECK,0,0));
			if(nColors!=SendDlgItemMessage(hWnd,IDC_LIST1,LB_GETCOUNT,0,0)){
				SendDlgItemMessage(hWnd,IDC_LIST1,WM_SETREDRAW,0,0);
				SendDlgItemMessage(hWnd,IDC_LIST1,LB_RESETCONTENT,0,0);
				int i;
				for(i=0;i<nColors;i++)
					SendDlgItemMessage(hWnd,IDC_LIST1,LB_ADDSTRING,0,(LPARAM)"");
				SendDlgItemMessage(hWnd,IDC_LIST1,WM_SETREDRAW,1,0);
			}
			CStringVektor sv;
			g_pWaves->GetStrings(&sv);
			char *szSV = sv.ToText("\n");
			CStringTable stMW(szSV,"\t","\n");
			sv.DeleteToText(szSV);
			int i;
			for(i=0;i<stMW.GetCount();i++){
				int nType;
				if(*stMW[i][0]=='H')
					nType=0;
				else if(*stMW[i][0]=='S')
					nType=1;
				else if(*stMW[i][0]=='B')
					nType=2;
				int nPeriod = atoi(stMW[i][1]);
				int nStart = atoi(stMW[i][2]);
				if(i==g_SFT.GetMWCount())
					g_SFT.AddMW(nPeriod,nStart,nType);
				else
					g_SFT.UpdateMW(i,nPeriod,nStart,nType);
			}
			while(i<g_SFT.GetMWCount())
				g_SFT.DeleteMW(i);

			g_SFT.ApplyColors();
			InvalidateRect(GetParent(hWnd),NULL,FALSE);
			UpdateWindow(GetParent(hWnd));
			InvalidateRect(hWnd,NULL,FALSE);
			g_bInitColorDialog=TRUE;
		}
		else if(wParam==IDC_CHECK2 || wParam==IDC_CHECK3)
			PostMessage(hWnd,WM_COMMAND,IDOK,0);
		else if(wParam==IDC_BUTTON1){
			char szFile[256]={0};
			if(BrowseFile(hWnd,FALSE,"Save palette","Palette\0*.kfp\0",szFile,sizeof(szFile)))
				g_SFT.SaveFile(szFile);
		}
		else if(wParam==IDC_BUTTON29){
			int val = GetDlgItemInt(hWnd,IDC_EDIT23,NULL,FALSE);
			val = MakePrime(val);
			SetDlgItemInt(hWnd,IDC_EDIT23,val,FALSE);
		}
		else if(wParam==IDC_BUTTON6)
		{
			int nParts = g_SFT.GetNumOfColors();
			int nPParts = nParts;
			int j=nParts-1;
			nParts*=2;
			if(nParts>1024)
				return ColorProc(hWnd,uMsg,IDC_BUTTON7,lParam);
			g_SFT.ChangeNumOfColors(nParts);
			int i;
			for(i=nParts-1;i>=0;i-=2){
				COLOR14 n;
				if(j>=nPParts-1)
					n=g_SFT.GetKeyColor(0);
				else
					n = g_SFT.GetKeyColor(j+1);
				COLOR14 c = g_SFT.GetKeyColor(j--);
				n.r = (n.r+c.r)/2;
				n.g = (n.g+c.g)/2;
				n.b = (n.b+c.b)/2;
				g_SFT.SetKeyColor(n,i);
				g_SFT.SetKeyColor(c,i-1);
			}
//			g_SFT.ChangeNumOfColors(nParts-1);
			SendMessage(hWnd,WM_USER+99,0,0);
			g_SFT.ApplyColors();
		}
		else if(wParam==IDC_BUTTON7){
			int i;
			g_SFT.ApplyColors();
			COLOR14 c[1024];
			for(i=0;i<1024;i++)
				c[i] = g_SFT.GetColor(i);
			g_SFT.ChangeNumOfColors(1024);
			for(i=0;i<1024;i++)
				g_SFT.SetKeyColor(c[i],i);
			SendMessage(hWnd,WM_USER+99,0,0);
			g_SFT.ApplyColors();
		}
		else if(wParam==IDC_CHECK1){
			if(SendDlgItemMessage(hWnd,IDC_CHECK1,BM_GETCHECK,0,0)){
				SetCapture(hWnd);
				SetTimer(hWnd,0,200,NULL);
			}
			else{
				ReleaseCapture();
				KillTimer(hWnd,0);
			}
		}
		else if(wParam==IDC_BUTTON5){
			char szFile[256]={0};
			if(BrowseFile(hWnd,TRUE,"Open palette","Palette\0*.kfp\0",szFile,sizeof(szFile))){
				DWORD dw;
				HANDLE hFile = CreateFile(szFile,GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
				if(hFile==INVALID_HANDLE_VALUE)
					return FALSE;
				int nData = GetFileSize(hFile,NULL);
				char *szData = new char[nData+1];
				ReadFile(hFile,szData,nData,&dw,NULL);
				CloseHandle(hFile);
				szData[nData]=0;
				CStringTable stParams(szData,": ","\r\n");
				delete [] szData;
				int nC = stParams.FindString(0,"Colors");
				if(nC==-1)
					return MessageBox(hWnd,"Invalid file","Error",MB_OK|MB_ICONSTOP);
				CStringTable stColors(stParams[nC][1],"",",");
				int nParts = stColors.GetCount()/3;
				g_SFT.ChangeNumOfColors(nParts);
				int i;
				COLOR14 c;
				for(i=0;i<nParts;i++){
					c.r = atoi(stColors[i*3][0]);
					c.g = atoi(stColors[i*3+1][0]);
					c.b = atoi(stColors[i*3+2][0]);
					g_SFT.SetKeyColor(c,i);
				}
				int nID = stParams.FindString(0,"IterDiv");
				int nDiv=1;
				if(nID!=-1)
					nDiv = atoi(stParams[nID][1]);
				if(nDiv<1)
					nDiv=1;
				g_SFT.SetIterDiv(nDiv);
				SendMessage(hWnd,WM_USER+99,0,0);
				g_SFT.ApplyColors();
			}
		}
		else if(wParam==IDC_BUTTON2){
			int nColors = GetDlgItemInt(hWnd,IDC_EDIT1,NULL,0);
			if(nColors>1024){
				nColors=1024;
				SetDlgItemInt(hWnd,IDC_EDIT1,nColors,FALSE);
			}
			int nSeed = GetDlgItemInt(hWnd,IDC_EDIT2,NULL,0);
			g_SFT.GenerateColors(nColors,nSeed);
			g_SFT.ApplyColors();
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
			InvalidateRect(GetParent(hWnd),NULL,FALSE);
			if(nColors!=SendDlgItemMessage(hWnd,IDC_LIST1,LB_GETCOUNT,0,0)){
				SendDlgItemMessage(hWnd,IDC_LIST1,LB_RESETCONTENT,0,0);
				int i;
				for(i=0;i<nColors;i++)
					SendDlgItemMessage(hWnd,IDC_LIST1,LB_ADDSTRING,0,(LPARAM)"");
			}
			InvalidateRect(hWnd,NULL,FALSE);
		}
		else if(wParam==IDC_BUTTON12 || wParam==IDC_BUTTON14){
			if(wParam==IDC_BUTTON14){
				int nCols = g_SFT.GetNumOfColors();
				srand(GetTickCount());
				int nVal = rand()%nCols;
				if(nVal==0)
					nVal=1;
				SetDlgItemInt(hWnd,IDC_EDIT11,nVal = MakePrime(nVal),FALSE);
				SetDlgItemInt(hWnd,IDC_EDIT13,rand()%nVal,FALSE);
				nVal = rand()%nCols;
				if(nVal==0)
					nVal=1;
				SetDlgItemInt(hWnd,IDC_EDIT14,nVal = MakePrime(nVal),FALSE);
				SetDlgItemInt(hWnd,IDC_EDIT15,rand()%nVal,FALSE);
				nVal = rand()%nCols;
				if(nVal==0)
					nVal=1;
				SetDlgItemInt(hWnd,IDC_EDIT16,nVal = MakePrime(nVal),FALSE);
				SetDlgItemInt(hWnd,IDC_EDIT17,rand()%nVal,FALSE);
				nVal = rand()%nCols;
				if(nVal==0)
					nVal=1;
				SetDlgItemInt(hWnd,IDC_EDIT18,nVal = MakePrime(nVal),FALSE);
				SetDlgItemInt(hWnd,IDC_EDIT19,rand()%nVal,FALSE);
			}
			int nPeriod = GetDlgItemInt(hWnd,IDC_EDIT11,NULL,FALSE);
			int nStart = GetDlgItemInt(hWnd,IDC_EDIT13,NULL,FALSE);
			g_SFT.AddWave(2,nPeriod,nStart);
			nPeriod = GetDlgItemInt(hWnd,IDC_EDIT14,NULL,FALSE);
			nStart = GetDlgItemInt(hWnd,IDC_EDIT15,NULL,FALSE);
			g_SFT.AddWave(1,nPeriod,nStart);
			nPeriod = GetDlgItemInt(hWnd,IDC_EDIT16,NULL,FALSE);
			nStart = GetDlgItemInt(hWnd,IDC_EDIT17,NULL,FALSE);
			g_SFT.AddWave(0,nPeriod,nStart);
			nPeriod = GetDlgItemInt(hWnd,IDC_EDIT18,NULL,FALSE);
			nStart = GetDlgItemInt(hWnd,IDC_EDIT19,NULL,FALSE);
			g_SFT.AddWave(3,nPeriod,nStart);

			g_SFT.ApplyColors();
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
			InvalidateRect(GetParent(hWnd),NULL,FALSE);
			InvalidateRect(hWnd,NULL,FALSE);
		}
		else if(wParam==IDC_BUTTON16){
			int nPeriod = MakePrime(GetDlgItemInt(hWnd,IDC_EDIT11,NULL,FALSE));
			SetDlgItemInt(hWnd,IDC_EDIT11,nPeriod,FALSE);
		}
		else if(wParam==IDC_BUTTON19){
			int nPeriod = MakePrime(GetDlgItemInt(hWnd,IDC_EDIT14,NULL,FALSE));
			SetDlgItemInt(hWnd,IDC_EDIT14,nPeriod,FALSE);
		}
		else if(wParam==IDC_BUTTON20){
			int nPeriod = MakePrime(GetDlgItemInt(hWnd,IDC_EDIT16,NULL,FALSE));
			SetDlgItemInt(hWnd,IDC_EDIT16,nPeriod,FALSE);
		}
		else if(wParam==IDC_BUTTON21){
			int nPeriod = MakePrime(GetDlgItemInt(hWnd,IDC_EDIT18,NULL,FALSE));
			SetDlgItemInt(hWnd,IDC_EDIT18,nPeriod,FALSE);
		}
		else if(HIWORD(wParam)==LBN_DBLCLK && LOWORD(wParam)==IDC_LIST1){
			int i = SendDlgItemMessage(hWnd,IDC_LIST1,LB_GETCURSEL,0,0);
			if(i==-1)
				return 0;
			CHOOSECOLOR col={sizeof(CHOOSECOLOR)};
			col.hwndOwner = hWnd;
			col.lpCustColors = colCust;
			col.Flags = CC_RGBINIT;
			COLOR14 c = g_SFT.GetKeyColor(i);
			col.rgbResult = RGB(c.b,c.g,c.r);
			if(ChooseColor(&col)){
				char *cc = (char*)&col.rgbResult;
				c.b = cc[0];
				c.g = cc[1];
				c.r = cc[2];
				g_SFT.SetKeyColor(c,i);
				InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
			}
		}
		else if(wParam==IDC_BUTTON8){
			COLOR14 c;
			CHOOSECOLOR col={sizeof(CHOOSECOLOR)};
			col.hwndOwner = hWnd;
			col.lpCustColors = colCust;
			col.Flags = CC_RGBINIT;
			int nStep = GetDlgItemInt(hWnd,IDC_EDIT9,NULL,FALSE);
			if(nStep==0)
				nStep =1;
			int nPercent = GetDlgItemInt(hWnd,IDC_EDIT10,NULL,FALSE);
			if(nPercent>100)
				nPercent=100;
			if(ChooseColor(&col)){
				char *cc = (char*)&col.rgbResult;
				c.b = cc[0];
				c.g = cc[1];
				c.r = cc[2];
				int i = SendDlgItemMessage(hWnd,IDC_LIST1,LB_GETCURSEL,0,0);
				if(i==-1)
					i=0;
				for(;i<g_SFT.GetNumOfColors();i+=nStep){
					COLOR14 n = g_SFT.GetKeyColor(i);
					n.r = ((100-nPercent)*n.r+nPercent*c.r)/100;
					n.g = ((100-nPercent)*n.g+nPercent*c.g)/100;
					n.b = ((100-nPercent)*n.b+nPercent*c.b)/100;
					g_SFT.SetKeyColor(n,i);
				}
			}
			SendMessage(hWnd,WM_USER+99,0,0);
			g_SFT.ApplyColors();
		}
		else if(wParam==IDC_BUTTON9){
			COLOR14 c;
			CHOOSECOLOR col={sizeof(CHOOSECOLOR)};
			col.hwndOwner = hWnd;
			col.lpCustColors = colCust;
			col.Flags = CC_RGBINIT;
			if(ChooseColor(&col)){
				char *cc = (char*)&col.rgbResult;
				c.b = cc[0];
				c.g = cc[1];
				c.r = cc[2];
				int i = SendDlgItemMessage(hWnd,IDC_LIST1,LB_GETCURSEL,0,0);
				if(i==-1)
					i=0;
				for(;i<g_SFT.GetNumOfColors();i+=3){
					COLOR14 n = g_SFT.GetKeyColor(i);
					n.r = (n.r+c.r)/2;
					n.g = (n.g+c.g)/2;
					n.b = (n.b+c.b)/2;
					g_SFT.SetKeyColor(n,i);
				}
			}
			SendMessage(hWnd,WM_USER+99,0,0);
			g_SFT.ApplyColors();
		}
		else if(wParam==IDC_BUTTON11){
			COLOR14 c;
			CHOOSECOLOR col={sizeof(CHOOSECOLOR)};
			col.hwndOwner = hWnd;
			col.lpCustColors = colCust;
			col.Flags = CC_RGBINIT;
			if(ChooseColor(&col)){
				char *cc = (char*)&col.rgbResult;
				c.b = cc[0];
				c.g = cc[1];
				c.r = cc[2];
				int i = SendDlgItemMessage(hWnd,IDC_LIST1,LB_GETCURSEL,0,0);
				if(i==-1)
					i=0;
				for(;i<g_SFT.GetNumOfColors();i+=4){
					COLOR14 n = g_SFT.GetKeyColor(i);
					n.r = (n.r+c.r)/2;
					n.g = (n.g+c.g)/2;
					n.b = (n.b+c.b)/2;
					g_SFT.SetKeyColor(n,i);
				}
			}
			SendMessage(hWnd,WM_USER+99,0,0);
			g_SFT.ApplyColors();
		}
		else if(wParam==IDC_BUTTON10){
			int nParts = g_SFT.GetNumOfColors();
			int nPParts = nParts;
			nParts*=2;
			if(nParts>1024)
				nParts=1024;
			g_SFT.ChangeNumOfColors(nParts);
			int i, j=0;
			for(i=nPParts;i<nParts;i++){
				COLOR14 c = g_SFT.GetKeyColor(j++);
				g_SFT.SetKeyColor(c,i);
			}
			SendMessage(hWnd,WM_USER+99,0,0);
			g_SFT.ApplyColors();
		}
		else if(wParam==IDC_BUTTON13){
			srand(GetTickCount());
			int nColors = GetDlgItemInt(hWnd,IDC_EDIT1,NULL,0);
			if(nColors>1024){
				nColors=1024;
				SetDlgItemInt(hWnd,IDC_EDIT1,nColors,FALSE);
			}
			int nSeed = rand();
			SetDlgItemInt(hWnd,IDC_EDIT2,nSeed,0);
			g_SFT.GenerateColors(nColors,nSeed);
			g_SFT.ApplyColors();
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
			InvalidateRect(GetParent(hWnd),NULL,FALSE);
			if(nColors!=SendDlgItemMessage(hWnd,IDC_LIST1,LB_GETCOUNT,0,0)){
				SendDlgItemMessage(hWnd,IDC_LIST1,LB_RESETCONTENT,0,0);
				int i;
				for(i=0;i<nColors;i++)
					SendDlgItemMessage(hWnd,IDC_LIST1,LB_ADDSTRING,0,(LPARAM)"");
			}
			InvalidateRect(hWnd,NULL,FALSE);
		}
	}
	else if(uMsg==WM_USER+88){
		POINT p;
		GetCursorPos(&p);
		ScreenToClient(GetDlgItem(hWnd,IDC_LIST1),&p);
		int i = SendDlgItemMessage(hWnd,IDC_LIST1,LB_ITEMFROMPOINT,0,MAKELONG(p.x,p.y));
		SendDlgItemMessage(hWnd,IDC_LIST1,LB_SETCURSEL,i,0);
		HMENU hMen = CreatePopupMenu();
		AppendMenu(hMen,MF_STRING,1,"Copy color");
		AppendMenu(hMen,MF_STRING,2,"Paste color");
		AppendMenu(hMen,MF_SEPARATOR,0,"");
		AppendMenu(hMen,MF_STRING,3,"Paste every second");
		AppendMenu(hMen,MF_STRING,4,"Paste every third");
		AppendMenu(hMen,MF_STRING,5,"Paste every forth");
		AppendMenu(hMen,MF_STRING,6,"Paste every fifth");
		AppendMenu(hMen,MF_STRING,7,"Paste every sixth");
		AppendMenu(hMen,MF_STRING,8,"Paste every seventh");
		AppendMenu(hMen,MF_STRING,9,"Paste every eighth");
		AppendMenu(hMen,MF_SEPARATOR,0,"");
		AppendMenu(hMen,MF_STRING,10,"Capture from mouse");
		GetCursorPos(&p);
		int rc = TrackPopupMenu(hMen,TPM_LEFTALIGN|TPM_RETURNCMD,p.x,p.y,0,hWnd,NULL);
		DestroyMenu(hMen);
		if(rc==0)
			return 0;
		if(rc==1)
			g_colCopy = g_SFT.GetKeyColor(i);
		else if(rc==2){
			g_SFT.SetKeyColor(g_colCopy,i);
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
		}
		else if(rc==3){
			do{
				g_SFT.SetKeyColor(g_colCopy,i);
				i+=2;
			}while(i<g_SFT.GetNumOfColors());
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
		}
		else if(rc==4){
			do{
				g_SFT.SetKeyColor(g_colCopy,i);
				i+=3;
			}while(i<g_SFT.GetNumOfColors());
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
		}
		else if(rc==5){
			do{
				g_SFT.SetKeyColor(g_colCopy,i);
				i+=4;
			}while(i<g_SFT.GetNumOfColors());
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
		}
		else if(rc==6){
			do{
				g_SFT.SetKeyColor(g_colCopy,i);
				i+=5;
			}while(i<g_SFT.GetNumOfColors());
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
		}
		else if(rc==7){
			do{
				g_SFT.SetKeyColor(g_colCopy,i);
				i+=6;
			}while(i<g_SFT.GetNumOfColors());
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
		}
		else if(rc==8){
			do{
				g_SFT.SetKeyColor(g_colCopy,i);
				i+=7;
			}while(i<g_SFT.GetNumOfColors());
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
		}
		else if(rc==9){
			do{
				g_SFT.SetKeyColor(g_colCopy,i);
				i+=8;
			}while(i<g_SFT.GetNumOfColors());
			InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
		}
		else if(rc==10){
			SetCapture(hWnd);
			g_bCaptureMouse=TRUE;
		}
	}
	else if(uMsg==WM_DRAWITEM){
		LPDRAWITEMSTRUCT lpdis = (LPDRAWITEMSTRUCT)lParam;
		COLOR14 c = g_SFT.GetKeyColor(lpdis->itemID);
		HBRUSH br = CreateSolidBrush(RGB(c.b,c.g,c.r));
		FillRect(lpdis->hDC,&lpdis->rcItem,br);
		DeleteObject(br);
		if(lpdis->itemState & ODS_SELECTED){
			SkuggadRect(lpdis->hDC,lpdis->rcItem,FALSE,0,0);
			lpdis->rcItem.left++;
			lpdis->rcItem.top++;
			lpdis->rcItem.right--;
			lpdis->rcItem.bottom--;
			SkuggadRect(lpdis->hDC,lpdis->rcItem,FALSE,TRUE,0);
		}
	}
	else if(uMsg==WM_TIMER){
		POINT p;
		GetCursorPos(&p);
		ScreenToClient(GetParent(hWnd),&p);
		RECT rc;
		GetClientRect(GetParent(hWnd),&rc);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		rc.bottom-=sr.bottom;
		int x = p.x*g_SFT.GetWidth()/rc.right;
		int y = p.y*g_SFT.GetHeight()/rc.bottom;
		int i = g_SFT.GetColorIndex(x,y);
		i/=(1024/g_SFT.GetNumOfColors());
		SendDlgItemMessage(hWnd,IDC_LIST1,LB_SETCURSEL,i,0);
	}
	else if(uMsg==WM_CAPTURECHANGED){
		g_bCaptureMouse=FALSE;
		SendDlgItemMessage(hWnd,IDC_CHECK1,BM_SETCHECK,0,0);
		KillTimer(hWnd,0);
	}
	else if(uMsg==WM_LBUTTONDOWN && SendDlgItemMessage(hWnd,IDC_CHECK1,BM_GETCHECK,0,0)){
		POINT p;
		GetCursorPos(&p);
		RECT rC;
		GetWindowRect(hWnd,&rC);
		if(p.x>=rC.left && p.x<=rC.right && p.y>=rC.top && p.y<=rC.bottom){
			KillTimer(hWnd,0);
			ReleaseCapture();
			return 0;
		}
		ScreenToClient(GetParent(hWnd),&p);

		RECT rc;
		GetClientRect(GetParent(hWnd),&rc);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		rc.bottom-=sr.bottom;
		int x = p.x*g_SFT.GetWidth()/rc.right;
		int y = p.y*g_SFT.GetHeight()/rc.bottom;

		int i = g_SFT.GetColorIndex(x,y);
		i/=(1024/g_SFT.GetNumOfColors());
		SendDlgItemMessage(hWnd,IDC_LIST1,LB_SETCURSEL,i,0);
		ReleaseCapture();
		SendDlgItemMessage(hWnd,IDC_CHECK1,BM_SETCHECK,0,0);
		KillTimer(hWnd,0);
		if(i!=-1)
			SendMessage(hWnd,WM_COMMAND,MAKELONG(IDC_LIST1,LBN_DBLCLK),(LPARAM)GetDlgItem(hWnd,IDC_LIST1));
	}
	else if(uMsg==WM_LBUTTONDOWN && g_bCaptureMouse){
		g_bCaptureMouse=FALSE;
		ReleaseCapture();
		POINT p;
		GetCursorPos(&p);
		HDC hDC = GetDC(NULL);
		COLORREF col = GetPixel(hDC,p.x,p.y);
		ReleaseDC(NULL,hDC);

		int i = SendDlgItemMessage(hWnd,IDC_LIST1,LB_GETCURSEL,0,0);
		if(i==-1)
			return 0;
		COLOR14 c = g_SFT.GetKeyColor(i);
		char *cc = (char*)&col;
		c.b = cc[0];
		c.g = cc[1];
		c.r = cc[2];
		g_SFT.SetKeyColor(c,i);
		InvalidateRect(GetDlgItem(hWnd,IDC_LIST1),NULL,FALSE);
	}
	int nRet=0;
	if(g_pWaves)
		nRet = g_pWaves->ProcessMessage(hWnd,uMsg,wParam,lParam);
	if(uMsg==WM_COMMAND && (wParam==IDC_BUTTON26 || wParam==IDC_BUTTON27 || wParam==IDC_BUTTON28))
		PostMessage(hWnd,WM_COMMAND,IDOK,0);
	return 0;
}
char *Trim(char *sz,int nLen=-1)
{
	if(nLen==-1)
		nLen = strlen(sz);
	if(nLen>(int)strlen(sz))
		nLen = strlen(sz);
	int i;
	for(i=nLen;i>0 && (sz[i-1]==(char)-96 || sz[i-1]==' ' || sz[i-1]=='\r' || sz[i-1]=='\n' || sz[i-1]=='\t');i--);
	sz[i]=0;
	while(*sz==' ')
		sz++;
	return sz;
}
int WINAPI CrossHairProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if(uMsg==WM_INITDIALOG){
		SetTimer(hWnd,1,50,NULL);

		HWND hwPrev = GetDlgItem(hWnd,IDC_PREV);
		RECT r, r2={0,0,16,16};
		GetWindowRect(hwPrev,&r);
		ScreenToClient(hWnd,(LPPOINT)&r);
		r.right=r2.right*8;
		r.bottom=r2.bottom*8;
		MoveWindow(hwPrev,r.left,r.top,r.right,r.bottom,TRUE);
	}
	else if(uMsg==WM_USER+112){
		HWND hwPrev = GetDlgItem(hWnd,IDC_PREV);
		RECT rc;
		GetClientRect(hWnd,&rc);
		MoveWindow(hwPrev,0,0,rc.right,rc.bottom,TRUE);
	}
	else if(uMsg==WM_TIMER){
		POINT p;
		GetCursorPos(&p);
		HDC dcScreen = GetDC(NULL);

		HWND hwPrev = GetDlgItem(hWnd,IDC_PREV);
		RECT r, r2={0,0,16,16};
		GetWindowRect(hwPrev,&r);
		ScreenToClient(hWnd,(LPPOINT)&r);
		r.right=r2.right*8;
		r.bottom=r2.bottom*8;

		if(hWnd==WindowFromPoint(p) || hWnd==GetParent(WindowFromPoint(p)))
			return 0;
		HDC dcPrev = GetDC(hwPrev);
		r2.left = p.x-r2.right/2+1;
		r2.top = p.y-r2.bottom/2+1;
		StretchBlt(dcPrev,0,0,r.right,r.bottom,dcScreen,r2.left,r2.top,r2.right,r2.bottom,SRCCOPY);

		SetROP2(dcPrev,R2_NOT);
		MoveToEx(dcPrev,r.right/2-4,0,NULL);
		LineTo(dcPrev,r.right/2-4,r.bottom);
		MoveToEx(dcPrev,0,r.bottom/2-4,NULL);
		LineTo(dcPrev,r.right,r.bottom/2-4);

		ReleaseDC(hwPrev,dcPrev);
		ReleaseDC(NULL,dcScreen);
	}
	return 0;
}
void FixNumber(char *sz)
{
	int a, b, p, e, m;
	for(a=0;sz[a]==' ' || sz[a]=='\t' || sz[a]=='\r' || sz[a]=='\n';a++);
	for(b=p=e=m=0;sz[a];a++){
		if(isdigit(sz[a]) || (!e && (sz[a]=='e' || sz[a]=='E')) || (!p && sz[a]=='.') || (!m && sz[a]=='-'))
			sz[b++]=sz[a];
		if(!e && (sz[a]=='e' || sz[a]=='E'))
			e=1;
		if(!p && sz[a]=='.')
			p=1;
		if(!m && sz[a]=='-')
			m=1;
	}
	sz[b]=0;
}
int WINAPI PositionProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if(uMsg==WM_INITDIALOG){
		SendDlgItemMessage(hWnd,IDC_EDIT1,EM_SETLIMITTEXT,DECNUMDIGITS+20,0);
		SendDlgItemMessage(hWnd,IDC_EDIT3,EM_SETLIMITTEXT,DECNUMDIGITS+20,0);
		SetDlgItemText(hWnd,IDC_EDIT1,g_SFT.GetRe());
		SetDlgItemText(hWnd,IDC_EDIT3,g_SFT.GetIm());
		SetDlgItemText(hWnd,IDC_EDIT4,g_SFT.GetZoom());
		int nMin, nMax;
		g_SFT.GetIterations(nMin,nMax);
		SetDlgItemInt(hWnd,IDC_EDIT2,nMin,FALSE);
		SetDlgItemInt(hWnd,IDC_EDIT5,nMax,FALSE);
		return 1;
	}
	else if(uMsg==WM_COMMAND){
		if(wParam==IDOK){
			int n = GetWindowTextLength(GetDlgItem(hWnd,IDC_EDIT1));
			char *szR = new char[n+1];
			GetDlgItemText(hWnd,IDC_EDIT1,szR,n+1);
			FixNumber(szR);
			n = GetWindowTextLength(GetDlgItem(hWnd,IDC_EDIT3));
			char *szI = new char[n+1];
			GetDlgItemText(hWnd,IDC_EDIT3,szI,n+1);
			FixNumber(szI);
			n = GetWindowTextLength(GetDlgItem(hWnd,IDC_EDIT4));
			char *szZ = new char[n+1];
			GetDlgItemText(hWnd,IDC_EDIT4,szZ,n+1);
			FixNumber(szZ);
			g_SFT.SetPosition(szR,szI,szZ);
			delete [] szR;
			delete [] szI;
			delete [] szZ;
			EndDialog(hWnd,1);
		}
		else if(wParam==IDCANCEL)
			EndDialog(hWnd,0);
	}
	return 0;
}
/*
int g_nFrames=0;
int WINAPI ZoomProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if(uMsg==WM_INITDIALOG){
		RECT r;
		GetClientRect(GetParent(hWnd),&r);
		SetDlgItemInt(hWnd,IDC_EDIT3,r.right,0);
		return 1;
	}
	if(uMsg==WM_COMMAND){
		if(wParam==IDC_BUTTON1){
			char szFolder[256];
			GetDlgItemText(hWnd,IDC_EDIT1,szFolder,sizeof(szFolder));
			if(Browse(hWnd,szFolder,sizeof(szFolder)))
				SetDlgItemText(hWnd,IDC_EDIT1,szFolder);
		}
		else if(wParam==IDC_BUTTON3){
			int nProcent = GetDlgItemInt(hWnd,IDC_EDIT2,NULL,FALSE);
			if(!nProcent)
				return MessageBox(hWnd,"No percent given","Error",MB_OK|MB_ICONSTOP);
			SetDlgItemInt(hWnd,IDC_EDIT5,g_SFT.CountFrames(SendDlgItemMessage(hWnd,IDC_CHECK1,BM_GETCHECK,0,0)?25:nProcent),FALSE);
		}
		else if(LOWORD(wParam)==IDC_EDIT3 && HIWORD(wParam)==EN_CHANGE){
			int nHeight = GetDlgItemInt(hWnd,IDC_EDIT3,NULL,0)*360/640;
			SetDlgItemInt(hWnd,IDC_EDIT4,nHeight,0);
		}
		else if(wParam==IDOK){
			if(g_bZoomRunning){
				g_bZoomStop=TRUE;
				while(g_bZoomRunning)
					Sleep(10);
				SetDlgItemText(hWnd,IDOK,"Start");
				return 0;
			}
			char szFolder[256];
			GetDlgItemText(hWnd,IDC_EDIT1,szFolder,sizeof(szFolder));
			if(!*szFolder){
				SetFocus(GetDlgItem(hWnd,IDC_EDIT1));
				return MessageBox(hWnd,"No folder given","Error",MB_OK|MB_ICONSTOP);
			}
			int nWidth = GetDlgItemInt(hWnd,IDC_EDIT3,NULL,0);
			if(!nWidth){
				SetFocus(GetDlgItem(hWnd,IDC_EDIT3));
				return MessageBox(hWnd,"No width given","Error",MB_OK|MB_ICONSTOP);
			}
			int nHeight = GetDlgItemInt(hWnd,IDC_EDIT4,NULL,0);
			int nPercent = GetDlgItemInt(hWnd,IDC_EDIT2,NULL,0);
			if(!nPercent){
				SetFocus(GetDlgItem(hWnd,IDC_EDIT2));
				return MessageBox(hWnd,"No percent given","Error",MB_OK|MB_ICONSTOP);
			}
			g_nFrames = GetDlgItemInt(hWnd,IDC_EDIT5,NULL,0);
			if(!g_nFrames){
				SetFocus(GetDlgItem(hWnd,IDC_EDIT5));
				return MessageBox(hWnd,"No frames given","Error",MB_OK|MB_ICONSTOP);
			}
			BOOL bKfr = SendDlgItemMessage(hWnd,IDC_CHECK1,BM_GETCHECK,0,0);
			char szParams[256];
			strcpy(szParams,szFolder);
			if(szParams[strlen(szParams)-1]!='\\')
				strcat(szParams,"\\");
			strcat(szParams,"Parameters.kfz");
			DWORD dw;
			if(g_SFT.SaveFile(szParams)){
				CStringTable stParameters;
				stParameters.AddRow();
				stParameters.AddString(stParameters.GetCount()-1,"Folder");
				stParameters.AddString(stParameters.GetCount()-1,szFolder);
				stParameters.AddRow();
				stParameters.AddString(stParameters.GetCount()-1,"Width");
				stParameters.AddInt(stParameters.GetCount()-1,nWidth);
				stParameters.AddRow();
				stParameters.AddString(stParameters.GetCount()-1,"Height");
				stParameters.AddInt(stParameters.GetCount()-1,nHeight);
				stParameters.AddRow();
				stParameters.AddString(stParameters.GetCount()-1,"Frames");
				stParameters.AddInt(stParameters.GetCount()-1,g_nFrames);
				stParameters.AddRow();
				stParameters.AddString(stParameters.GetCount()-1,"Percent");
				stParameters.AddInt(stParameters.GetCount()-1,nPercent);
				stParameters.AddRow();
				stParameters.AddString(stParameters.GetCount()-1,"Kfr");
				stParameters.AddInt(stParameters.GetCount()-1,bKfr);
				HANDLE hFile = CreateFile(szParams,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,0,NULL);
				if(hFile==INVALID_HANDLE_VALUE)
					return MessageBox(hWnd,"Could not write in given folder","Error",MB_OK|MB_ICONSTOP);
				SetFilePointer(hFile,0,NULL,FILE_END);
				char *szParameters = stParameters.ToText(": ","\r\n");
				WriteFile(hFile,szParameters,strlen(szParameters),&dw,NULL);
				CloseHandle(hFile);
				stParameters.DeleteToText(szParameters);
			}
			SetDlgItemText(hWnd,IDOK,"Stop");
			SetTimer(hWnd,0,500,NULL);
			RENDER_FRAKTAL *prf = new RENDER_FRAKTAL;
			char *sz = g_SFT.GetPosition();
			CStringTable stP(sz,":","\n");
			prf->rstart = stP[stP.FindString(0,"R-Start")][1];
			prf->rstop = stP[stP.FindString(0,"R-Stop")][1];
			prf->istart = stP[stP.FindString(0,"I-Start")][1];
			prf->istop = stP[stP.FindString(0,"I-Stop")][1];
			prf->nFrames = g_nFrames;
			prf->nProcent = (bKfr?25:nPercent);
			prf->nMaxIter = g_SFT.GetIterations();
			prf->r.left=prf->r.top=0;
			prf->r.right = nWidth;
			prf->r.bottom = nHeight;
			prf->hWnd = hWnd;
			prf->kfrParts = (int)(bKfr?(0.5 + log10(1.5)/log10(1 + 2*(double)nPercent/100)):0);
			if(prf->kfrParts<1 && bKfr)
				prf->kfrParts=2;
			strcpy(prf->szFileName,szFolder);
			if(prf->szFileName[strlen(prf->szFileName)-1]!='\\')
				strcat(prf->szFileName,"\\");
			strcat(prf->szFileName,"000000.jpg");
			prf->bCheckZoom=TRUE;
			g_bZoomRunning=TRUE;
			g_bZoomStop=FALSE;
			HANDLE hThread = CreateThread(NULL,150000000,(LPTHREAD_START_ROUTINE)RenderFraktal,(LPVOID)prf,0,&dw);
			CloseHandle(hThread);
//			g_SFT.CreateZoomSequence(szFolder,nWidth,nHeight,g_nFrames,nPercent);
		}
		else if(wParam==IDC_BUTTON4){
			static char szFile[256]={0};
			if(BrowseFile(hWnd,TRUE,"Open Incomplete Zoom Sequence","Zoom parameters\0*.kfz\0",szFile,sizeof(szFile))){
				DWORD dw;
				HANDLE hFile = CreateFile(szFile,GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
				if(hFile==INVALID_HANDLE_VALUE)
					return MessageBox(hWnd,"Could not open file","Error",MB_OK|MB_ICONSTOP);
				int nLen = GetFileSize(hFile,NULL);
				char *szData = new char[nLen+1];
				ReadFile(hFile,szData,nLen,&dw,NULL);
				CloseHandle(hFile);
				szData[nLen]=0;
				CStringTable stParameters(szData,": ","\r\n");
				delete [] szData;
				SetDlgItemText(hWnd,IDC_EDIT1,stParameters[stParameters.FindString(0,"Folder")][1]);
				SetDlgItemText(hWnd,IDC_EDIT2,stParameters[stParameters.FindString(0,"Percent")][1]);
				SetDlgItemText(hWnd,IDC_EDIT5,stParameters[stParameters.FindString(0,"Frames")][1]);
				SetDlgItemText(hWnd,IDC_EDIT3,stParameters[stParameters.FindString(0,"Width")][1]);
				SetDlgItemText(hWnd,IDC_EDIT4,stParameters[stParameters.FindString(0,"Height")][1]);
				SendDlgItemMessage(hWnd,IDC_CHECK1,BM_SETCHECK,atoi(stParameters[stParameters.FindString(0,"Kfr")][1]),0);
				if(g_hwColors)
					SendMessage(g_hwColors,WM_USER+99,0,0);
				g_SFT.OpenFile(szFile);
			}
		}
		else if(wParam==IDCANCEL){
			if(g_bZoomRunning){
				g_bZoomStop=TRUE;
				while(g_bZoomRunning)
					Sleep(10);
			}
			EndDialog(hWnd,0);
		}
	}
	else if(uMsg==WM_TIMER){
		char szDisplay[256];
		static char szPrev[256]="";
		wsprintf(szDisplay,"%d%% G:%d%% (%d of %d) %s",g_nDone*100/(g_nMax?g_nMax:1),g_nGuessed*100/(!g_nDone?1:g_nDone),g_nFrameDone,g_nFrameMax,g_pszStatus[g_nStatus]);
		if(strcmp(szDisplay,szPrev)){
			strcpy(szPrev,szDisplay);
			SetDlgItemText(hWnd,IDC_EDIT6,szDisplay);
		}
	}
/*	else if(uMsg==WM_TIMER){
		static char szPev[256]={0};
		char szStatus[256];
		if(g_nFrames==g_SFT.GetFramesDone()){
			strcpy(szStatus,"Done");
			g_bZoomRunning=FALSE;
			SetDlgItemText(hWnd,IDOK,"Start");
		}
		else
			wsprintf(szStatus,"Frame %d (%s)",g_SFT.GetFramesDone(),g_SFT.GetZoomStatus());
		if(strcmp(szPev,szStatus)){
			strcpy(szPev,szStatus);
			SetDlgItemText(hWnd,IDC_EDIT6,szStatus);
		}
	}
	return 0;
}
*/
struct JPEG_PARAMS
{
	int nWidth;
	int nHeight;
	int nQuality;
}g_JpegParams;
int WINAPI JpegProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if(uMsg==WM_INITDIALOG){
		SetDlgItemInt(hWnd,IDC_EDIT1,g_JpegParams.nWidth,0);
		SetDlgItemInt(hWnd,IDC_EDIT3,g_JpegParams.nHeight,0);
		if(lParam){
			ShowWindow(GetDlgItem(hWnd,IDC_EDIT4),FALSE);
			ShowWindow(GetDlgItem(hWnd,IDC_QUALITY_LABEL),FALSE);
			SetWindowText(hWnd,"Size");
		}
		else
			SetDlgItemInt(hWnd,IDC_EDIT4,g_JpegParams.nQuality,0);
		return 1;
	}
	else if(uMsg==WM_COMMAND){
		if(wParam==IDCANCEL)
			EndDialog(hWnd,0);
		else if(wParam==IDOK){
			g_JpegParams.nWidth = GetDlgItemInt(hWnd,IDC_EDIT1,NULL,0);
			g_JpegParams.nHeight = GetDlgItemInt(hWnd,IDC_EDIT3,NULL,0);
			g_JpegParams.nQuality = GetDlgItemInt(hWnd,IDC_EDIT4,NULL,0);
			EndDialog(hWnd,1);
		}
		else if(LOWORD(wParam)==IDC_EDIT1 && HIWORD(wParam)==EN_CHANGE){
			int nHeight = GetDlgItemInt(hWnd,IDC_EDIT1,NULL,0)*360/640;
			SetDlgItemInt(hWnd,IDC_EDIT3,nHeight,0);
		}
	}
	return 0;
}
int FileExists(char *szFind)
{
	WIN32_FIND_DATA wf;
	HANDLE hFind = FindFirstFile(szFind,&wf);
	if(hFind==INVALID_HANDLE_VALUE)
		return 0;
	FindClose(hFind);
	return 1;
}
struct ANIM
{
	HBITMAP bmBmp;
	HWND hWnd;
	POINT pOffs;
};
int g_nAnim=0;
BOOL g_bAnim=FALSE;
int WINAPI ThAnim(ANIM *pAnim)
{
	int nParts = 30;
	g_bAnim=TRUE;
	int pMyID = InterlockedIncrement((LPLONG)&g_nAnim);
	HDC hDC = GetDC(pAnim->hWnd);
	HDC dcBmp = CreateCompatibleDC(hDC);
	HBITMAP bmOld = (HBITMAP)SelectObject(dcBmp,pAnim->bmBmp);
	double exp = 1;
	double mul = pow(10,log10((double)g_nZoomSize)/(nParts));
	RECT r;
	GetClientRect(pAnim->hWnd,&r);
	RECT sr;
	GetWindowRect(g_hwStatus,&sr);
	sr.bottom-=sr.top;
	r.bottom-=sr.bottom;
	int nToXStart = pAnim->pOffs.x-r.right/(g_nZoomSize*2);
	int nToYStart = pAnim->pOffs.y-r.bottom/(g_nZoomSize*2);
	int nToXStop = r.right - (pAnim->pOffs.x+r.right/(g_nZoomSize*2));
	int nToYStop = r.bottom - (pAnim->pOffs.y+r.bottom/(g_nZoomSize*2));
	double nCX = (double)(pAnim->pOffs.x-r.right/2)/(double)nParts;
	double nCY = (double)(pAnim->pOffs.y-r.bottom/2)/(double)nParts;
	int nMX = r.right/2 + (pAnim->pOffs.x-r.right/2);
	int nMY = r.bottom/2 + (pAnim->pOffs.y-r.bottom/2);
	int k;
	double nCXOffs=0;
	double nCYOffs=0;
	for(k=0;pMyID==g_nAnim && k<nParts;k++){
		nCXOffs+=nCX;
		nCYOffs+=nCY;
		nMX = r.right/2 + (int)nCXOffs;
		nMY = r.bottom/2 + (int)nCYOffs;
		int nXOffs = (int)(exp*r.right/2+.5);
		int nYOffs = (int)(exp*r.bottom/2+.5);
		exp/=mul;
		if(nXOffs<3)
			break;
		StretchBlt(hDC,0,0,r.right,r.bottom,dcBmp,nMX-nXOffs,nMY-nYOffs,2*nXOffs,2*nYOffs,SRCCOPY);
		Sleep(33);
	}
	SelectObject(dcBmp,bmOld);
	DeleteDC(dcBmp);
	ReleaseDC(pAnim->hWnd,hDC);
	DeleteObject(pAnim->bmBmp);
	if(pMyID==g_nAnim)
		g_bAnim=FALSE;
	delete pAnim;
	return 0;
}
int g_nPrevAutoGlitchNP;
BOOL g_bAutoSolveGlitch=FALSE;
int WINAPI ExamineProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if(uMsg==WM_INITDIALOG){
		g_nPrevAutoGlitchNP=g_bAutoGlitchNP;
		g_bAutoGlitchNP=FALSE;
		CheckMenuItem(GetMenu(GetParent(hWnd)),ID_ACTIONS_SPECIAL_SOLVEGLITCHWITHNEARPIXELSMETHOD,MF_BYCOMMAND|(g_bAutoGlitchNP?MF_CHECKED:MF_UNCHECKED));
		g_bAddReference=TRUE;
		g_bEraser=FALSE;
		g_stExamine.Reset();
		SendDlgItemMessage(hWnd,IDC_RADIO1,BM_SETCHECK,1,0);
		WIN32_FIND_DATA fd;
		char szExamine[256];
		strcpy(szExamine,g_szExamine);
		char *sz = strrchr(szExamine,'\\');
		if(sz)
			strcpy(sz+1,"*_*.kfb");
		HANDLE hFind = FindFirstFile(szExamine,&fd);
		if(!sz || hFind==INVALID_HANDLE_VALUE){
			if(hFind)
				FindClose(hFind);
			MessageBox(hWnd,"Could not browse kfb files","Error",MB_OK|MB_ICONSTOP);
			DestroyWindow(hWnd);
			g_hwExamine=NULL;
			return 0;
		}
		do{
			strcpy(strrchr(szExamine,'\\')+1,fd.cFileName);
			g_stExamine.AddRow();
			g_stExamine.AddString(g_stExamine.GetCount()-1,szExamine);
		}while(FindNextFile(hFind,&fd));
		FindClose(hFind);
		g_stExamine.M3QSort(0,1);
		g_SFT.OpenFile(g_szExamine);
		g_SFT.OpenMapB(g_stExamine[0][0]);
		g_SFT.ApplyColors();
		g_nExamine=0;
		SetDlgItemInt(hWnd,IDC_EDIT1,g_nExamine,FALSE);
		g_bExamineDirty=FALSE;
		char *szA = strrchr(g_stExamine[0][0],'_');
		szA++;
		strcpy(szExamine,szA);
		*strrchr(szExamine,'.')=0;
		CDecNumber A(szExamine);
		szA = strrchr(g_stExamine[1][0],'_');
		szA++;
		strcpy(szExamine,szA);
		*strrchr(szExamine,'.')=0;
		CDecNumber B(szExamine);
		g_nExamineZoom = (B/A+CDecNumber(0.5)).ToInt();
		A = CDecNumber(g_SFT.GetZoom())/(CDecNumber(g_nExamineZoom)^(g_stExamine.GetCount()-g_nExamine-1));
		char *szR = g_SFT.GetRe();
		char *szRe = new char[strlen(szR)+1];
		strcpy(szRe,szR);
		char *szI = g_SFT.GetIm();
		char *szIm = new char[strlen(szI)+1];
		strcpy(szIm,szI);
		g_SFT.SetPosition(szRe,szIm,A.ToText());
		delete szRe;
		delete szIm;

		PostMessage(GetParent(hWnd),WM_USER+199,0,0);
		SetTimer(hWnd,0,100,NULL);
	}
	else if(uMsg==WM_COMMAND){
		if(wParam==IDCANCEL){
			DestroyWindow(hWnd);
			g_hwExamine=NULL;
			g_bAutoGlitchNP=g_nPrevAutoGlitchNP;
			CheckMenuItem(GetMenu(GetParent(hWnd)),ID_ACTIONS_SPECIAL_SOLVEGLITCHWITHNEARPIXELSMETHOD,MF_BYCOMMAND|(g_bAutoGlitchNP?MF_CHECKED:MF_UNCHECKED));
		}
		else if(wParam==IDOK || wParam==IDC_BUTTON1 || wParam==IDC_BUTTON2 || wParam==IDC_BUTTON5){
			SetDlgItemText(hWnd,IDC_EDIT3,"Reading...");
			g_SFT.Stop();
			KillTimer(hWnd,1);
			if(wParam!=IDC_BUTTON2 && g_bExamineDirty){
				g_SFT.SaveMapB(g_stExamine[g_nExamine][0]);
				char szFile[256];
				strcpy(szFile,g_stExamine[g_nExamine][0]);
				strcpy(strrchr(szFile,'.'),".jpg");
				if(FileExists(szFile))
					g_SFT.SaveJpg(szFile,99);
			}
			if(wParam==IDC_BUTTON5)
				g_bExamineDirty=TRUE;
			else
				g_bExamineDirty=FALSE;
			if(wParam==IDOK){
				g_nExamine++;
				if(g_nExamine>g_stExamine.GetCount()-1)
					g_nExamine=0;
			}
			else if(wParam==IDC_BUTTON1 || wParam==IDC_BUTTON5){
				g_nExamine--;
				if(g_nExamine<0){
					wParam=IDC_BUTTON1;
					g_nExamine=g_stExamine.GetCount()-1;
					g_bExamineDirty=FALSE;
				}
			}
			SetDlgItemInt(hWnd,IDC_EDIT1,g_nExamine,FALSE);
			UpdateWindow(GetDlgItem(hWnd,IDC_EDIT1));
			g_SFT.OpenMapB(g_stExamine[g_nExamine][0],wParam==IDC_BUTTON5,(double)1/g_nExamineZoom);
			g_SFT.ApplyColors();
			if(wParam!=IDC_BUTTON2)
				SetTimer(hWnd,1,500,NULL);
			InvalidateRect(GetParent(hWnd),NULL,FALSE);
			UpdateWindow(GetParent(hWnd));
//			SetCapture(hWnd);
			g_bWaitRead=TRUE;
		}
		else if(wParam==IDC_BUTTON3){
			SetDlgItemText(hWnd,IDC_EDIT3,"Reading...");
			g_SFT.Stop();
			KillTimer(hWnd,1);
			g_nExamine = GetDlgItemInt(hWnd,IDC_EDIT1,NULL,FALSE);
			if(g_nExamine<0)
				g_nExamine=0;
			else if(g_nExamine>=g_stExamine.GetCount())
				g_nExamine = g_stExamine.GetCount()-1;
			g_SFT.OpenMapB(g_stExamine[g_nExamine][0],wParam==IDC_BUTTON5,(double)1/g_nExamineZoom);
			g_SFT.ApplyColors();
			SetTimer(hWnd,1,500,NULL);
			InvalidateRect(GetParent(hWnd),NULL,FALSE);
			UpdateWindow(GetParent(hWnd));
			g_bWaitRead=TRUE;
		}
		else if(wParam==IDC_BUTTON4){
			if(!g_bAutoSolveGlitch)
				SetTimer(hWnd,2,10,NULL);
			g_bAutoSolveGlitch = !g_bAutoSolveGlitch;
			if(g_bAutoSolveGlitch)
				SetDlgItemText(hWnd,IDC_BUTTON4,"Stop Auto solve glitch");
			else{
				SetDlgItemText(hWnd,IDC_EDIT4,"");
				SetDlgItemText(hWnd,IDC_BUTTON4,"Auto solve glitch");
			}
		}
		else if(wParam==IDC_RADIO1){
			g_bAddReference=TRUE;
			g_bAddMainReference=FALSE;
			g_bEraser=FALSE;
			EnableWindow(GetDlgItem(hWnd,IDC_CHECK1),TRUE);
		}
		else if(wParam==IDC_RADIO2){
			g_bAddReference=FALSE;
			g_bAddMainReference=TRUE;
			g_bEraser=FALSE;
			EnableWindow(GetDlgItem(hWnd,IDC_CHECK1),FALSE);
		}
		else if(wParam==IDC_RADIO3){
			g_bEraser=TRUE;
			g_bAddReference=FALSE;
			g_bAddMainReference=FALSE;
			EnableWindow(GetDlgItem(hWnd,IDC_CHECK1),FALSE);
		}
		else if(wParam==IDC_CHECK1){
			g_bAutoGlitchNP=!g_bAutoGlitchNP;
			CheckMenuItem(GetMenu(GetParent(hWnd)),ID_ACTIONS_SPECIAL_SOLVEGLITCHWITHNEARPIXELSMETHOD,MF_BYCOMMAND|(g_bAutoGlitchNP?MF_CHECKED:MF_UNCHECKED));
		}
	}
	else if(uMsg==WM_TIMER && wParam==0)
		SetDlgItemText(hWnd,IDC_EDIT2,g_bExamineDirty?"Changed":"");
	else if(uMsg==WM_TIMER && wParam==1){
		g_bWaitRead=FALSE;
		SetDlgItemText(hWnd,IDC_EDIT3,"");
		KillTimer(hWnd,1);
		ReleaseCapture();
		int nMI = g_SFT.GetIterations();
		g_SFT.OpenFile(g_szExamine);
		g_SFT.SetIterations(nMI);
		CDecNumber A = CDecNumber(g_SFT.GetZoom())/(CDecNumber(g_nExamineZoom)^(g_stExamine.GetCount()-g_nExamine-1));
		char *szR = g_SFT.GetRe();
		char *szRe = new char[strlen(szR)+1];
		strcpy(szRe,szR);
		char *szI = g_SFT.GetIm();
		char *szIm = new char[strlen(szI)+1];
		strcpy(szIm,szI);
		g_SFT.SetPosition(szRe,szIm,A.ToText());
		delete szRe;
		delete szIm;

		PostMessage(GetParent(hWnd),WM_USER+199,0,0);
	}
	else if(uMsg==WM_TIMER && wParam==2){
		KillTimer(hWnd,2);
		if(!g_bAutoSolveGlitch)
			return 0;
SetDlgItemText(hWnd,IDC_EDIT4,"AutoSolveGlitch");
UpdateWindow(GetDlgItem(hWnd,IDC_EDIT4));
		int rx, ry;
SetDlgItemText(hWnd,IDC_EDIT4,"Search for glitch");
UpdateWindow(GetDlgItem(hWnd,IDC_EDIT4));
		while(!g_SFT.FindCenterOfGlitch(rx,ry) || g_bAutoSolveGlitch>=11){
			if(g_nExamine==0){
				g_bAutoSolveGlitch=0;
				SetDlgItemText(hWnd,IDC_BUTTON4,"Auto solve glitch");
SetDlgItemText(hWnd,IDC_EDIT4,"Done");
UpdateWindow(GetDlgItem(hWnd,IDC_EDIT4));
				return 0;
			}
			if(g_bAutoSolveGlitch>1){
SetDlgItemText(hWnd,IDC_EDIT4,"No more glitch found - save and previous");
UpdateWindow(GetDlgItem(hWnd,IDC_EDIT4));
				SendMessage(hWnd,WM_COMMAND,IDC_BUTTON5,0);
			}
			else{
SetDlgItemText(hWnd,IDC_EDIT4,"No glitch found - previous");
UpdateWindow(GetDlgItem(hWnd,IDC_EDIT4));
				SendMessage(hWnd,WM_COMMAND,IDC_BUTTON1,0);
			}
			KillTimer(hWnd,1);
			g_bAutoSolveGlitch=1;
		}
		if(g_bAutoSolveGlitch==1){
SetDlgItemText(hWnd,IDC_EDIT4,"First glitch found - read location");
UpdateWindow(GetDlgItem(hWnd,IDC_EDIT4));
			int nMI = g_SFT.GetIterations();
			g_SFT.OpenFile(g_szExamine);
			g_SFT.SetIterations(nMI);
			CDecNumber A = CDecNumber(g_SFT.GetZoom())/(CDecNumber(g_nExamineZoom)^(g_stExamine.GetCount()-g_nExamine-1));
			char *szR = g_SFT.GetRe();
			char *szRe = new char[strlen(szR)+1];
			strcpy(szRe,szR);
			char *szI = g_SFT.GetIm();
			char *szIm = new char[strlen(szI)+1];
			strcpy(szIm,szI);
			g_SFT.SetPosition(szRe,szIm,A.ToText());
			delete szRe;
			delete szIm;
		}

char szAdd[128];
wsprintf(szAdd,"Add reference %d",g_bAutoSolveGlitch);
SetDlgItemText(hWnd,IDC_EDIT4,szAdd);
UpdateWindow(GetDlgItem(hWnd,IDC_EDIT4));
		g_SFT.AddReference(rx,ry);
		g_bAutoSolveGlitch++;
		SetTimer(GetParent(hWnd),0,500,NULL);
		g_bExamineDirty=TRUE;
	}
	else if(uMsg==WM_USER+199 && g_bAutoSolveGlitch){
		SendMessage(hWnd,WM_TIMER,2,0);
	}
	return 0;
}
int ResumeZoomSequence(HWND hWnd)
{
	memset(g_szFile,0,sizeof(g_szFile));
	if(!BrowseFile(hWnd,TRUE,"Open location","Kalles fraktaler\0*.kfr\0",g_szFile,sizeof(g_szFile)))
		return 0;
	if(!g_SFT.OpenFile(g_szFile))
		return MessageBox(hWnd,"Could not open file","Error",MB_OK|MB_ICONSTOP);
	g_SFT.StoreLocation();
	char *sz = strrchr(g_szFile,'\\');
	if(sz)
		strcpy(sz+1,"*_*.jpg");
	WIN32_FIND_DATA fd;
	HANDLE hFind = FindFirstFile(g_szFile,&fd);
	if(hFind!=INVALID_HANDLE_VALUE){
		g_bStoreZoomJpg=1;
		FindClose(hFind);
	}
	else
		g_bStoreZoomJpg=0;

	if(sz)
		strcpy(sz+1,"*_*.kfb");
	hFind = FindFirstFile(g_szFile,&fd);
	if(!sz || hFind==INVALID_HANDLE_VALUE){
		if(hFind)
			FindClose(hFind);
		return MessageBox(hWnd,"Could not browse kfb files","Error",MB_OK|MB_ICONSTOP);
	}
	CStringTable stExamine;
	do{
		strcpy(strrchr(g_szFile,'\\')+1,fd.cFileName);
		stExamine.AddRow();
		stExamine.AddString(stExamine.GetCount()-1,g_szFile);
		stExamine.AddString(stExamine.GetCount()-1,fd.cFileName);
	}while(FindNextFile(hFind,&fd));
	FindClose(hFind);
	stExamine.M3QSort(0,1);
	g_SFT.OpenMapB(stExamine[0][0]);
	char *szA = strrchr(stExamine[0][0],'_');
	szA++;
	strcpy(g_szExamine,szA);
	*strrchr(g_szExamine,'.')=0;
	CDecNumber A(g_szExamine);
	szA = strrchr(stExamine[1][0],'_');
	szA++;
	strcpy(g_szExamine,szA);
	*strrchr(g_szExamine,'.')=0;
	CDecNumber B(g_szExamine);
	g_nZoomSize = (B/A+CDecNumber(0.5)).ToInt();
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_2,MF_BYCOMMAND|(g_nZoomSize==2?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_4,MF_BYCOMMAND|(g_nZoomSize==4?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_8,MF_BYCOMMAND|(g_nZoomSize==8?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_16,MF_BYCOMMAND|(g_nZoomSize==16?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_32,MF_BYCOMMAND|(g_nZoomSize==32?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_64,MF_BYCOMMAND|(g_nZoomSize==64?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_128,MF_BYCOMMAND|(g_nZoomSize==128?MF_CHECKED:MF_UNCHECKED));
	A = CDecNumber(g_SFT.GetZoom())/(CDecNumber(g_nZoomSize)^(stExamine.GetCount()));
	char *szR = g_SFT.GetRe();
	char *szRe = new char[strlen(szR)+1];
	strcpy(szRe,szR);
	char *szI = g_SFT.GetIm();
	char *szIm = new char[strlen(szI)+1];
	strcpy(szIm,szI);
	g_SFT.SetPosition(szRe,szIm,A.ToText());
	delete szRe;
	delete szIm;

	g_bStoreZoom=atoi(stExamine[0][1])+1;
	SetTimer(hWnd,0,500,NULL);
	g_JpegParams.nWidth = g_SFT.GetWidth();
	g_JpegParams.nHeight = g_SFT.GetHeight();
	g_JpegParams.nQuality = 99;
	g_SFT.RenderFractal(g_SFT.GetWidth(),g_SFT.GetHeight(),g_SFT.GetIterations(),hWnd);
	return 0;
}
int HandleDone(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam,int &nPos)
{
nPos=0;
		if(!wParam && uMsg==WM_USER+199){
			g_SFT.ApplyColors();
			InvalidateRect(hWnd,NULL,FALSE);
		}

		int nG, nR;
		int nP = g_SFT.GetProgress(&nG,&nR);
nPos=1;
		char szTmp[154];
		wsprintf(szTmp,"%d%% R:%d%% G:%d%%",nP,nR,nG);
		SendMessage(g_hwStatus,SB_SETTEXT,0,(LPARAM)szTmp);
nPos=2;
		if(!g_hwExamine && uMsg==WM_USER+199 && !wParam){
nPos=3;
			if(g_bAutoGlitch && g_bAutoGlitch++<OLD_GLITCH){
nPos=4;
				int x, y;

				if(g_SFT.FindCenterOfGlitch(x, y,g_bAutoGlitchNP)){
nPos=5;
					if(g_nPrevGlitchX!=x || g_nPrevGlitchY!=y){
nPos=6;
						if(g_SFT.AddReference(x, y,FALSE,g_bAutoGlitchNP,g_bAutoGlitch==OLD_GLITCH)){
nPos=7;
							return 0;
						}
					}
				}
				else
					g_bAutoGlitch--;
nPos=8;
			}
		}
		if(g_hwExamine && uMsg==WM_USER+199)
			PostMessage(g_hwExamine,uMsg,wParam,lParam);
		SYSTEMTIME st;
		__int64 nTStop;
		GetLocalTime(&st);
		SystemTimeToFileTime(&st,(LPFILETIME)&nTStop);
		nTStop-=g_nTStart;
		FileTimeToSystemTime((LPFILETIME)&nTStop,&st);
		if(st.wDay>1)
			st.wHour+=(st.wDay-1)*24;
		wsprintf(szTmp,"Zoom:%s T:%02d:%02d:%02d.%03d %s",g_SFT.ToZoom(),st.wHour,st.wMinute,st.wSecond,st.wMilliseconds,uMsg==WM_USER+199?"Done":"");
nPos=9;
		if(g_bAutoGlitch){
			wsprintf(szTmp+strlen(szTmp)," Ref: %d",g_bAutoGlitch);
			if(uMsg==WM_USER+199){
				g_bAutoGlitch=1;
			}
		}
nPos=10;
		SendMessage(g_hwStatus,SB_SETTEXT,1,(LPARAM)szTmp);
		if(!g_bAnim)
			InvalidateRect(hWnd,NULL,FALSE);
nPos=11;
		if(uMsg==WM_USER+199){
			g_nAnim++;
			KillTimer(hWnd,0);
			InvalidateRect(hWnd,NULL,FALSE);
			UpdateWindow(hWnd);
nPos=12;
			if(g_bFindMinibrot)
				PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_FINDMINIBROT,0);
			if(g_bStoreZoom){
nPos=13;
				char *szZ = g_SFT.ToZoom();
				if(g_bStoreZoomJpg){
					wsprintf(strrchr(g_szFile,'\\')+1,"%05d_%s.jpg",g_bStoreZoom,szZ);
					g_SFT.SaveJpg(g_szFile,g_JpegParams.nQuality);
				}
				wsprintf(strrchr(g_szFile,'\\')+1,"%05d_%s.kfb",g_bStoreZoom,szZ);
				g_SFT.SaveMapB(g_szFile);
nPos=14;
				g_bStoreZoom++;
				if(*szZ=='0')
					g_bStoreZoom=FALSE;
				else{
					int nMin,nMax;
					g_SFT.GetIterations(nMin,nMax);
					if(nMax<g_SFT.GetIterations()/5)
						g_SFT.SetIterations(nMax*5);
					g_SFT.Zoom(g_JpegParams.nWidth/2,g_JpegParams.nHeight/2,1/(double)g_nZoomSize,g_JpegParams.nWidth,g_JpegParams.nHeight,TRUE/*!g_bAutoGlitch*/);
					SetTimer(hWnd,0,500,NULL);
					return 0;
				}
nPos=15;
			}
			if(g_bFirstDone){
nPos=16;
				if(!g_LDBL)
					MessageBox(hWnd,"The library "
#ifdef _WIN64
					"ldbl64.dll"
#else
					"ldbl.dll"
#endif
					" could not be loaded. You may continue to use this application, but the speed of rendering images on depths between 1e600 and 1e4900 will be significantly slower without this library","Missing file",MB_OK|MB_ICONWARNING);

nPos=17;
				if(g_LDBL==2){
					MessageBox(hWnd,"The library "
#ifdef _WIN64
					"ldbl64.dll"
#else
					"ldbl.dll"
#endif
					" is old. Please update this file.","Old file",MB_OK|MB_ICONWARNING);
				}
				g_bFirstDone=FALSE;
nPos=18;
				HANDLE hFile = CreateFile(g_szRecovery,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,0,OPEN_EXISTING,0,NULL);
				if(hFile!=INVALID_HANDLE_VALUE && MessageBox(hWnd,"Kalles Fraktaler was not closed properly last session. Do you want to recover your last location?","Kalles Fraktaler",MB_YESNO)==IDYES){
nPos=19;
					CloseHandle(hFile);
					g_SFT.Stop();
					g_SFT.OpenFile(g_szRecovery);
					PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
				}
				else if(hFile!=INVALID_HANDLE_VALUE)
					CloseHandle(hFile);
nPos=20;
			}
			else{
nPos=21;
				g_SFT.SaveFile(g_szRecovery);
			}
			
nPos=22;
			g_SFT.ApplyColors();
			if(g_bSaveJpeg){
				g_bSaveJpeg=FALSE;
nPos=23;
				char szFile[256]={0};
				if(BrowseFile(hWnd,FALSE,"Save as Jpeg","Jpeg\0*.jpg\0",szFile,sizeof(szFile))){
					if(!g_SFT.SaveJpg(szFile,g_JpegParams.nQuality))
						MessageBox(hWnd,"File could not be saved","Error",MB_OK|MB_ICONSTOP);
					PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
				}
			}
/*			int nMin, nMax;
			g_SFT.GetIterations(nMin,nMax);
			if(nMax<g_SFT.GetIterations())
				g_SFT.SetIterations(nMax+nMax/3);
*/		}
nPos=24;
	return 0;
}
int HandleDoneSEH(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	int nPos=0;
	__try{
		return HandleDone(hWnd,uMsg,wParam,lParam,nPos);
	}__except(1){
	}
	return 0;
}

long WINAPI MainProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if(uMsg==WM_CREATE){
		g_hwStatus = CreateStatusWindow(WS_CHILD|WS_VISIBLE,"",hWnd,0);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		int widths[3]={120,351,-1};
		SendMessage(g_hwStatus,SB_SETPARTS,3,(LPARAM)&widths);
		SendMessage(g_hwStatus,SB_SETTEXT,0,(LPARAM)"");
		SendMessage(g_hwStatus,SB_SETTEXT,1,(LPARAM)"1");
		SendMessage(g_hwStatus,SB_SETTEXT,2,(LPARAM)"");
		RECT wr, cr;
		GetWindowRect(hWnd,&wr);
		wr.right-=wr.left;
		wr.bottom-=wr.top;
		GetClientRect(hWnd,&cr);
		int nXOffs = 640-cr.right;
		wr.right+=nXOffs;
		int nYOffs = 360-cr.bottom;
		wr.bottom+=nYOffs+sr.bottom;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_4,MF_BYCOMMAND|MF_CHECKED);

		RECT r;
		GetClientRect(GetDesktopWindow(),&r);
		MoveWindow(hWnd,r.right/2-wr.right/2,r.bottom/2-wr.bottom/2,wr.right,wr.bottom,TRUE);
		g_SFT.SetPosition((CFixedFloat)-2,(CFixedFloat)2,(CFixedFloat)-2,(CFixedFloat)2,640,360);
		SetTimer(hWnd,0,500,NULL);
		SYSTEMTIME st;
		GetLocalTime(&st);
		SystemTimeToFileTime(&st,(LPFILETIME)&g_nTStart);

		g_hwHair = CreateDialog(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG4),hWnd,(DLGPROC)CrossHairProc);
		GetWindowRect(hWnd,&wr);
		GetWindowRect(g_hwHair,&r);
		r.right-=r.left;
		r.bottom-=r.top;
		MoveWindow(g_hwHair,wr.left-r.right-3,wr.top,128,144,TRUE);
		PostMessage(g_hwHair,WM_USER+112,0,0);
		ShowWindow(g_hwHair,SW_SHOWNA);

		g_SFT.GenerateColors(g_SFT.GetNumOfColors(),1);
		g_SFT.ApplyColors();
		g_SFT.RenderFractal(640,360,g_SFT.GetIterations(),hWnd);
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_AUTOSOLVEGLITCHES,MF_BYCOMMAND|(g_bAutoGlitch?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_AUTOITERATION,MF_BYCOMMAND|(g_bAutoIterations?MF_CHECKED:MF_UNCHECKED));
	}
	else if(uMsg==WM_CLOSE)
		PostQuitMessage(0);
	else if(uMsg==WM_PAINT){
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		PAINTSTRUCT ps;
		BeginPaint(hWnd,&ps);
		SetStretchBltMode(ps.hdc,HALFTONE);
		HDC dcBmp = CreateCompatibleDC(ps.hdc);
		HBITMAP bmBmp = g_SFT.GetBitmap();
		HBITMAP bmOld = (HBITMAP)SelectObject(dcBmp,bmBmp);
		RECT rc;
		GetClientRect(hWnd,&rc);
		rc.bottom-=sr.bottom;
		StretchBlt(ps.hdc,0,0,rc.right,rc.bottom,dcBmp,0,0,g_SFT.GetWidth(),g_SFT.GetHeight(),SRCCOPY);
		SelectObject(dcBmp,bmOld);
		DeleteDC(dcBmp);
		EndPaint(hWnd,&ps);
		return 0;
	}
	else if(uMsg==WM_LBUTTONDOWN){
		if(g_bWaitRead)
			return 0;
		MSG msg;
		int nButtons=0;
		g_SFT.Stop();
		while(PeekMessage(&msg,hWnd,WM_LBUTTONDOWN,WM_LBUTTONDOWN,PM_REMOVE)){
			nButtons++;
			Sleep(10);
		}
		g_bFindMinibrot=FALSE;
		g_bStoreZoom=FALSE;
		InvalidateRect(hWnd,NULL,FALSE);
		UpdateWindow(hWnd);
		RECT rc;
		GetClientRect(hWnd,&rc);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		rc.bottom-=sr.bottom;
		HDC hDC = GetDC(hWnd);
		SetROP2(hDC,R2_NOT);
		g_pSelect.x = (short)LOWORD(lParam);
		g_pSelect.y = (short)HIWORD(lParam);
		MoveToEx(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2),NULL);
		LineTo(hDC,g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2));
		LineTo(hDC,g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2));
		LineTo(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2));
		LineTo(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2));
		ReleaseDC(hWnd,hDC);
		g_bSelect=1;
		SetCapture(hWnd);
	}
	else if(uMsg==WM_MOUSEMOVE){
		if(g_bSelect){
			RECT rc;
			GetClientRect(hWnd,&rc);
			RECT sr;
			GetWindowRect(g_hwStatus,&sr);
			sr.bottom-=sr.top;
			rc.bottom-=sr.bottom;
			HDC hDC = GetDC(hWnd);
			SetROP2(hDC,R2_NOT);
			MoveToEx(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2),NULL);
			LineTo(hDC,g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2));
			LineTo(hDC,g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2));
			LineTo(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2));
			LineTo(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2));

			g_pSelect.x = (short)LOWORD(lParam);
			g_pSelect.y = (short)HIWORD(lParam);
			MoveToEx(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2),NULL);
			LineTo(hDC,g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2));
			LineTo(hDC,g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2));
			LineTo(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2));
			LineTo(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2));
			ReleaseDC(hWnd,hDC);
		}
		char szI[128];
		strcpy(szI,"I:");

		RECT rc;
		GetClientRect(hWnd,&rc);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		rc.bottom-=sr.bottom;
		int x = (short)LOWORD(lParam)*g_SFT.GetWidth()/rc.right;
		int y = (short)HIWORD(lParam)*g_SFT.GetHeight()/rc.bottom;
		int i = g_SFT.GetIterationOnPoint(x,y);
		if(i>=0){
			wsprintf(szI+strlen(szI),"%d",i);
			wsprintf(szI+strlen(szI)," <%d,%d> S:%d",(short)LOWORD(lParam),(short)HIWORD(lParam),g_SFT.GetTransOnPoint(x,y));
			SendMessage(g_hwStatus,SB_SETTEXT,2,(LPARAM)szI);
		}
	}
	else if(!g_bWaitRead && g_bSelect && ((uMsg==WM_KEYDOWN && wParam==VK_ESCAPE) || uMsg==WM_LBUTTONUP || uMsg==WM_CAPTURECHANGED)){
		g_bSelect=FALSE;
		ReleaseCapture();
		RECT rc;
		GetClientRect(hWnd,&rc);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		rc.bottom-=sr.bottom;
		HDC hDC = GetDC(hWnd);
		SetROP2(hDC,R2_NOT);
		MoveToEx(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2),NULL);
		LineTo(hDC,g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2));
		LineTo(hDC,g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2));
		LineTo(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2));
		LineTo(hDC,g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2));
		ReleaseDC(hWnd,hDC);
		if(uMsg==WM_LBUTTONUP || uMsg==WM_CAPTURECHANGED){

			if(!g_bAddMainReference && !g_bAddReference && !g_bEraser){
				HDC hDC = GetDC(NULL);
				HDC dcBmp = CreateCompatibleDC(hDC);
				HBITMAP bmBmp = g_SFT.GetBitmap();

				HBITMAP bmOld = (HBITMAP)SelectObject(dcBmp,bmBmp);
				HDC dcSBmp = CreateCompatibleDC(hDC);
				SIZE sc, sb;
				POINT pSelect;
				sb.cx = g_SFT.GetWidth();
				sb.cy = g_SFT.GetHeight();
				pSelect.x = g_pSelect.x*sb.cx/rc.right;
				pSelect.y = g_pSelect.y*sb.cy/rc.bottom;
				sc.cx = sb.cx/(g_nZoomSize);
				sc.cy = sb.cy/(g_nZoomSize);
				HBITMAP bmSBmp = CreateCompatibleBitmap(hDC,sc.cx,sc.cy);
				HBITMAP bmSOld = (HBITMAP)SelectObject(dcSBmp,bmSBmp);
				SetStretchBltMode(dcSBmp,HALFTONE);
				SetStretchBltMode(dcBmp,HALFTONE);
				BitBlt(dcSBmp,0,0,sc.cx,sc.cy,dcBmp,pSelect.x-sb.cx/(g_nZoomSize*2),pSelect.y-sb.cy/(g_nZoomSize*2),SRCCOPY);
				StretchBlt(dcBmp,0,0,sb.cx,sb.cy,dcSBmp,0,0,sc.cx,sc.cy,SRCCOPY);
				SelectObject(dcBmp,bmOld);
				SelectObject(dcSBmp,bmSOld);
				DeleteObject(bmSBmp);
				DeleteDC(dcBmp);
				DeleteDC(dcSBmp);
				ReleaseDC(NULL,hDC);
				g_SFT.UpdateBitmap();
				InvalidateRect(hWnd,NULL,FALSE);
				UpdateWindow(hWnd);

				if(!g_hwExamine && g_bAutoIterations){
					int nMin, nMax, nIter;
					g_SFT.GetIterations(nMin,nMax);
					nIter = g_SFT.GetIterations();
					if(nIter<nMin+nMin/2+2000)
						g_SFT.SetIterations(nMin+nMin/2+3000);
				}
			}

			SYSTEMTIME st;
			GetLocalTime(&st);
			SystemTimeToFileTime(&st,(LPFILETIME)&g_nTStart);

			int x = (short)LOWORD(lParam)*g_SFT.GetWidth()/rc.right;
			int y = (short)HIWORD(lParam)*g_SFT.GetHeight()/rc.bottom;
			

			if(g_bAddMainReference){
				if(!g_hwExamine)
					g_bAddMainReference=FALSE;
				if(g_hwExamine){
					g_bExamineDirty=TRUE;
					SetFocus(g_hwExamine);
				}
				CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_SETMAINREFERENCE,MF_BYCOMMAND|MF_UNCHECKED);
				int x = (short)LOWORD(lParam)*g_SFT.GetWidth()/rc.right;
				int y = (short)HIWORD(lParam)*g_SFT.GetHeight()/rc.bottom;
				g_SFT.AddReference(x,y,TRUE);
				SetTimer(hWnd,0,500,NULL);
				return 0;
			}
			else if(g_bAddReference){
				if(!g_hwExamine)
					g_bAddReference=FALSE;
				if(g_hwExamine){
					g_bExamineDirty=TRUE;
					SetFocus(g_hwExamine);
				}
				CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ADDREFERENCE,MF_BYCOMMAND|MF_UNCHECKED);
				int x = (short)LOWORD(lParam)*g_SFT.GetWidth()/rc.right;
				int y = (short)HIWORD(lParam)*g_SFT.GetHeight()/rc.bottom;
				if(g_SFT.AddReference(x,y,FALSE,g_bAutoGlitchNP))
					SetTimer(hWnd,0,500,NULL);
				return 0;
			}
			else if(g_bEraser){
				RECT rE = {g_pSelect.x-rc.right/(g_nZoomSize*2),g_pSelect.y-rc.bottom/(g_nZoomSize*2),g_pSelect.x+rc.right/(g_nZoomSize*2),g_pSelect.y+rc.bottom/(g_nZoomSize*2)};
				rE.left = g_SFT.GetWidth()*rE.left/rc.right;
				rE.top = g_SFT.GetHeight()*rE.top/rc.bottom;
				rE.right = g_SFT.GetWidth()*rE.right/rc.right;
				rE.bottom = g_SFT.GetHeight()*rE.bottom/rc.bottom;
				int x, y;
				for(x=rE.left;x<rE.right;x++)
					for(y=rE.top;y<rE.bottom;y++)
						g_SFT.ErasePixel(x,y);
				g_bExamineDirty=TRUE;
				g_SFT.ApplyColors();
				InvalidateRect(hWnd,NULL,FALSE);
				UpdateWindow(hWnd);
				return 0;
			}
			else
				g_SFT.Zoom(x,y,g_nZoomSize,g_SFT.GetWidth(),g_SFT.GetHeight());
			SetTimer(hWnd,0,500,NULL);
		}
	}
	else if(uMsg==WM_KEYDOWN && wParam==VK_F5){
		if(g_hwExamine)
			g_bExamineDirty=TRUE;
		g_nPrevGlitchX=g_nPrevGlitchY=-1;
		g_SFT.Stop();
		g_bFindMinibrot=FALSE;
		g_bStoreZoom=FALSE;
		SetTimer(hWnd,0,500,NULL);
		RECT r;
		GetClientRect(hWnd,&r);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		r.bottom-=sr.bottom;
		SYSTEMTIME st;
		GetLocalTime(&st);
		SystemTimeToFileTime(&st,(LPFILETIME)&g_nTStart);
		if(g_SFT.GetWidth()<r.right)
			g_SFT.RenderFractal(r.right,r.bottom,g_SFT.GetIterations(),hWnd);
		else
			g_SFT.RenderFractal(g_SFT.GetWidth(),g_SFT.GetHeight(),g_SFT.GetIterations(),hWnd);
	}
	else if(uMsg==WM_KEYDOWN && wParam==VK_ESCAPE){
		if(g_bAddReference){
			g_bAddReference=FALSE;
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ADDREFERENCE,MF_BYCOMMAND|MF_UNCHECKED);
		}
		if(g_bAddMainReference){
			g_bAddMainReference=FALSE;
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_SETMAINREFERENCE,MF_BYCOMMAND|MF_UNCHECKED);
		}
		g_SFT.Stop();
		g_bFindMinibrot=FALSE;
		g_bStoreZoom=FALSE;
	}
	else if(uMsg==WM_KEYDOWN && wParam=='V'){
		if(wParam=='V'){
			if(HIWORD(GetKeyState(VK_CONTROL))){
				MessageBox(NULL,g_SFT.GetPosition(),g_SFT.ToZoom(),MB_OK);
			}
			else{
				if(!OpenClipboard(hWnd))
					return 0;
				HANDLE hTemp;
				char *szTemp="";
				if((hTemp = GetClipboardData(CF_TEXT)))
					szTemp = (char*)GlobalLock(hTemp);
				if(!szTemp || !*szTemp){
					GlobalUnlock(hTemp);
					CloseClipboard();
					return 0;
				}
				CStringTable stP(szTemp,":","\r\n");
				GlobalUnlock(hTemp);
				CloseClipboard();

				if(stP.FindString(0,"MANDELBROT")!=-1){
					g_SFT.Stop();
					g_bFindMinibrot=FALSE;
					g_bStoreZoom=FALSE;
					CFixedFloat tmp;
					tmp.SetMaxSignificant(0);
					RECT r;
					GetClientRect(hWnd,&r);
					RECT sr;
					GetWindowRect(g_hwStatus,&sr);
					sr.bottom-=sr.top;
					r.bottom-=sr.bottom;
					g_SFT.SetPosition(
						(CFixedFloat)Trim(stP[stP.FindString(0,"R-Start")][1]),
						(CFixedFloat)Trim(stP[stP.FindString(0,"R-Stop")][1]),
						(CFixedFloat)Trim(stP[stP.FindString(0,"I-Start")][1]),
						(CFixedFloat)Trim(stP[stP.FindString(0,"I-Stop")][1]),
						r.right,r.bottom);
					PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
				}
			}
		}
	}
	else if(uMsg==WM_KEYDOWN && wParam==187){
		SendMessage(hWnd,WM_KEYDOWN,VK_ESCAPE,0);
		POINT p;
		GetCursorPos(&p);
		ScreenToClient(hWnd,&p);
		SendMessage(hWnd,WM_LBUTTONDOWN,0,MAKELONG(p.x,p.y));
		PostMessage(hWnd,WM_LBUTTONUP,0,MAKELONG(p.x,p.y));
	}
	else if(uMsg==WM_KEYDOWN && wParam==189){
		SendMessage(hWnd,WM_KEYDOWN,VK_ESCAPE,0);
		POINT p;
		GetCursorPos(&p);
		ScreenToClient(hWnd,&p);
		PostMessage(hWnd,WM_USER+299,0,MAKELONG(p.x,p.y));
	}
	else if(uMsg==0x020A){//WM_MOUSEWHEEL
		if((short)HIWORD(wParam)>0)
			SendMessage(hWnd,WM_KEYDOWN,187,0);
		else
			SendMessage(hWnd,WM_KEYDOWN,189,0);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONSSHOWITERATIONS){
		g_SFT.ApplyIterationColors();
		InvalidateRect(hWnd,NULL,FALSE);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_SHOWSMOOTHTRANSITIONCOLORS){
		g_SFT.ApplySmoothColors();
		InvalidateRect(hWnd,NULL,FALSE);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_SPECIAL_MIRROR1){
		if(g_SFT.GetMirror()==1)
			g_SFT.SetMirror(0);
		else
			g_SFT.SetMirror(1);
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_SPECIAL_MIRROR1,MF_BYCOMMAND|(g_SFT.GetMirror()?MF_CHECKED:MF_UNCHECKED));
	}
	else if(uMsg==WM_COMMAND && wParam==ID_FILE_SAVEMAP){
		if(BrowseFile(hWnd,FALSE,"Save Map","Kalles fraktaler\0*.kfb\0",g_szFile,sizeof(g_szFile)))
			g_SFT.SaveMapB(g_szFile);
	}
	else if(uMsg==WM_COMMAND && (wParam==ID_FILE_STOREZOOMOUTIMAGES)){
		if(g_nZoomSize!=2 && MessageBox(hWnd,"The Zoom size is not 2, do you want to proceed?\n\nTo preserve quality the lowest Zoom size is recommended.","Kalles Fraktaler",MB_OKCANCEL)==IDCANCEL)
			return 0;
		MainProc(hWnd,WM_COMMAND,ID_FILE_SAVEAS_,0);
		g_JpegParams.nWidth = g_SFT.GetWidth();
		g_JpegParams.nHeight = g_SFT.GetHeight();
		g_JpegParams.nQuality = 99;
		while(1){
			if(!DialogBoxParam(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG7),hWnd,(DLGPROC)JpegProc,0))
				return 0;
			if(g_JpegParams.nWidth>3840){
				int nR;
				if((nR=MessageBox(hWnd,"Width can not be bigger than 3840, do you want to proceed?","Error",MB_YESNOCANCEL|MB_ICONSTOP))==IDCANCEL)
					return 0;
				if(nR==IDYES)
					break;
			}
			else
				break;
		}
		if(strrchr(g_szFile,'\\'))
			*strrchr(g_szFile,'\\')=0;
		if(!Browse(hWnd,g_szFile,sizeof(g_szFile)))
			return 0;
		if(g_szFile[strlen(g_szFile)-1]!='\\')
			strcat(g_szFile,"\\");
		SetTimer(hWnd,0,500,NULL);
		g_bStoreZoom=1;
		if(MessageBox(hWnd,"Do you want to store jpeg images?","Kalles Fraktaler",MB_YESNO|MB_ICONQUESTION)==IDYES)
			g_bStoreZoomJpg=1;
		else
			g_bStoreZoomJpg=0;
		char szFile[256];
		strcpy(szFile,g_szFile);
		wsprintf(strrchr(szFile,'\\')+1,"%05d_*.kfb",g_bStoreZoom);
		while(FileExists(szFile)){
			g_bStoreZoom++;
			wsprintf(strrchr(szFile,'\\')+1,"%05d_*.kfb",g_bStoreZoom);
		}
		g_SFT.StoreLocation();
		g_SFT.RenderFractal(g_JpegParams.nWidth,g_JpegParams.nHeight,g_SFT.GetIterations(),hWnd);
	}
	else if((uMsg==WM_COMMAND && wParam==ID_ACTIONS_CENTERCURSOR) || (uMsg==WM_KEYDOWN && wParam=='U' && HIWORD(GetKeyState(VK_CONTROL)))){
		POINT p;
		if(g_SFT.Center((int&)p.x, (int&)p.y)){
			RECT rc;
			GetClientRect(hWnd,&rc);
			RECT sr;
			GetWindowRect(g_hwStatus,&sr);
			sr.bottom-=sr.top;
			rc.bottom-=sr.bottom;
			p.x = p.x*rc.right/g_SFT.GetWidth();
			p.y = p.y*rc.bottom/g_SFT.GetHeight();

			ClientToScreen(hWnd,&p);
			SetCursorPos(p.x,p.y);
		}
		else
			MessageBox(hWnd,"Could not find center","Kalles Fraktaler",MB_OK|MB_ICONINFORMATION);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_NOAPPROXIMATION){
		g_SFT.SetNoApproximation(!g_SFT.GetNoApproximation());
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_NOAPPROXIMATION,MF_BYCOMMAND|(g_SFT.GetNoApproximation()?MF_CHECKED:MF_UNCHECKED));
	}

	else if((uMsg==WM_COMMAND && wParam==ID_ACTIONS_SETIMAGESIZE) || (uMsg==WM_KEYDOWN && wParam=='Z' && HIWORD(GetKeyState(VK_CONTROL)))){
		g_JpegParams.nWidth = g_SFT.GetWidth();
		g_JpegParams.nHeight = g_SFT.GetHeight();
		if(!DialogBoxParam(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG7),hWnd,(DLGPROC)JpegProc,1))
			return 0;
		SetTimer(hWnd,0,500,NULL);
		g_SFT.RenderFractal(g_JpegParams.nWidth,g_JpegParams.nHeight,g_SFT.GetIterations(),hWnd);
	}
	else if((uMsg==WM_COMMAND && wParam==ID_ACTIONS_SETWINDOWSIZE) || (uMsg==WM_KEYDOWN && wParam=='W' && HIWORD(GetKeyState(VK_CONTROL)))){
		RECT wr, cr;
		GetClientRect(hWnd,&cr);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		g_JpegParams.nWidth = cr.right;
		g_JpegParams.nHeight = cr.bottom-sr.bottom;
		if(!DialogBoxParam(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG7),hWnd,(DLGPROC)JpegProc,1))
			return 0;
		GetWindowRect(hWnd,&wr);
		wr.right-=wr.left;
		wr.bottom-=wr.top;
		int nXOffs = g_JpegParams.nWidth-cr.right;
		wr.right+=nXOffs;
		wr.left-=nXOffs/2;
		int nYOffs = g_JpegParams.nHeight-cr.bottom;
		wr.bottom+=nYOffs+sr.bottom;
		wr.top-=nYOffs/2+sr.bottom/2;
		MoveWindow(hWnd,wr.left,wr.top,wr.right,wr.bottom,TRUE);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_FINDHIGHESTITERATION){
		POINT p;
		if(g_SFT.HighestIteration((int&)p.x, (int&)p.y)){
			RECT rc;
			GetClientRect(hWnd,&rc);
			RECT sr;
			GetWindowRect(g_hwStatus,&sr);
			sr.bottom-=sr.top;
			rc.bottom-=sr.bottom;
			p.x = p.x*rc.right/g_SFT.GetWidth();
			p.y = p.y*rc.bottom/g_SFT.GetHeight();
			ClientToScreen(hWnd,&p);
			SetCursorPos(p.x,p.y);
		}
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_ADDREFERENCE){
		g_bAddReference=TRUE;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ADDREFERENCE,MF_BYCOMMAND|MF_CHECKED);

		g_bAddMainReference=FALSE;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_SETMAINREFERENCE,MF_BYCOMMAND|MF_UNCHECKED);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_ADDREFERENCEERRORS){
		g_bAddReference=FALSE;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ADDREFERENCE,MF_BYCOMMAND|MF_UNCHECKED);
		g_bAddMainReference=FALSE;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_SETMAINREFERENCE,MF_BYCOMMAND|MF_UNCHECKED);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_SETMAINREFERENCE){
		g_bAddMainReference=TRUE;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_SETMAINREFERENCE,MF_BYCOMMAND|MF_CHECKED);

		g_bAddReference=FALSE;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ADDREFERENCE,MF_BYCOMMAND|MF_UNCHECKED);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_FINDCENTEROFGLITCH){
		POINT p;
		if(g_SFT.FindCenterOfGlitch((int&)p.x, (int&)p.y,g_bAutoGlitchNP)){
			RECT rc;
			GetClientRect(hWnd,&rc);
			RECT sr;
			GetWindowRect(g_hwStatus,&sr);
			sr.bottom-=sr.top;
			rc.bottom-=sr.bottom;
			p.x = p.x*rc.right/g_SFT.GetWidth();
			p.y = p.y*rc.bottom/g_SFT.GetHeight();
			ClientToScreen(hWnd,&p);
			SetCursorPos(p.x,p.y);
		}
		else
			MessageBox(hWnd,"Could not find any glitches","Kalles Fraktaler",MB_OK|MB_ICONINFORMATION);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_FILE_EXAMINEZOOMSEQUENCE){
		memset(g_szExamine,0,sizeof(g_szExamine));
		if(!BrowseFile(hWnd,TRUE,"Open location","Kalles fraktaler\0*.kfr\0",g_szExamine,sizeof(g_szExamine)))
			return 0;
		if(g_hwExamine)
			SetFocus(g_hwExamine);
		else{
			g_hwExamine = CreateDialog(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG8),hWnd,(DLGPROC)ExamineProc);
			ShowWindow(g_hwExamine,SW_SHOW);
		}
	}
	else if(uMsg==WM_COMMAND && wParam==ID_FILE_RESUMEZOOMSEQUENCE){
		return ResumeZoomSequence(hWnd);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_SOLVEGLITCHWITHNEARPIXELSMETHOD){
		g_bAutoGlitchNP=!g_bAutoGlitchNP;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_SOLVEGLITCHWITHNEARPIXELSMETHOD,MF_BYCOMMAND|(g_bAutoGlitchNP?MF_CHECKED:MF_UNCHECKED));
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_AUTOSOLVEGLITCHES){
		g_bAutoGlitch=!g_bAutoGlitch;
		g_nPrevGlitchX=g_nPrevGlitchY=-1;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_AUTOSOLVEGLITCHES,MF_BYCOMMAND|(g_bAutoGlitch?MF_CHECKED:MF_UNCHECKED));
		if(g_bAutoGlitch){
			g_bReuseRef = !g_bAutoGlitch;
			g_SFT.ReuseReference(g_bReuseRef);
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_REUSEREFERENCE,MF_BYCOMMAND|(g_bReuseRef?MF_CHECKED:MF_UNCHECKED));
		}
		else{
			g_bAutoGlitchNP=0;
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_SOLVEGLITCHWITHNEARPIXELSMETHOD,MF_BYCOMMAND|(g_bAutoGlitchNP?MF_CHECKED:MF_UNCHECKED));		
		}
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_AUTOITERATION){
		g_bAutoIterations=!g_bAutoIterations;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_AUTOITERATION,MF_BYCOMMAND|(g_bAutoIterations?MF_CHECKED:MF_UNCHECKED));
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_USELONGDOUBLEFROMSTART){
		if(g_nLDBL>100)
			g_nLDBL=3;
		else{
			if(g_SFT.GetPower()==2)
				g_nLDBL=600;
			else
				g_nLDBL=400;
		}
		g_nEXP=4900;
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_USELONGDOUBLEFROMSTART,MF_BYCOMMAND|(g_nLDBL==3?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_USEFLOATEXPALWAYS,MF_BYCOMMAND|MF_UNCHECKED);
	}
	else if(uMsg==WM_COMMAND && wParam==ID_ACTIONS_SPECIAL_USEFLOATEXPALWAYS){
		if(g_nEXP==4900){
			g_nLDBL=2;
			g_nEXP=3;
		}
		else{
			if(g_SFT.GetPower()==2)
				g_nLDBL=600;
			else
				g_nLDBL=400;
			g_nEXP=4900;
		}
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_USELONGDOUBLEFROMSTART,MF_BYCOMMAND|MF_UNCHECKED);
		CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_SPECIAL_USEFLOATEXPALWAYS,MF_BYCOMMAND|(g_nEXP==3?MF_CHECKED:MF_UNCHECKED));
	}
	else if(uMsg==WM_KEYDOWN && wParam=='O' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_FILE_OPEN_,0);
	else if(uMsg==WM_KEYDOWN && wParam=='S' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_FILE_SAVE_,0);
	else if(uMsg==WM_KEYDOWN && wParam=='N' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_RESET,0);
	else if(uMsg==WM_KEYDOWN && wParam=='N' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_FILE_SAVEAS_,0);
	else if(uMsg==WM_KEYDOWN && wParam=='2' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_ZOOMSIZE_2,0);
	else if(uMsg==WM_KEYDOWN && wParam=='4' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_ZOOMSIZE_4,0);
	else if(uMsg==WM_KEYDOWN && wParam=='8' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_ZOOMSIZE_8,0);
	else if(uMsg==WM_KEYDOWN && wParam=='1' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_ZOOMSIZE_16,0);
	else if(uMsg==WM_KEYDOWN && wParam=='3' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_ZOOMSIZE_32,0);
	else if(uMsg==WM_KEYDOWN && wParam=='6' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_ZOOMSIZE_64,0);
	else if(uMsg==WM_KEYDOWN && wParam=='L' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_POSITION,0);
	else if(uMsg==WM_KEYDOWN && wParam=='C' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_SETCOLORS,0);
	else if(uMsg==WM_KEYDOWN && wParam=='I' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_ITERATIONS,0);
	else if(uMsg==WM_KEYDOWN && wParam=='E' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_REUSEREFERENCE,0);
	else if(uMsg==WM_KEYDOWN && wParam=='Q' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_FILE_STOREZOOMOUTIMAGES,0);
	else if(uMsg==WM_KEYDOWN && wParam=='M' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_FINDMINIBROT,0);
	else if(uMsg==WM_KEYDOWN && wParam=='J' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_FILE_SAVEASJPEG,0);
	else if(uMsg==WM_KEYDOWN && wParam=='R' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_ADDREFERENCE,0);
	else if(uMsg==WM_KEYDOWN && wParam=='F' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_ACTIONS_FINDCENTEROFGLITCH,0);
	else if(uMsg==WM_KEYDOWN && wParam=='A' && HIWORD(GetKeyState(VK_CONTROL)))
		PostMessage(hWnd,WM_COMMAND,ID_FILE_SAVEAS_,0);
	else if(uMsg==WM_RBUTTONUP && !g_bWaitRead){
		g_SFT.Stop();
		SYSTEMTIME st;
		GetLocalTime(&st);
		SystemTimeToFileTime(&st,(LPFILETIME)&g_nTStart);
		g_bFindMinibrot=FALSE;
		g_bStoreZoom=FALSE;
		PostMessage(hWnd,WM_USER+299,wParam,lParam);
	}
	else if(uMsg==WM_USER+299){
		RECT rc;
		GetClientRect(hWnd,&rc);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		rc.bottom-=sr.bottom;
		int x = (short)LOWORD(lParam)*g_SFT.GetWidth()/rc.right;
		int y = (short)HIWORD(lParam)*g_SFT.GetHeight()/rc.bottom;
		if(!g_bAutoGlitch && g_bReuseRef && x==g_SFT.GetWidth()/2 && y==g_SFT.GetHeight()/2)
			g_SFT.Zoom(x,y,1/(double)g_nZoomSize,g_SFT.GetWidth(),g_SFT.GetHeight(),TRUE);
		else
			g_SFT.Zoom(x,y,1/(double)g_nZoomSize,g_SFT.GetWidth(),g_SFT.GetHeight());
		SetTimer(hWnd,0,500,NULL);
	}
	else if(uMsg==WM_SIZING){
		RECT sr, cr;
		LPRECT pwr = (LPRECT)lParam;
		pwr->right-=pwr->left;
		pwr->bottom-=pwr->top;
		GetClientRect(hWnd,&cr);
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		cr.bottom-=sr.bottom;
		int nXOffs = 16*cr.bottom/9 - cr.right;
		pwr->right+=nXOffs;
		
/*		MoveWindow(hWnd,pwr->left,pwr->top,pwr->right,pwr->bottom,TRUE);
		SendMessage(g_hwStatus,uMsg,wParam,lParam);
		InvalidateRect(hWnd,NULL,FALSE);
*/
		pwr->right+=pwr->left;
		pwr->bottom+=pwr->top;
		return TRUE;
	}
	else if(uMsg==WM_SIZE){
		RECT wr, cr;
		GetWindowRect(hWnd,&wr);
		wr.right-=wr.left;
		wr.bottom-=wr.top;
		GetClientRect(hWnd,&cr);
		RECT sr;
		GetWindowRect(g_hwStatus,&sr);
		sr.bottom-=sr.top;
		cr.bottom-=sr.bottom;
		int nXOffs = 16*cr.bottom/9 - cr.right;
		wr.right+=nXOffs;
		MoveWindow(hWnd,wr.left,wr.top,wr.right,wr.bottom,TRUE);
		SendMessage(g_hwStatus,uMsg,wParam,lParam);
		InvalidateRect(hWnd,NULL,FALSE);
//		PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
	}
	else if(uMsg==WM_USER+199 || uMsg==WM_TIMER){
		return HandleDoneSEH(hWnd,uMsg,wParam,lParam);
	}
	else if(uMsg==WM_COMMAND){
		if(wParam==ID_ACTIONS_POSITION){
//			MessageBox(NULL,g_SFT.GetPosition(),g_SFT.ToZoom(),MB_OK);
			if(DialogBox(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG5),hWnd,(DLGPROC)PositionProc))
				PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
		}
		else if(wParam==ID_ACTIONS_EXIT)
			PostQuitMessage(0);
		else if(wParam==ID_ACTIONS_REFRESH)
			PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
		else if(wParam==ID_ACTIONS_CANCELRENDERING)
			PostMessage(hWnd,WM_KEYDOWN,VK_ESCAPE,0);
		else if(wParam==ID_ACTIONS_ITERATIONS){
			int n = DialogBoxParam(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG2),hWnd,(DLGPROC)IterationProc,0);
			if(n){
				SetTimer(hWnd,0,500,NULL);
				RECT r;
				GetClientRect(hWnd,&r);
				RECT sr;
				GetWindowRect(g_hwStatus,&sr);
				sr.bottom-=sr.top;
				r.bottom-=sr.bottom;
				g_SFT.SetIterations(n);
				PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
			}
		}
		else if(wParam==ID_ACTIONS_SETCOLORS){
			if(!g_hwColors)
				g_hwColors = CreateDialog(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG3),hWnd,(DLGPROC)ColorProc);
			ShowWindow(g_hwColors,SW_SHOW);
		}
		else if(wParam==ID_ACTIONS_ZOOMSIZE_1 || wParam==ID_ACTIONS_ZOOMSIZE_2 ||
			wParam==ID_ACTIONS_ZOOMSIZE_4 ||
			wParam==ID_ACTIONS_ZOOMSIZE_8 ||
			wParam==ID_ACTIONS_ZOOMSIZE_16 ||
			wParam==ID_ACTIONS_ZOOMSIZE_32 ||
			wParam==ID_ACTIONS_ZOOMSIZE_64 ||
			wParam==ID_ACTIONS_ZOOMSIZE_128){
			if(wParam==ID_ACTIONS_ZOOMSIZE_1)
				g_nZoomSize=1;
			if(wParam==ID_ACTIONS_ZOOMSIZE_2)
				g_nZoomSize=2;
			else if(wParam==ID_ACTIONS_ZOOMSIZE_4)
				g_nZoomSize=4;
			else if(wParam==ID_ACTIONS_ZOOMSIZE_8)
				g_nZoomSize=8;
			else if(wParam==ID_ACTIONS_ZOOMSIZE_16)
				g_nZoomSize=16;
			else if(wParam==ID_ACTIONS_ZOOMSIZE_32)
				g_nZoomSize=32;
			else if(wParam==ID_ACTIONS_ZOOMSIZE_64)
				g_nZoomSize=64;
			else if(wParam==ID_ACTIONS_ZOOMSIZE_128)
				g_nZoomSize=128;
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_1,MF_BYCOMMAND|(g_nZoomSize==1?MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_2,MF_BYCOMMAND|(g_nZoomSize==2?MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_4,MF_BYCOMMAND|(g_nZoomSize==4?MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_8,MF_BYCOMMAND|(g_nZoomSize==8?MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_16,MF_BYCOMMAND|(g_nZoomSize==16?MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_32,MF_BYCOMMAND|(g_nZoomSize==32?MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_64,MF_BYCOMMAND|(g_nZoomSize==64?MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_ZOOMSIZE_128,MF_BYCOMMAND|(g_nZoomSize==128?MF_CHECKED:MF_UNCHECKED));
		}
		else if(wParam==ID_ACTIONS_REUSEREFERENCE){
			g_bReuseRef = !g_bReuseRef;
			g_SFT.ReuseReference(g_bReuseRef);
			CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_REUSEREFERENCE,MF_BYCOMMAND|(g_bReuseRef?MF_CHECKED:MF_UNCHECKED));
			if(g_bReuseRef){
				g_bAutoGlitch=!g_bReuseRef;
				CheckMenuItem(GetMenu(hWnd),ID_ACTIONS_AUTOSOLVEGLITCHES,MF_BYCOMMAND|(g_bAutoGlitch?MF_CHECKED:MF_UNCHECKED));
			}
		}
		else if(wParam==ID_FILE_OPEN_){
			if(BrowseFile(hWnd,TRUE,"Open Location Parameters","Kalles fraktaler\0*.kfr\0",g_szFile,sizeof(g_szFile))){
				g_SFT.Stop();
				if(!g_SFT.OpenFile(g_szFile))
					return MessageBox(hWnd,"Invalid parameter file","Error",MB_OK|MB_ICONSTOP);
				else{
					if(g_hwColors)
						SendMessage(g_hwColors,WM_USER+99,0,0);
					PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
					char szTitle[369];
					wsprintf(szTitle,"Kalles Fraktaler 2 - %s",g_szFile);
					SetWindowText(hWnd,szTitle);
				}
			}
		}
		else if(wParam==ID_FILE_SAVE_){
			if(!*g_szFile)
				PostMessage(hWnd,WM_COMMAND,ID_FILE_SAVEAS_,0);
			else if(!g_SFT.SaveFile(g_szFile))
				return MessageBox(hWnd,"Could not save parameters","Error",MB_OK|MB_ICONSTOP);
		}
		else if(wParam==ID_FILE_SAVEASJPEG){
			g_JpegParams.nWidth = g_SFT.GetWidth();
			g_JpegParams.nHeight = g_SFT.GetHeight();
			g_JpegParams.nQuality = 99;
			if(DialogBoxParam(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG7),hWnd,(DLGPROC)JpegProc,0)){
				char szFile[256]={0};
				if(g_JpegParams.nWidth>g_SFT.GetWidth()){
					g_bSaveJpeg=TRUE;
					SetTimer(hWnd,0,500,NULL);
					g_SFT.RenderFractal(g_JpegParams.nWidth,g_JpegParams.nHeight,g_SFT.GetIterations(),hWnd);
					return 0;
				}
				if(BrowseFile(hWnd,FALSE,"Save as Jpeg","Jpeg\0*.jpg\0",szFile,sizeof(szFile))){
					if(!g_SFT.SaveJpg(szFile,g_JpegParams.nQuality,g_JpegParams.nWidth,g_JpegParams.nHeight))
						MessageBox(hWnd,"File could not be saved","Error",MB_OK|MB_ICONSTOP);
					char *e = strrchr(szFile,'.');
					if(e)
						e++;
					else
						e = szFile+strlen(szFile);
					strcpy(e,"kfb");
					if(FileExists(szFile) && MessageBox(hWnd,"Found a map file (.kfb) with the same name, do you want to replace it?","Kalles Fraktaler",MB_YESNO)==IDYES)
						g_SFT.SaveMapB(szFile);
				}
			}
		}
		else if(wParam==ID_FILE_SAVEAS_){
			if(BrowseFile(hWnd,FALSE,"Save Location Parameters","Kalles fraktaler\0*.kfr\0",g_szFile,sizeof(g_szFile))){
				if(!g_SFT.SaveFile(g_szFile))
					return MessageBox(hWnd,"Could not save parameters","Error",MB_OK|MB_ICONSTOP);
				char szTitle[369];
				wsprintf(szTitle,"Kalles Fraktaler 2 - %s",g_szFile);
				SetWindowText(hWnd,szTitle);
			}
		}
/*		else if(wParam==ID_ACTIONS_CREATEZOOMSEQUENCE){
			DialogBoxParam(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_DIALOG6),hWnd,(DLGPROC)ZoomProc,0);
		}
*/		else if(wParam==ID_ACTIONS_RESET){
			*g_szFile=0;
			SetWindowText(hWnd,"Kalles Fraktaler 2");
			g_SFT.SetPosition("0","0","1");
			PostMessage(hWnd,WM_KEYDOWN,VK_F5,0);
		}
		else if(wParam==ID_SPECIAL_NON){
			if(!g_bFindMinibrotCount)
				g_bFindMinibrotCount=1;
			else
				g_bFindMinibrotCount=0;
			CheckMenuItem(GetMenu(hWnd),ID_SPECIAL_NON,MF_BYCOMMAND|(g_bFindMinibrotCount?MF_CHECKED:MF_UNCHECKED));
		}
		else if(wParam==ID_ACTIONS_FINDMINIBROT){
			g_SFT.Stop();
			g_bStoreZoom=FALSE;
			int x, y;
			if(!g_SFT.Center(x,y,g_bFindMinibrotCount==20)){
				g_bFindMinibrot=FALSE;
				return MessageBox(hWnd,"Cannot find center","Error",MB_OK|MB_ICONSTOP);
			}
			if(g_bFindMinibrotCount){
				g_bFindMinibrotCount++;
				if(g_bFindMinibrotCount>20)
					g_bFindMinibrotCount=1;
			}
			int nMin, nMax, nIter;
			g_SFT.GetIterations(nMin,nMax);
			nIter = g_SFT.GetIterations();
			g_bFindMinibrot=TRUE;
			if(nIter<nMin+nMin/2+2000)
				g_SFT.SetIterations(nMin+nMin/2+3000);
			if(nIter==nMax){
				g_bFindMinibrot=FALSE;
				MessageBox(hWnd,"Done","Kalles Fraktaler",MB_OK);
			}
			else{
				SetTimer(hWnd,0,500,NULL);
				SYSTEMTIME st;
				GetLocalTime(&st);
				SystemTimeToFileTime(&st,(LPFILETIME)&g_nTStart);
				RECT rc;
				GetClientRect(hWnd,&rc);
				RECT sr;
				GetWindowRect(g_hwStatus,&sr);
				sr.bottom-=sr.top;
				rc.bottom-=sr.bottom;
			HDC hDC = GetDC(NULL);
			HDC dcBmp = CreateCompatibleDC(hDC);
			HBITMAP bmBmp = g_SFT.GetBitmap();
			
/*			ANIM* pAnim = new ANIM;
			pAnim->bmBmp = ShrinkBitmap2(bmBmp,rc.right,rc.bottom); 
			pAnim->hWnd = hWnd;
			pAnim->pOffs = g_pSelect;
			DWORD dw;
			HANDLE hThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)ThAnim,(LPVOID)pAnim,0,&dw);
			CloseHandle(hThread);
*/
			HBITMAP bmOld = (HBITMAP)SelectObject(dcBmp,bmBmp);
			HDC dcSBmp = CreateCompatibleDC(hDC);
			SIZE sc;
			sc.cx = rc.right/(g_nZoomSize);
			sc.cy = rc.bottom/(g_nZoomSize);
			HBITMAP bmSBmp = CreateCompatibleBitmap(hDC,sc.cx,sc.cy);
			HBITMAP bmSOld = (HBITMAP)SelectObject(dcSBmp,bmSBmp);
			BitBlt(dcSBmp,0,0,sc.cx,sc.cy,dcBmp,x-rc.right/(g_nZoomSize*2),y-rc.bottom/(g_nZoomSize*2),SRCCOPY);
			SetStretchBltMode(dcSBmp,HALFTONE);
			SetStretchBltMode(dcBmp,HALFTONE);
			StretchBlt(dcBmp,0,0,rc.right,rc.bottom,dcSBmp,0,0,sc.cx,sc.cy,SRCCOPY);
			SelectObject(dcBmp,bmOld);
			SelectObject(dcSBmp,bmSOld);
			DeleteObject(bmSBmp);
			DeleteDC(dcBmp);
			DeleteDC(dcSBmp);
			ReleaseDC(NULL,hDC);
			g_SFT.UpdateBitmap();

			InvalidateRect(hWnd,NULL,FALSE);
			UpdateWindow(hWnd);

//			x = x*rc.right/g_SFT.GetWidth();
//			y = y*rc.bottom/g_SFT.GetHeight();

			g_SFT.Zoom(x,y,g_nZoomSize,g_SFT.GetWidth(),g_SFT.GetHeight());
			}
		}
		else if(wParam==ID_MENUITEM40025){
			char szMsg[1024];
			SYSTEM_INFO sysinfo; 
			GetSystemInfo( &sysinfo );  //
			wsprintf(szMsg,"2013-2014 Karl Runmo version 2.5\n\nProcessors: %d\nPrecision: %d\n%s\n\nAcknowledgements:\n - Thanks to K.I.Martin for applying Perturbation and Series Approximation on the Mandelbrot set and generously sharing the theory and Java source code!\n - Thanks to Pauldelbrot for finding the reliable glitch detection method\n - Thanks to Botond Ksa and knighty for the extensions of Series Approximation\n - Thanks to Chillheimer for hosting my program\n\nhttp://www.chillheimer.de/kallesfraktaler/",sysinfo.dwNumberOfProcessors,FIXEDFLOAT_ENTRIES*8-16,sizeof(void*)==4?"32-bit":"64-bit");
			return MessageBox(hWnd,szMsg,"Kalles Fraktaler 2",MB_OK);
		}
	}	
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}
int Test()
{
	CPixels P;
	P.Init(3,640,360);
	HDC hDC = GetDC(NULL);
	int x, y;
	while(P.GetPixel(x,y)){
		MoveToEx(hDC,x,y,NULL);
		LineTo(hDC,x+1,y);
	}
	ReleaseDC(NULL,hDC);
	return 0;
}
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE,LPSTR,int)
{
//	return Test();

	GetModuleFileName(GetModuleHandle(NULL),g_szRecovery,sizeof(g_szRecovery));
	strcpy(strrchr(g_szRecovery,'.'),".rec");

	WNDCLASS wc={0};
	wc.hInstance = hInstance;
	wc.lpszClassName = "FRAKTAL_SFT";
	wc.lpfnWndProc = (WNDPROC)MainProc;
	wc.hCursor = LoadCursor(NULL,IDC_CROSS);
	wc.hIcon = LoadIcon(hInstance,MAKEINTRESOURCE(IDI_ICON1));
	RegisterClass(&wc);
	HWND hWnd = CreateWindowEx(WS_EX_CLIENTEDGE,wc.lpszClassName,"Kalles Fraktaler 2",WS_OVERLAPPEDWINDOW|WS_VISIBLE,0,0,200,200,NULL,LoadMenu(hInstance,MAKEINTRESOURCE(IDR_MENU1)),hInstance,0);
	ShowWindow(hWnd,SW_SHOW);
	MSG msg;
	while(GetMessage(&msg,NULL,0,0)){
		if(GetDlgCtrlID(msg.hwnd)==IDC_LIST1 && msg.message==WM_RBUTTONDOWN)
			SendMessage(GetParent(msg.hwnd),WM_USER+88,GetDlgCtrlID(msg.hwnd),0);
		if(g_hwColors && IsDialogMessage(g_hwColors,&msg))
			continue;
		if(g_hwExamine && IsDialogMessage(g_hwExamine,&msg))
			continue;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	DeleteFile(g_szRecovery);
	return 0;
}
