/* Replace "dll.h" with the name of your header */
#include <windows.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#define _GCC_
#include "C:\pojects\ltest\fraktal_sft\floatexp.h"
//#include "C:\pojects\ltest\fraktal_sft\ldbl_exp.h"
#define TERM4
#define TERM5
#define TERM6
#define TERM7

BOOL APIENTRY DllMain (HINSTANCE hInst     /* Library instance handle. */ ,
                       DWORD reason        /* Reason this function is being called. */ ,
                       LPVOID reserved     /* Not used. */ )
{
    switch (reason)
    {
      case DLL_PROCESS_ATTACH:
        break;

      case DLL_PROCESS_DETACH:
        break;

      case DLL_THREAD_ATTACH:
        break;

      case DLL_THREAD_DETACH:
        break;
    }

    /* Returns TRUE on success, FALSE on failure */
    return TRUE;
}
extern "C" __declspec(dllexport) int SizeOfLD()
{
       return sizeof(long double);
}
extern "C" __declspec(dllexport) void *AllocateArray(int nSize)
{
       long double *ret = new long double[nSize];
       return ret;
}
extern "C" __declspec(dllexport) void ReleaseArray(void *p)
{
       long double *del = (long double *)p;
       delete [] del;
}
extern "C" __declspec(dllexport) void AssignInt(void *p,int nValue)
{
       *((long double*)p) = nValue;
}
extern "C" __declspec(dllexport) void AssignDouble(void *p,double nDouble)
{
       *((long double*)p) = nDouble;
}
extern "C" __declspec(dllexport) void AssignLD(void *p,void *ld)
{
       *((long double*)p) = *((long double*)ld);
}
extern "C" __declspec(dllexport) void ToInt(void *p,int *pnValue)
{
       *pnValue = (int)*((long double*)p);
}
extern "C" __declspec(dllexport) void ToDouble(void *p,double *pnDouble)
{
       *pnDouble = *((long double*)p);
}
extern "C" __declspec(dllexport) void ToFloatExp(void *p,floatexp *pnFloatExp)
{
       pnFloatExp->setLongDouble(*((long double*)p));
}
extern "C" __declspec(dllexport) void AssignFloatExp(void *p,floatexp *fe)
{
	*((long double*)p) = fe->toLongDouble();
}

extern "C" __declspec(dllexport) void Multiply(void *a,void *b,void *ret)
{
       (*((long double*)ret)) = (*((long double*)a)) * (*((long double*)b));
}
extern "C" __declspec(dllexport) double SquareAdd(void *a,void *b)
{
       return (*((long double*)a)) * (*((long double*)a)) + (*((long double*)b)) * (*((long double*)b));
}
extern "C" __declspec(dllexport) void Divide(void *a,void *b,void *ret)
{
       (*((long double*)ret)) = (*((long double*)a)) / (*((long double*)b));
}
extern "C" __declspec(dllexport) void Add(void *a,void *b,void *ret)
{
       (*((long double*)ret)) = (*((long double*)a)) + (*((long double*)b));
}
extern "C" __declspec(dllexport) void Subtract(void *a,void *b,void *ret)
{
       (*((long double*)ret)) = (*((long double*)a)) - (*((long double*)b));
}
extern "C" __declspec(dllexport) void Negative(void *a)
{
       (*((long double*)a)) = -(*((long double*)a));
}
extern "C" __declspec(dllexport) int GT(void *a,void *b)
{
       return (*((long double*)a)) > (*((long double*)b));
}
extern "C" __declspec(dllexport) int LT(void *a,void *b)
{
       return (*((long double*)a)) < (*((long double*)b));
}
extern "C" __declspec(dllexport) int Equal(void *a,void *b)
{
       return (*((long double*)a)) == (*((long double*)b));
}
extern "C" __declspec(dllexport) void Print(void *a,char *szRet)
{
       sprintf(szRet,"%ld",*((long double*)a));
}
extern "C" __declspec(dllexport) int Version()
{
	return 3;
}

#define	FIXEDFLOAT_TYPE __int64
#define FIXEDFLOAT_DIGITS 8
#define FIXEDFLOAT_PARTMAX (FIXEDFLOAT_TYPE)100000000

extern "C" __declspec(dllexport) void ConvertFromFixedFloat(void *p,int nValues, __int64 *pValues, BOOL bSign)
{
	long double a=0;
	int n;
	int nStart = 0;
	for(nStart=0;nStart<nValues;nStart++)
		if(pValues[nStart])
			break;
	nStart+=32/FIXEDFLOAT_DIGITS;
	if(nStart>nValues)
		nStart=nValues;
	for(n=nStart-1;n>=0;n--)
		a = a/FIXEDFLOAT_PARTMAX + pValues[n];
	if(bSign)
		a=-a;
	*((long double *)p) = a;
}

//#define LDBL_MAX 3e4932L

BOOL ISFLOATOK(long double a)
{
	__int64 *val = (__int64*)&a;
	if((val[1]&0x7FFF)==0x7FFF || (val[1]&0x7FFF)==0)
		return FALSE;
	return TRUE;
}
BOOL ISFLOATOK(double a)
{
	if(a < DBL_MAX && a > -DBL_MAX)
		return TRUE;
	return 0;
}

extern "C" __declspec(dllexport) int Perturbation4(int antal,void *pdxr,void *pdxi, void* pDr, void*pDi, void* pD0r, void*pD0i,double *ptest1, double *ptest2, int m_nBailout2, int m_nMaxIter,double *m_db_z,BOOL *pGlitch)
{
	long double *dxr = (long double*)pdxr;
	long double *dxi = (long double*)pdxi;
	long double Dr = *(long double*)pDr;
	long double Di = *(long double*)pDi;
	long double D0r = *(long double*)pD0r;
	long double D0i = *(long double*)pD0i;
	long double Dnr, Dni;
	double &test1 = *ptest1;
	double &test2 = *ptest2;
	long double yr, yi;
    BOOL &bGlitch=*pGlitch;
    bGlitch=FALSE;
	if(antal<m_nMaxIter && test1 <= m_nBailout2){
		for(;antal<m_nMaxIter;antal++){
			yr=dxr[antal]+Dr;
			yi=dxi[antal]+Di;
			test2=test1;
			test1 = yr*yr+yi*yi;
		    if(test1<m_db_z[antal]){
                test1 = m_nBailout2*2;
	      		bGlitch=TRUE;
		    }
			if(test1 > m_nBailout2)
				break;
			Dnr = (2*dxr[antal] + Dr)*Dr - (2*dxi[antal] + Di)*Di + D0r;
			Dni = 2*((dxr[antal] + Dr)*Di + dxi[antal]*Dr) + D0i;
			Di = Dni;
			Dr = Dnr;
		}
	}
	return antal;
}
extern "C" __declspec(dllexport) int Perturbation_3rd(int antal,void *pdxr,void *pdxi, void* pDr, void*pDi, void* pD0r, void*pD0i,double *ptest1, double *ptest2, int m_nBailout2, int m_nMaxIter,double *m_db_z,BOOL *pGlitch)
{
	long double *dxr = (long double*)pdxr;
	long double *dxi = (long double*)pdxi;
	long double Dr = *(long double*)pDr;
	long double Di = *(long double*)pDi;
	long double D0r = *(long double*)pD0r;
	long double D0i = *(long double*)pD0i;
	long double Dnr, Dni;
	double &test1 = *ptest1;
	double &test2 = *ptest2;
	long double yr, yi;
    BOOL &bGlitch=*pGlitch;
    bGlitch=FALSE;
	if(antal<m_nMaxIter && test1 <= m_nBailout2){
		for(;antal<m_nMaxIter;antal++){
			yr=dxr[antal]+Dr;
			yi=dxi[antal]+Di;
			test2=test1;
			test1 = yr*yr+yi*yi;
		    if(test1<m_db_z[antal]){
                test1 = m_nBailout2*2;
	      		bGlitch=TRUE;
		    }
			if(test1 > m_nBailout2)
				break;
			Dnr = 3*dxr[antal]*dxr[antal]*Dr - 6*dxr[antal]*dxi[antal]*Di - 3*dxi[antal]*dxi[antal]*Dr + 3*dxr[antal]*Dr*Dr - 3*dxr[antal]*Di*Di - 3*dxi[antal]*2*Dr*Di + Dr*Dr*Dr - 3*Dr*Di*Di + D0r;
			Dni = 3*dxr[antal]*dxr[antal]*Di + 6*dxr[antal]*dxi[antal]*Dr - 3*dxi[antal]*dxi[antal]*Di + 3*dxr[antal]*2*Dr*Di + 3*dxi[antal]*Dr*Dr - 3*dxi[antal]*Di*Di + 3*Dr*Dr*Di - Di*Di*Di + D0i;
			
			//Dnr = (2*dxr[antal] + Dr)*Dr - (2*dxi[antal] + Di)*Di + D0r;
			//Dni = 2*((dxr[antal] + Dr)*Di + dxi[antal]*Dr) + D0i;
			Di = Dni;
			Dr = Dnr;
		}
	}
	return antal;
}
/*
extern "C" __declspec(dllexport) int CalculateApproximation(int nType,void *pDX,void *pDY,RECT m_rApprox,
	void *pAr,void *pAi,void *pBr,void *pBi,void *pCr,void *pCi,
	void *pDr,void *pDi,void *pEr,void *pEi,void *pFr,void *pFi,void *pGr,void *pGi,
	int m_nMaxIter,void *pdxr, void *pdxi,int m_bNoApproximation,int m_nBailout)
{
	ldbl_exp &m_Ar=*(ldbl_exp *)pAr;
	ldbl_exp &m_Ai=*(ldbl_exp *)pAi;
	ldbl_exp &m_Br=*(ldbl_exp *)pBr;
	ldbl_exp &m_Bi=*(ldbl_exp *)pBi;
	ldbl_exp &m_Cr=*(ldbl_exp *)pCr;
	ldbl_exp &m_Ci=*(ldbl_exp *)pCi;
	ldbl_exp &m_Dr=*(ldbl_exp *)pDr;
	ldbl_exp &m_Di=*(ldbl_exp *)pDi;
	ldbl_exp &m_Er=*(ldbl_exp *)pEr;
	ldbl_exp &m_Ei=*(ldbl_exp *)pEi;
	ldbl_exp &m_Fr=*(ldbl_exp *)pFr;
	ldbl_exp &m_Fi=*(ldbl_exp *)pFi;
	ldbl_exp &m_Gr=*(ldbl_exp *)pGr;
	ldbl_exp &m_Gi=*(ldbl_exp *)pGi;

	ldbl_exp _1=1;
	ldbl_exp _2=2;
	int i, j;
	ldbl_exp dbTr[4], dbTi[4], dbTr0[4], dbTi0[4];

	if(nType==0){
		double *m_pDX = (double*)pDX;
		double *m_pDY = (double*)pDY;
		for(j=0;j<4;j++){
			dbTr[j]=dbTr0[j]=m_pDX[(j&1)==0?m_rApprox.left:m_rApprox.right-1];
			dbTi[j]=dbTi0[j]=m_pDY[(j&2)==0?m_rApprox.top:m_rApprox.bottom-1];
		}
	}
	int m_nMaxApproximation = m_nMaxIter;
	ldbl_exp mindiff = (m_nBailout==2?0.000001:0.01);
	if(m_bNoApproximation)
		mindiff=0;
	m_Ar=1;
	m_Ai=0;
	m_Br=0;
	m_Bi=0;
	m_Cr=0;
	m_Ci=0;
#ifdef TERM4
	m_Dr=0;
	m_Di=0;
#ifdef TERM5
	m_Er=0;
	m_Ei=0;
#ifdef TERM6
	m_Fr=0;
	m_Fi=0;
#ifdef TERM7
	m_Gr=0;
	m_Gi=0;
#endif
#endif
#endif
#endif

	ldbl_exp xr;
	ldbl_exp xi;
	ldbl_exp Ar = m_Ar;
	ldbl_exp Ai = m_Ai;
	ldbl_exp Br = m_Br;
	ldbl_exp Bi = m_Bi;
	ldbl_exp Cr = m_Cr;
	ldbl_exp Ci = m_Ci;
#ifdef TERM4
	ldbl_exp Dr = m_Dr;
	ldbl_exp Di = m_Di;
#ifdef TERM5
	ldbl_exp Er = m_Er;
	ldbl_exp Ei = m_Ei;
#ifdef TERM6
	ldbl_exp Fr = m_Fr;
	ldbl_exp Fi = m_Fi;
#ifdef TERM7
	ldbl_exp Gr = m_Gr;
	ldbl_exp Gi = m_Gi;
#endif
#endif
#endif
#endif

	for(i=1;i<m_nMaxIter;i++){
		// Series approximation
		int n=i-1;
		if(nType==0){
			double *m_db_dxr = (double*)pdxr;
			double *m_db_dxi = (double*)pdxi;
			xr = m_db_dxr[n];
			xi = m_db_dxi[n];
		}
		Ar = m_Ar;
		Ai = m_Ai;
		Br = m_Br;
		Bi = m_Bi;
		Cr = m_Cr;
		Ci = m_Ci;
#ifdef TERM4
		Dr = m_Dr;
		Di = m_Di;
#ifdef TERM5
		Er = m_Er;
		Ei = m_Ei;
#ifdef TERM6
		Fr = m_Fr;
		Fi = m_Fi;
#ifdef TERM7
		Gr = m_Gr;
		Gi = m_Gi;
#endif
#endif
#endif
#endif

		m_Ar = _2*(xr*Ar-xi*Ai) + _1;
		m_Ai = _2*(xi*Ar+xr*Ai);

		m_Br = _2*(xr*Br-xi*Bi) + Ar*Ar - Ai*Ai;
		m_Bi = _2*(xi*Br+xr*Bi) + _2*Ar*Ai;

		m_Cr = _2*(xr*Cr-xi*Ci) + _2*(Ar*Br-Ai*Bi);
		m_Ci = _2*(xi*Cr+xr*Ci) + _2*(Ai*Br+Ar*Bi);

#ifdef TERM4
		m_Dr = _2*(xr*Dr-xi*Di) + _2*(Ar*Cr-Ai*Ci) + Br*Br - Bi*Bi;
		m_Di = _2*(xi*Dr+xr*Di) + _2*(Ai*Cr+Ar*Ci) + _2*Br*Bi;
#ifdef TERM5
		m_Er = _2*(xr*Er-xi*Ei) + _2*(Ar*Dr-Ai*Di) + _2*(Br*Cr-Bi*Ci);
		m_Ei = _2*(xi*Er+xr*Ei) + _2*(Ai*Dr+Ar*Di) + _2*(Bi*Cr+Br*Ci);
#ifdef TERM6
		m_Fr = _2*(xr*Fr-xi*Fi) + _2*(Ar*Er-Ai*Ei) + _2*(Br*Dr-Bi*Di) + Cr*Cr - Ci*Ci;
		m_Fi = _2*(xi*Fr+xr*Fi) + _2*(Ai*Er+Ar*Ei) + _2*(Bi*Dr+Br*Di) + _2*Cr*Ci;
#ifdef TERM7
		m_Gr = _2*(xr*Gr-xi*Gi) + _2*(Ar*Fr-Ai*Fi) + _2*(Br*Er-Bi*Ei) + _2*(Cr*Dr-Ci*Di);
		m_Gi = _2*(xi*Gr+xr*Gi) + _2*(Ai*Fr+Ar*Fi) + _2*(Bi*Er+Br*Ei) + _2*(Ci*Dr+Cr*Di);
#endif
#endif
#endif
#endif

		if(i<m_nMaxApproximation){
			ldbl_exp dxr, dxi;
			if(nType==0){
				double *m_db_dxr = (double*)pdxr;
				double *m_db_dxi = (double*)pdxi;
				dxr = m_db_dxr[i];
				dxi = m_db_dxi[i];
			}
			for(j=0;j<4;j++){
				ldbl_exp Dnr, Dni;
				ldbl_exp D2r = dbTr0[j]*dbTr0[j]-dbTi0[j]*dbTi0[j];
				ldbl_exp D2i = _2*dbTr0[j]*dbTi0[j];
				ldbl_exp D3r = D2r*dbTr0[j]-D2i*dbTi0[j];
				ldbl_exp D3i = D2r*dbTi0[j]+D2i*dbTr0[j];
#ifdef TERM4
				ldbl_exp D4r = D3r*dbTr0[j]-D3i*dbTi0[j];
				ldbl_exp D4i = D3r*dbTi0[j]+D3i*dbTr0[j];
#ifdef TERM5
				ldbl_exp D5r = D4r*dbTr0[j]-D4i*dbTi0[j];
				ldbl_exp D5i = D4r*dbTi0[j]+D4i*dbTr0[j];
#ifdef TERM6
				ldbl_exp D6r = D5r*dbTr0[j]-D5i*dbTi0[j];
				ldbl_exp D6i = D5r*dbTi0[j]+D5i*dbTr0[j];
#ifdef TERM7
				ldbl_exp D7r = D6r*dbTr0[j]-D6i*dbTi0[j];
				ldbl_exp D7i = D6r*dbTi0[j]+D6i*dbTr0[j];
#endif
#endif
#endif
#endif
	if(i==1 && j==0){
		char szDebug[256];
		ldbl_exp D2r = _2*dbTr0[j]*dbTi0[j];
		int nTerms=3;
#ifdef TERM4
		nTerms=4;
#ifdef TERM5
		nTerms=5;
#ifdef TERM5
		nTerms=6;
#ifdef TERM7
		nTerms=7;
#endif
#endif
#endif
#endif
		
		sprintf(szDebug,"val:%f exp:%d\nnoapp=%d, bailout:%d\n%d terms used",(double)D2r.val,D2r.exp,m_bNoApproximation,m_nBailout,nTerms);
		MessageBox(NULL,szDebug,"Test-dll",MB_OK);
	}
				Dnr = m_Ar*dbTr0[j]-m_Ai*dbTi0[j];
				Dni = m_Ar*dbTi0[j]+m_Ai*dbTr0[j];
				Dnr+= m_Br*D2r-m_Bi*D2i;
				Dni+= m_Br*D2i+m_Bi*D2r;
				Dnr+= m_Cr*D3r-m_Ci*D3i;
				Dni+= m_Cr*D3i+m_Ci*D3r;
#ifdef TERM4
				Dnr+= m_Dr*D4r-m_Di*D4i;
				Dni+= m_Dr*D4i+m_Di*D4r;
#ifdef TERM5
				Dnr+= m_Er*D5r-m_Ei*D5i;
				Dni+= m_Er*D5i+m_Ei*D5r;
#ifdef TERM7
				Dnr+= m_Fr*D6r-m_Fi*D6i;
				Dni+= m_Fr*D6i+m_Fi*D6r;
				Dnr+= m_Gr*D7r-m_Gi*D7i;
				Dni+= m_Gr*D7i+m_Gi*D7r;
#endif
#endif
#endif

				ldbl_exp diff = (Dnr - dbTr[j])/dbTr[j];
				if(diff>mindiff || diff<-mindiff){
					m_nMaxApproximation=i;
					break;
				}
				diff = (Dni - dbTi[j])/dbTi[j];
				if(diff>mindiff || diff<-mindiff){
					m_nMaxApproximation=i;
					break;
				}

				Dnr = (dxr*dbTr[j] - dxi*dbTi[j])*_2 + dbTr[j]*dbTr[j] - dbTi[j]*dbTi[j] + dbTr0[j];
				Dni = (dxr*dbTi[j] + dxi*dbTr[j] + dbTr[j]*dbTi[j])*_2 + dbTi0[j];
				dbTr[j]=Dnr;
				dbTi[j]=Dni;
			}
			if(j<4)
				break;
		}
	}
	m_Ar = Ar;
	m_Ai = Ai;
	m_Br = Br;
	m_Bi = Bi;
	m_Cr = Cr;
	m_Ci = Ci;
#ifdef TERM4
	m_Dr = Dr;
	m_Di = Di;
#ifdef TERM5
	m_Er = Er;
	m_Ei = Ei;
#ifdef TERM7
	m_Fr = Fr;
	m_Fi = Fi;
	m_Gr = Gr;
	m_Gi = Gi;
#endif
#endif
#endif
	if(m_bNoApproximation)
		m_nMaxApproximation=0;
	return m_nMaxApproximation;
}
*/


